/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.table.BSnmpSequence;
import com.tridium.snmp.table.BSnmpSequenceElement;
import com.tridium.snmp.table.BSnmpTable;
import com.tridium.snmp.table.BSnmpTableRow;
import com.tridium.snmp.ui.BSnmpMgrTable;
import com.tridium.snmp.ui.SnmpIcons;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

public class BSnmpTableManager
extends BAbstractManager
implements SnmpIcons {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpTableManager == null ? (class$com$tridium$snmp$ui$BSnmpTableManager = BSnmpTableManager.class$("com.tridium.snmp.ui.BSnmpTableManager")) : class$com$tridium$snmp$ui$BSnmpTableManager));
    static Lexicon lex = new UiLexicon(class$com$tridium$snmp$ui$BSnmpTableManager == null ? (class$com$tridium$snmp$ui$BSnmpTableManager = BSnmpTableManager.class$("com.tridium.snmp.ui.BSnmpTableManager")) : class$com$tridium$snmp$ui$BSnmpTableManager);
    TableColumn[] dcols = null;
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpTableManager;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.registerForComponentEvents((BComponent)bObject, 2);
        this.createColumns((BSnmpTable)bObject);
        super.doLoadValue(bObject, context);
    }

    protected MgrModel makeModel() {
        return new SnmpTableModel(this);
    }

    protected MgrController makeController() {
        return new SnmpTableController(this);
    }

    public BImage getIcon(int n, int n2) {
        return this.dcols[n].getIcon();
    }

    private void createColumns(BSnmpTable bSnmpTable) {
        BSnmpSequence bSnmpSequence = bSnmpTable.getSequence();
        BSnmpSequenceElement[] bSnmpSequenceElementArray = bSnmpSequence.getElements();
        this.dcols = new TableColumn[bSnmpSequenceElementArray.length];
        for (int i = 0; i < bSnmpSequenceElementArray.length; ++i) {
            this.dcols[i] = new TableColumn(bSnmpSequenceElementArray[i]);
        }
    }

    static BImage getIconElem(BSnmpSequenceElement bSnmpSequenceElement) {
        switch (bSnmpSequenceElement.getVariableType().getOrdinal()) {
            case 0: 
            case 2: 
            case 3: 
            case 5: {
                return snmpNumericPointIcon;
            }
        }
        return snmpStringPointIcon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TableColumn
    extends MgrColumn {
        BImage icon = null;

        public TableColumn(BSnmpSequenceElement bSnmpSequenceElement) {
            super(bSnmpSequenceElement.getElementName(), 0);
            this.icon = BSnmpTableManager.getIconElem(bSnmpSequenceElement);
        }

        public Object get(Object object) {
            BSnmpTableRow bSnmpTableRow = (BSnmpTableRow)((Object)object);
            Property property = bSnmpTableRow.getProperty(SlotPath.escape((String)this.getDisplayName()));
            BStatusValue bStatusValue = (BStatusValue)bSnmpTableRow.get(property);
            BFacets bFacets = property.getFacets();
            return bStatusValue.toString((Context)new BasicContext(this.getManager().getCurrentContext(), bFacets));
        }

        public BImage getIcon() {
            return this.icon;
        }
    }

    class WalkMib
    extends MgrController.MgrCommand {
        private BSnmpTableManager manager;

        WalkMib(BSnmpTableManager bSnmpTableManager2) {
            super((BWidget)bSnmpTableManager2, lex, "commands.walkMib");
            this.manager = bSnmpTableManager2;
        }

        public CommandArtifact doInvoke() throws Exception {
            BSnmpTable bSnmpTable = (BSnmpTable)this.manager.getCurrentValue();
            bSnmpTable.walkMib();
            return null;
        }
    }

    class SnmpTableController
    extends MgrController {
        private MgrController.MgrCommand walkMib;

        public SnmpTableController(BSnmpTableManager bSnmpTableManager2) {
            super((BAbstractManager)bSnmpTableManager2);
            this.walkMib = new WalkMib(bSnmpTableManager2);
            this.walkMib.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.walkMib};
        }
    }

    class SnmpTableModel
    extends MgrModel {
        public SnmpTableModel(BSnmpTableManager bSnmpTableManager2) {
            super((BAbstractManager)bSnmpTableManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpTableManager.this.dcols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BSnmpTableRow.TYPE};
        }

        protected BMgrTable makeTable() {
            return new BSnmpMgrTable(this);
        }
    }
}

