/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.datatypes.BMibListEntry;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.mib.OidUtil;
import com.tridium.snmp.point.BSnmpBooleanProxyExt;
import com.tridium.snmp.point.BSnmpEnumProxyExt;
import com.tridium.snmp.point.BSnmpNumericProxyExt;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.point.BSnmpPointFolder;
import com.tridium.snmp.point.BSnmpProxyExt;
import com.tridium.snmp.point.BSnmpStringProxyExt;
import com.tridium.snmp.table.BSnmpTable;
import com.tridium.snmp.ui.BMibPathDialog;
import com.tridium.snmp.ui.BSnmpAutoMibOptions;
import com.tridium.snmp.ui.BSnmpLocalDeviceMenuAgent;
import com.tridium.snmp.ui.BSnmpPointMgrTable;
import com.tridium.snmp.ui.SnmpIcons;
import com.tridium.snmp.util.MibsUtil;
import com.tridium.snmp.util.SnmpUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.driver.ui.point.PointState;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;

public class BSnmpPointManager
extends BPointManager
implements SnmpIcons {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpPointManager == null ? (class$com$tridium$snmp$ui$BSnmpPointManager = BSnmpPointManager.class$("com.tridium.snmp.ui.BSnmpPointManager")) : class$com$tridium$snmp$ui$BSnmpPointManager));
    private Mib mib;
    static Lexicon lex = Lexicon.make((Class)(class$com$tridium$snmp$ui$BSnmpPointManager == null ? (class$com$tridium$snmp$ui$BSnmpPointManager = BSnmpPointManager.class$("com.tridium.snmp.ui.BSnmpPointManager")) : class$com$tridium$snmp$ui$BSnmpPointManager));
    static String lexOut = Lexicon.make((String)"driver").getText("out");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colString = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new ObjectIdCol();
    MgrColumn colVarType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.variableType}, 1);
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.enabled}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.deviceFacets}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.conversion}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn colFault = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colString, this.colOid, this.colVarType, this.colEnabled, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult, this.colTuning, this.colFault};
    MgrColumn dcolName = new MgrColumn.Prop(lex.getText("table.columnTitle.name"), BMibListEntry.entryName, 0);
    MgrColumn dcolOid = new MgrColumn.Prop(lex.getText("table.columnTitle.oid"), BMibListEntry.oid, 0);
    MgrColumn dcolSyntax = new MgrColumn.Prop(lex.getText("table.columnTitle.syntax"), BMibListEntry.objectSyntax, 2);
    MgrColumn dcolType = new VarTypeCol();
    MgrColumn dcolValue = new MgrColumn.Prop(lex.getText("table.columnTitle.value"), BMibListEntry.value, 0);
    MgrColumn dcolAccess = new MgrColumn.Prop(lex.getText("table.columnTitle.access"), BMibListEntry.access, 2);
    MgrColumn dcolStatus = new MgrColumn.Prop(lex.getText("table.columnTitle.status"), BMibListEntry.status, 2);
    MgrColumn dcolElementType = new MgrColumn.Prop(lex.getText("table.columnTitle.elementType"), BMibListEntry.elementType, 2);
    MgrColumn dcolDesc = new MgrColumn.Prop(lex.getText("table.columnTitle.description"), BMibListEntry.desc, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolOid, this.dcolSyntax, this.dcolType, this.dcolValue, this.dcolAccess, this.dcolStatus, this.dcolElementType, this.dcolDesc};
    BSnmpPointDeviceExt points;
    BSnmpDevice device;
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpPointManager;
    static /* synthetic */ Class class$com$tridium$snmp$datatypes$BMibListEntry;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpPointModel(this);
    }

    protected MgrController makeController() {
        return new SnmpPointController(this);
    }

    protected MgrLearn makeLearn() {
        return new SnmpPointLearn(this);
    }

    protected MgrState makeState() {
        return new SnmpPointState();
    }

    public void doLoadValue(BObject bObject, Context context) {
        if (bObject instanceof BSnmpPointFolder) {
            this.points = (BSnmpPointDeviceExt)((BSnmpPointFolder)bObject).getDeviceExt();
        } else if (bObject instanceof BSnmpPointDeviceExt) {
            this.points = (BSnmpPointDeviceExt)bObject;
        }
        this.device = (BSnmpDevice)this.points.getDevice();
        super.doLoadValue(bObject, context);
    }

    public static boolean loadMibCompiler(BAbstractManager bAbstractManager, BSnmpDevice bSnmpDevice) throws Exception {
        return BSnmpPointManager.loadMibCompiler(bAbstractManager, bSnmpDevice, new Mibs(), false);
    }

    private static boolean loadMibCompiler(BAbstractManager bAbstractManager, BSnmpDevice bSnmpDevice, Mibs mibs, boolean bl) throws Exception {
        mibs.mib = bSnmpDevice.getMib();
        if (!BSnmpPointManager.discoveryPopup(bAbstractManager, mibs, bl)) {
            return false;
        }
        bSnmpDevice.setMib(mibs.mib);
        return true;
    }

    public static Mib createMib(BAbstractManager bAbstractManager, BSnmpDevice bSnmpDevice) {
        bSnmpDevice.lease();
        String string = bSnmpDevice.getMib();
        File file = new File(string);
        if (!file.exists()) {
            BDialog.error((BWidget)bAbstractManager, (String)"Error", (Object)"Must have valid mib for device.");
            return null;
        }
        try {
            String[] stringArray = BSnmpAutoMibOptions.getDefault().getMibDirectories().getArray();
            return MibsUtil.compile(stringArray, string);
        }
        catch (MibLoaderException mibLoaderException) {
            MibLoaderLog mibLoaderLog = mibLoaderException.getLog();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            mibLoaderLog.printTo(printStream, true);
            printStream.flush();
            BTextEditor bTextEditor = new BTextEditor();
            bTextEditor.setText(byteArrayOutputStream.toString());
            mibLoaderLog.printTo(printStream, false);
            printStream.flush();
            BDialog.error((BWidget)bAbstractManager, (String)lex.getText("errors.createMib"), (Object)new BScrollPane((BWidget)bTextEditor), (String)byteArrayOutputStream.toString());
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)bAbstractManager, (String)lex.getText("errors.createMib"), (Object)throwable.toString(), (Throwable)throwable);
        }
        return null;
    }

    private Mib getMib() {
        if (this.mib == null) {
            this.mib = BSnmpPointManager.createMib((BAbstractManager)this, this.device);
        }
        return this.mib;
    }

    private static boolean discoveryPopup(BAbstractManager bAbstractManager, Mibs mibs, boolean bl) throws Exception {
        BGridPane bGridPane = new BGridPane(3);
        BTextField bTextField = new BTextField(mibs.mib, 60);
        bTextField.setEditable(false);
        BButton bButton = new BButton((Command)new Browse((BWidget)bAbstractManager.getShell(), bTextField));
        bButton.setButtonStyle(BButtonStyle.toolBar);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("pointManager.mib")));
        bGridPane.add(null, (BValue)bTextField);
        bGridPane.add(null, (BValue)bButton);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.add(null, (BValue)bGridPane);
        ToggleCommand toggleCommand = new ToggleCommand((BWidget)bGridPane2, lex.getText("pointManager.walk"));
        BRadioButton bRadioButton = new BRadioButton(toggleCommand, true, false);
        if (bl) {
            bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bRadioButton, BInsets.make((double)7.0)));
        }
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane2));
        int n = BDialog.open((BWidget)bAbstractManager, (String)lex.getText("pointManager.chooseMibs"), (Object)bEdgePane, (int)3, null);
        if (n == 2) {
            return false;
        }
        mibs.mib = bTextField.getText();
        if (bl) {
            mibs.walkMib = bRadioButton.getSelected();
        }
        return true;
    }

    private BMibListEntry[] buildEntries(Mib mib) {
        OidElement oidElement = OidUtil.createOidEntries(mib, this.device.snmpNet());
        OidEntry[] oidEntryArray = oidElement.getOidEntries();
        if (oidEntryArray == null) {
            return new BMibListEntry[0];
        }
        HashMap<String, OidEntry> hashMap = new HashMap<String, OidEntry>();
        Array array = new Array(class$com$tridium$snmp$datatypes$BMibListEntry == null ? (class$com$tridium$snmp$datatypes$BMibListEntry = BSnmpPointManager.class$("com.tridium.snmp.datatypes.BMibListEntry")) : class$com$tridium$snmp$datatypes$BMibListEntry, oidEntryArray.length);
        for (int i = 0; i < oidEntryArray.length; ++i) {
            try {
                OidEntry oidEntry = oidEntryArray[i];
                BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = oidEntry.getElementType();
                if (bSnmpMipEntryTypeEnum.equals((Object)BSnmpMipEntryTypeEnum.trap) || bSnmpMipEntryTypeEnum.equals((Object)BSnmpMipEntryTypeEnum.notification) || hashMap.get(oidEntry.getOid()) != null) continue;
                hashMap.put(oidEntry.getOid(), oidEntry);
                BMibListEntry bMibListEntry = new BMibListEntry();
                bMibListEntry.setOid(oidEntry.getOid());
                bMibListEntry.setAccess(oidEntry.getAccess());
                bMibListEntry.setEntryName(oidEntry.getName());
                bMibListEntry.setStatus(oidEntry.getStatus());
                bMibListEntry.setObjectSyntax(oidEntry.getObjSyntax());
                bMibListEntry.setElementType(oidEntry.getElementType());
                if (oidEntry.getDesc() != null) {
                    bMibListEntry.setDesc(oidEntry.getDesc());
                }
                if (oidEntry.getVariableType() != null) {
                    bMibListEntry.setVariableType(oidEntry.getVariableType());
                }
                if (oidEntry.enumRange != null) {
                    bMibListEntry.setEnumRange(oidEntry.enumRange);
                }
                if (oidEntry.range != null) {
                    bMibListEntry.setConstraint(oidEntry.getRangeFacets());
                }
                array.add((Object)bMibListEntry);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return (BMibListEntry[])array.trim();
    }

    static String chooseMibFiles(BWidget bWidget) throws Exception {
        Object object;
        Object object2;
        BSnmpAutoMibOptions bSnmpAutoMibOptions = BSnmpAutoMibOptions.getDefault();
        BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)bWidget);
        bFileChooser.setTitle(lex.getText("pointManager.chooseMibs"));
        String string = bSnmpAutoMibOptions.getLastMibFile();
        if (string.length() > 0) {
            object2 = new File(string);
            object = ((File)object2).getParentFile();
            BOrd bOrd = BOrd.make((String)("file:/" + ((File)object).getAbsolutePath().replace('\\', '/')));
            bFileChooser.setCurrentDirectory(bOrd);
        }
        if ((object2 = bFileChooser.show()) == null) {
            return null;
        }
        object = SnmpUtil.ordToAbsolutePath((BOrd)object2);
        bSnmpAutoMibOptions.setLastMibFile((String)object);
        bSnmpAutoMibOptions.save();
        return object;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getId() == 5 && bComponentEvent.getSourceComponent() == this.points && BSnmpPointDeviceExt.mibWalkedEvent == bComponentEvent.getSlot()) {
            this.updateDiscoveryRows((BComponent)bComponentEvent.getValue());
        } else {
            super.handleComponentEvent(bComponentEvent);
        }
    }

    private void updateDiscoveryRows(BComponent bComponent) {
        BMibListTable bMibListTable = (BMibListTable)bComponent;
        ((SnmpPointLearn)this.getLearn()).updateTable(bMibListTable.getPointList());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class VarTypeCol
    extends MgrColumn {
        public VarTypeCol() {
            super(lex.getText("table.columnTitle.type"), 2);
        }

        public Object get(Object object) {
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            if (bMibListEntry.getAccess() == BSnmpAccessEnum.notAccessible) {
                return "";
            }
            return bMibListEntry.getVariableType();
        }
    }

    static class ObjectIdCol
    extends MgrColumn {
        static Property[] props = new Property[]{BControlPoint.proxyExt, BSnmpProxyExt.objectIdentifier};

        public ObjectIdCol() {
            super(lex.getText("exportManager.objectIdentifier"), 1);
        }

        public Object get(Object object) {
            if (object instanceof BControlPoint) {
                return ((BSnmpProxyExt)((BControlPoint)object).getProxyExt()).getObjectIdentifier();
            }
            if (object instanceof BSnmpTable) {
                return ((BSnmpTable)((Object)object)).getObjectIdentifier();
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) throws Exception {
            return BString.make((String)((String)this.get(mgrEditRow.getTarget())));
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) throws Exception {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                ((BSnmpProxyExt)((BControlPoint)bComponent).getProxyExt()).setObjectIdentifier(((BString)bValue).toString());
            } else if (bComponent instanceof BSnmpTable) {
                ((BSnmpTable)bComponent).setObjectIdentifier(((BString)bValue).toString());
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            return ObjectIdCol.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])props);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            ObjectIdCol.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])props);
        }
    }

    static class Browse
    extends Command {
        BTextField txt;

        Browse(BWidget bWidget, BTextField bTextField) {
            super(bWidget, "");
            this.txt = bTextField;
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd;
            BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)this.getShell());
            String string = this.txt.getText();
            if ((string = string.replace('\\', '/')).lastIndexOf(47) > 0) {
                bFileChooser.setCurrentDirectory(SnmpUtil.absolutePathToDirOrd(string));
            }
            if ((bOrd = bFileChooser.show()) != null) {
                this.txt.setText(SnmpUtil.ordToAbsolutePath(bOrd));
            }
            return null;
        }

        public BImage getIcon() {
            return BSnmpLocalDeviceMenuAgent.browseIcon;
        }
    }

    private static class Mibs {
        String mib;
        boolean walkMib = false;

        private Mibs() {
        }
    }

    class AddTable
    extends MgrController.MgrCommand {
        private BSnmpPointManager manager;

        AddTable(BSnmpPointManager bSnmpPointManager2) {
            super((BWidget)bSnmpPointManager2, lex, "commands.addTable");
            this.manager = bSnmpPointManager2;
        }

        public CommandArtifact doInvoke() throws Exception {
            SnmpPointLearn snmpPointLearn = (SnmpPointLearn)this.manager.getLearn();
            if (snmpPointLearn == null) {
                return null;
            }
            BComponent bComponent = snmpPointLearn.target;
            Object[] objectArray = snmpPointLearn.getTable().getSelectedObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                BMibListEntry bMibListEntry = (BMibListEntry)((Object)objectArray[i]);
                if (!bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequence)) continue;
                Mib mib = BSnmpPointManager.this.getMib();
                if (mib == null) {
                    return null;
                }
                BSnmpTable bSnmpTable = new BSnmpTable(bMibListEntry.getOid(), mib);
                bComponent.add(SlotPath.escape((String)bMibListEntry.getEntryName()), (BValue)bSnmpTable);
            }
            return null;
        }
    }

    class ConfigAutoMibs
    extends MgrController.MgrCommand {
        private BSnmpPointManager manager;

        ConfigAutoMibs(BSnmpPointManager bSnmpPointManager2) {
            super((BWidget)bSnmpPointManager2, lex.getText("mibPathDialog.command.label"));
            this.manager = bSnmpPointManager2;
        }

        public CommandArtifact doInvoke() throws Exception {
            BMibPathDialog bMibPathDialog = new BMibPathDialog((BAbstractManager)this.manager);
            bMibPathDialog.open();
            return null;
        }
    }

    class SnmpPointController
    extends PointController {
        private MgrController.MgrCommand configAutoMibs;
        private MgrController.MgrCommand addTable;

        SnmpPointController(BSnmpPointManager bSnmpPointManager2) {
            super((BPointManager)bSnmpPointManager2);
            this.configAutoMibs = new ConfigAutoMibs(bSnmpPointManager2);
            this.addTable = new AddTable(bSnmpPointManager2);
            if (bSnmpPointManager2.isLearnable()) {
                this.configAutoMibs.setFlags(1);
            }
            this.addTable.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.newCommand, this.edit, this.learnMode, this.discover, this.add, this.quickAdd, this.addTable, this.match, this.quickMatch, this.configAutoMibs};
        }

        public void updateCommands() {
            super.updateCommands();
            SnmpPointLearn snmpPointLearn = (SnmpPointLearn)this.getManager().getLearn();
            if (snmpPointLearn == null || snmpPointLearn.getTable() == null) {
                return;
            }
            Object[] objectArray = snmpPointLearn.getTable().getSelectedObjects();
            boolean bl = this.learnMode.isSelected() && objectArray.length == 1 && objectArray[0] instanceof BMibListEntry && ((BMibListEntry)((Object)objectArray[0])).getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequence);
            this.addTable.setEnabled(bl);
            boolean bl2 = this.learnMode.isSelected() && objectArray.length > 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (((BMibListEntry)((Object)objectArray[i])).getElementType().isAccessibleValue()) continue;
                bl2 = false;
            }
            this.add.setEnabled(bl2);
        }

        public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
            BComponent bComponent = this.getTable().getComponentAt(n);
            BWbShell bWbShell = this.getManager().getWbShell();
            if (bComponent != null && bComponent.getType().is(BSnmpTable.TYPE) && bWbShell != null) {
                bWbShell.hyperlink(new HyperlinkInfo(bComponent.getNavOrd(), (BInputEvent)bMouseEvent));
                return;
            }
            super.cellDoubleClicked(bMgrTable, bMouseEvent, n, n2);
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand iMgrCommand) {
            if (iMgrCommand == this.discover) {
                return new MgrController.IMgrCommand[]{this.configAutoMibs};
            }
            return super.getDropDownCommands(iMgrCommand);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            Mibs mibs = new Mibs();
            BSnmpPointManager bSnmpPointManager = (BSnmpPointManager)this.getManager();
            if (!BSnmpPointManager.loadMibCompiler((BAbstractManager)bSnmpPointManager, BSnmpPointManager.this.device, mibs, true)) {
                return null;
            }
            BSnmpPointManager.this.mib = BSnmpPointManager.createMib((BAbstractManager)bSnmpPointManager, BSnmpPointManager.this.device);
            if (BSnmpPointManager.this.mib != null) {
                BMibListEntry[] bMibListEntryArray = BSnmpPointManager.this.buildEntries(BSnmpPointManager.this.mib);
                ((SnmpPointLearn)BSnmpPointManager.this.getLearn()).updateTable(bMibListEntryArray);
                if (mibs.walkMib) {
                    BSnmpPointManager.this.getLearn().setJob(BSnmpPointManager.this.device.walkMib(new BMibListTable(bMibListEntryArray)));
                }
            }
            return super.doDiscover(context);
        }

        protected CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
            MgrEdit mgrEdit = new MgrEdit(this.getManager(), this.add.getLabel());
            for (int i = 0; i < objectArray.length; ++i) {
                BMibListEntry[] bMibListEntryArray;
                Object object = objectArray[i];
                BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
                if (bMibListEntry.hasChildren()) {
                    bMibListEntryArray = bMibListEntry.getChildren();
                    for (int j = 0; j < bMibListEntryArray.length; ++j) {
                        MgrTypeInfo[] mgrTypeInfoArray = this.getManager().getLearn().toTypes((Object)bMibListEntryArray[j]);
                        if (mgrTypeInfoArray == null || mgrTypeInfoArray.length == 0) continue;
                        MgrEditRow mgrEditRow = mgrEdit.addRow((Object)bMibListEntryArray[j], mgrTypeInfoArray);
                        this.getManager().getLearn().toRow((Object)bMibListEntryArray[j], mgrEditRow);
                    }
                    continue;
                }
                bMibListEntryArray = this.getManager().getLearn().toTypes(object);
                if (bMibListEntryArray == null || bMibListEntryArray.length == 0) continue;
                MgrEditRow mgrEditRow = mgrEdit.addRow(object, (MgrTypeInfo[])bMibListEntryArray);
                this.getManager().getLearn().toRow(object, mgrEditRow);
            }
            return mgrEdit.invoke(context);
        }
    }

    class SnmpPointState
    extends PointState {
        BMibListEntry[] lastLearn;
        BSnmpDevice dev;

        SnmpPointState() {
        }

        protected void saveForType(BAbstractManager bAbstractManager) {
            super.saveForType(bAbstractManager);
            BSnmpPointManager bSnmpPointManager = (BSnmpPointManager)bAbstractManager;
            SnmpPointLearn snmpPointLearn = (SnmpPointLearn)bSnmpPointManager.getLearn();
            this.lastLearn = snmpPointLearn.lastLearn;
            this.dev = bSnmpPointManager.device;
        }

        protected void restoreForType(BAbstractManager bAbstractManager) {
            super.restoreForType(bAbstractManager);
            BSnmpPointManager bSnmpPointManager = (BSnmpPointManager)bAbstractManager;
            SnmpPointLearn snmpPointLearn = (SnmpPointLearn)bSnmpPointManager.getLearn();
            if (this.lastLearn != null && this.dev != null && this.dev.equals((Object)bSnmpPointManager.device)) {
                snmpPointLearn.updateTable(this.lastLearn);
            }
        }
    }

    class SnmpPointLearn
    extends MgrLearn {
        BComponent target;
        BMibListEntry[] lastLearn;

        SnmpPointLearn(BSnmpPointManager bSnmpPointManager2) {
            super((BAbstractManager)bSnmpPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpPointManager.this.dcols;
        }

        public boolean isDepthExpandable(int n) {
            return true;
        }

        public boolean hasChildren(Object object) {
            return ((BMibListEntry)((Object)object)).hasChildren();
        }

        public Object[] getChildren(Object object) {
            return ((BMibListEntry)((Object)object)).getChildren();
        }

        public boolean isMatchable(Object object, BComponent bComponent) {
            if (!(bComponent instanceof BControlPoint)) {
                return false;
            }
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = bMibListEntry.getElementType();
            if (!bSnmpMipEntryTypeEnum.isAccessibleValue()) {
                return false;
            }
            boolean bl = bMibListEntry.getAccess().equals((Object)BSnmpAccessEnum.readOnly);
            BControlPoint bControlPoint = (BControlPoint)bComponent;
            return !bControlPoint.isWritablePoint() || !bl;
        }

        public BImage getIcon(Object object) {
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            if (bMibListEntry.getAccess().equals((Object)BSnmpAccessEnum.notAccessible)) {
                return SnmpIcons.snmpNotAccessibleIcon;
            }
            if (bMibListEntry.getElementType().equals((Object)BSnmpMipEntryTypeEnum.sequenceElement)) {
                return SnmpIcons.snmpSequenceElementIcon;
            }
            String string = bMibListEntry.getObjectSyntax();
            if (string.equalsIgnoreCase("TruthValue")) {
                return SnmpIcons.snmpBooleanObjectIcon;
            }
            if (string.equalsIgnoreCase("INTEGER") && bMibListEntry.hasEnumRange()) {
                return SnmpIcons.snmpEnumObjectIcon;
            }
            if (bMibListEntry.getVariableType().isNumeric()) {
                return SnmpIcons.snmpNumericObjectIcon;
            }
            return SnmpIcons.snmpStringObjectIcon;
        }

        public MgrTypeInfo[] toTypes(Object object) {
            boolean bl;
            ArrayList arrayList = new ArrayList();
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            String string = bMibListEntry.getObjectSyntax();
            BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum = bMibListEntry.getElementType();
            if (!bSnmpMipEntryTypeEnum.isAccessibleValue()) {
                return new MgrTypeInfo[0];
            }
            boolean bl2 = bl = !bMibListEntry.getAccess().equals((Object)BSnmpAccessEnum.readOnly);
            if (string.equalsIgnoreCase("TruthValue")) {
                PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
                PointModel.addNumericPointTypes(arrayList, (boolean)bl);
                PointModel.addStringPointTypes(arrayList, (boolean)bl);
            } else if (string.equalsIgnoreCase("INTEGER") && bMibListEntry.hasEnumRange()) {
                PointModel.addEnumPointTypes(arrayList, (boolean)bl);
                if (bMibListEntry.getEnumRange().getOrdinals().length == 2) {
                    PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
                }
                PointModel.addStringPointTypes(arrayList, (boolean)bl);
            } else if (bMibListEntry.getVariableType().isNumeric()) {
                PointModel.addNumericPointTypes(arrayList, (boolean)bl);
                PointModel.addStringPointTypes(arrayList, (boolean)bl);
                PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
                PointModel.addEnumPointTypes(arrayList, (boolean)bl);
            } else {
                PointModel.addStringPointTypes(arrayList, (boolean)bl);
                PointModel.addNumericPointTypes(arrayList, (boolean)bl);
                PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
                PointModel.addEnumPointTypes(arrayList, (boolean)bl);
            }
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            BControlPoint bControlPoint = (BControlPoint)mgrEditRow.getTarget();
            mgrEditRow.setDefaultName(SlotPath.escape((String)bMibListEntry.getEntryName()));
            mgrEditRow.setCell(BSnmpPointManager.this.colOid, (BValue)BString.make((String)bMibListEntry.getOid()));
            BSnmpVariableTypeEnum bSnmpVariableTypeEnum = bMibListEntry.getVariableType();
            mgrEditRow.setCell(BSnmpPointManager.this.colVarType, (BValue)bSnmpVariableTypeEnum);
            BFacets bFacets = bControlPoint.getFacets();
            if (bMibListEntry.hasEnumRange()) {
                BEnumRange bEnumRange;
                int[] nArray;
                boolean bl;
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.makeEnum((BEnumRange)bMibListEntry.getEnumRange()));
                String string = mgrEditRow.getType().getDisplayName();
                boolean bl2 = bl = string.indexOf("Boolean") >= 0;
                if (bl && bMibListEntry.hasEnumRange() && (nArray = (bEnumRange = bMibListEntry.getEnumRange()).getOrdinals()).length == 2) {
                    bFacets = BFacets.make((BFacets)bFacets, (BFacets)BFacets.makeBoolean((String)bEnumRange.getTag(nArray[0]), (String)bEnumRange.getTag(nArray[1])));
                }
            } else if (bMibListEntry.getConstraint().getFacet("min") != null) {
                bFacets = BFacets.make((BFacets)bFacets, (BFacets)bMibListEntry.getConstraint());
            }
            BSnmpProxyExt.adjustFacets(bFacets, bSnmpVariableTypeEnum);
            mgrEditRow.setCell(BSnmpPointManager.this.colDeviceFacets, (BValue)bFacets);
            mgrEditRow.setCell(BSnmpPointManager.this.colFacets, (BValue)bFacets);
        }

        public boolean isExisting(Object object, BComponent bComponent) {
            BMibListEntry bMibListEntry = (BMibListEntry)((Object)object);
            if (bComponent instanceof BControlPoint) {
                BControlPoint bControlPoint = (BControlPoint)bComponent;
                BSnmpProxyExt bSnmpProxyExt = (BSnmpProxyExt)bControlPoint.getProxyExt();
                return bSnmpProxyExt.getObjectIdentifier().equals(bMibListEntry.getOid());
            }
            return false;
        }

        public void updateTable(BMibListEntry[] bMibListEntryArray) {
            this.lastLearn = bMibListEntryArray;
            this.updateRoots((Object[])bMibListEntryArray);
        }

        public void load(BComponent bComponent) {
            this.target = bComponent;
        }
    }

    class SnmpPointModel
    extends PointModel {
        SnmpPointModel(BSnmpPointManager bSnmpPointManager2) {
            super((BPointManager)bSnmpPointManager2);
        }

        protected BMgrTable makeTable() {
            return new BSnmpPointMgrTable((MgrModel)this);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BControlPoint.TYPE, BPointFolder.TYPE, BSnmpTable.TYPE};
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList arrayList = new ArrayList();
            SnmpPointModel.addBooleanPointTypes(arrayList, (boolean)true);
            SnmpPointModel.addNumericPointTypes(arrayList, (boolean)true);
            SnmpPointModel.addStringPointTypes(arrayList, (boolean)true);
            SnmpPointModel.addEnumPointTypes(arrayList, (boolean)true);
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BControlPoint bControlPoint = (BControlPoint)mgrTypeInfo.newInstance();
            BFacets bFacets = (BFacets)bControlPoint.getFacets().newCopy();
            Object object = new BNullProxyExt();
            if (bControlPoint instanceof BBooleanPoint) {
                object = new BSnmpBooleanProxyExt();
                ((BProxyExt)object).setDeviceFacets(bFacets);
            } else if (bControlPoint instanceof BNumericPoint) {
                object = new BSnmpNumericProxyExt();
                ((BProxyExt)object).setDeviceFacets(bFacets);
            } else if (bControlPoint instanceof BEnumPoint) {
                object = new BSnmpEnumProxyExt();
                ((BProxyExt)object).setDeviceFacets(bFacets);
            } else if (bControlPoint instanceof BStringPoint) {
                object = new BSnmpStringProxyExt();
                ((BProxyExt)object).setDeviceFacets(bFacets);
            }
            bControlPoint.setProxyExt((BAbstractProxyExt)object);
            return bControlPoint;
        }
    }
}

