/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.BSnmpAgent;
import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpDeviceFolder;
import com.tridium.snmp.BSnmpNetwork;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BSnmpDeviceManager
extends BDeviceManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpDeviceManager == null ? (class$com$tridium$snmp$ui$BSnmpDeviceManager = BSnmpDeviceManager.class$("com.tridium.snmp.ui.BSnmpDeviceManager")) : class$com$tridium$snmp$ui$BSnmpDeviceManager));
    static final Lexicon superLexicon = Lexicon.make((Class)(class$javax$baja$workbench$mgr$MgrController == null ? (class$javax$baja$workbench$mgr$MgrController = BSnmpDeviceManager.class$("javax.baja.workbench.mgr.MgrController")) : class$javax$baja$workbench$mgr$MgrController));
    static final Lexicon lexicon = Lexicon.make((Class)(class$com$tridium$snmp$ui$BSnmpDeviceManager == null ? (class$com$tridium$snmp$ui$BSnmpDeviceManager = BSnmpDeviceManager.class$("com.tridium.snmp.ui.BSnmpDeviceManager")) : class$com$tridium$snmp$ui$BSnmpDeviceManager));
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(7);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BSnmpDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    MgrColumn colPollFreq = new SnmpProp(BSnmpDevice.pollFrequency, 3);
    MgrColumn colVersion = new SnmpProp(BSnmpDevice.snmpVersion, 3);
    MgrColumn colAddress = new SnmpProp(BSnmpDevice.ipAddress, 1);
    MgrColumn colPort = new SnmpProp(BSnmpDevice.port, 1);
    MgrColumn colCommunity = new SnmpProp(BSnmpDevice.community, 3);
    MgrColumn colMaxVarBinds = new SnmpProp(BSnmpDevice.maxVariableBindingsPerRequest, 3);
    MgrColumn colRetries = new SnmpProp(BSnmpDevice.retryCount, 3);
    MgrColumn colTimeout = new SnmpProp(BSnmpDevice.responseTimeout, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colStatus, this.colEnabled, this.colHealth, this.colPollFreq, this.colVersion, this.colAddress, this.colPort, this.colCommunity, this.colMaxVarBinds, this.colRetries, this.colTimeout};
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpDeviceManager;
    static /* synthetic */ Class class$com$tridium$snmp$BSnmpAgent;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController;

    public Type getType() {
        return TYPE;
    }

    public BSnmpNetwork getNetwork() {
        if (this.getCurrentValue() instanceof BSnmpNetwork) {
            return (BSnmpNetwork)this.getCurrentValue();
        }
        if (this.getCurrentValue() instanceof BSnmpDeviceFolder) {
            return (BSnmpNetwork)((BSnmpDeviceFolder)this.getCurrentValue()).getNetwork();
        }
        return null;
    }

    protected MgrModel makeModel() {
        return new SnmpModel(this);
    }

    protected MgrController makeController() {
        return new SnmpController(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SnmpProp
    extends MgrColumn.Prop {
        public SnmpProp(String string, Property property, int n) {
            super(string, property, n);
        }

        public SnmpProp(Property property, int n) {
            super(property, n);
        }

        public SnmpProp(Property property) {
            super(property);
        }

        public Object get(Object object) {
            if (object instanceof BSnmpAgent) {
                return BString.DEFAULT;
            }
            return super.get(object);
        }

        public BValue load(MgrEditRow mgrEditRow) {
            if (mgrEditRow.getTarget() instanceof BSnmpAgent) {
                return BString.DEFAULT;
            }
            return super.load(mgrEditRow);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            if (mgrEditRow.getTarget() instanceof BSnmpAgent) {
                return;
            }
            super.save(mgrEditRow, bValue, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                if (!(mgrEditRowArray[i].getTarget() instanceof BSnmpAgent)) continue;
                return null;
            }
            return super.toEditor(mgrEditRowArray, n, bWbEditor);
        }
    }

    public class SnmpController
    extends DeviceController {
        public SnmpController(BDeviceManager bDeviceManager) {
            super(bDeviceManager);
        }

        public MgrEdit promptForNew(Context context) throws Exception {
            Object[] objectArray;
            MgrModel mgrModel = this.getManager().getModel();
            MgrTypeInfo[] mgrTypeInfoArray = this.getManager().getModel().getNewTypes();
            if (mgrTypeInfoArray == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown bListDropDown = new BListDropDown();
            for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
                bListDropDown.getList().addItem((Object)mgrTypeInfoArray[i]);
            }
            bListDropDown.setSelectedIndex(0);
            BTextField bTextField = new BTextField("1", 6);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            bGridPane.add(null, (BValue)bListDropDown);
            bGridPane.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            bGridPane.add(null, (BValue)bTextField);
            String string = this.newCommand.getLabel();
            int n = BDialog.open((BWidget)this.getManager(), (String)string, (Object)bGridPane, (int)3);
            if (n == 2) {
                return null;
            }
            MgrTypeInfo mgrTypeInfo = (MgrTypeInfo)bListDropDown.getSelectedItem();
            BComponent bComponent = mgrModel.newInstance(mgrTypeInfo);
            int n2 = Integer.parseInt(bTextField.getText());
            if (bComponent != null && bComponent instanceof BSnmpAgent) {
                objectArray = BSnmpDeviceManager.this.getNetwork().getChildren(class$com$tridium$snmp$BSnmpAgent == null ? (class$com$tridium$snmp$BSnmpAgent = BSnmpDeviceManager.class$("com.tridium.snmp.BSnmpAgent")) : class$com$tridium$snmp$BSnmpAgent);
                if (objectArray != null && objectArray.length > 0) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.agentAlreadyExists"));
                    return null;
                }
                n2 = 1;
            }
            objectArray = this.makeEdit(string);
            for (int i = 0; i < n2; ++i) {
                MgrEditRow mgrEditRow = new MgrEditRow(mgrModel.newInstance(mgrTypeInfo), null, mgrTypeInfoArray);
                objectArray.addRow(mgrEditRow);
            }
            return objectArray;
        }
    }

    public class SnmpModel
    extends DeviceModel {
        public SnmpModel(BSnmpDeviceManager bSnmpDeviceManager2) {
            super((BDeviceManager)bSnmpDeviceManager2);
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BSnmpDevice.TYPE)};
            return mgrTypeInfoArray;
        }

        public MgrColumn[] makeColumns() {
            return BSnmpDeviceManager.this.cols;
        }
    }
}

