/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.ui;

import com.tridium.snmp.datatypes.BSnmpAgentBooleanDefaultValue;
import com.tridium.snmp.datatypes.BSnmpAgentNumericDefaultValue;
import com.tridium.snmp.datatypes.BSnmpAgentStringDefaultValue;
import com.tridium.snmp.point.agent.BSnmpAgentBooleanProxyExt;
import com.tridium.snmp.point.agent.BSnmpAgentEnumProxyExt;
import com.tridium.snmp.point.agent.BSnmpAgentNumericProxyExt;
import com.tridium.snmp.point.agent.BSnmpAgentPointDeviceExt;
import com.tridium.snmp.point.agent.BSnmpAgentPointFolder;
import com.tridium.snmp.point.agent.BSnmpAgentProxyExt;
import com.tridium.snmp.point.agent.BSnmpAgentStringProxyExt;
import java.util.ArrayList;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BSnmpAgentPointManager
extends BPointManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$ui$BSnmpAgentPointManager == null ? (class$com$tridium$snmp$ui$BSnmpAgentPointManager = BSnmpAgentPointManager.class$("com.tridium.snmp.ui.BSnmpAgentPointManager")) : class$com$tridium$snmp$ui$BSnmpAgentPointManager));
    static Lexicon lexicon = Lexicon.make((Class)(class$com$tridium$snmp$ui$BSnmpAgentPointManager == null ? (class$com$tridium$snmp$ui$BSnmpAgentPointManager = BSnmpAgentPointManager.class$("com.tridium.snmp.ui.BSnmpAgentPointManager")) : class$com$tridium$snmp$ui$BSnmpAgentPointManager));
    static Lexicon driverLex = Lexicon.make((String)"driver");
    static String lexOut = driverLex.getText("out");
    BSnmpAgentPointDeviceExt deviceExt;
    private int lastInputIndex = 0;
    private int lastOutputIndex = 0;
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colString = new MgrColumn.ToString(lexOut, 0);
    MgrColumn colOid = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.objectIdentifier}, 0);
    MgrColumn colIndex = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.index}, 3);
    MgrColumn colDefaultVal = new SnmpAgentDefaultCol();
    MgrColumn colAgentTable = new SnmpAgentTableCol();
    MgrColumn colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.enabled}, 3);
    MgrColumn colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.deviceFacets}, 3);
    MgrColumn colFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.facets}, 3);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BSnmpAgentProxyExt.conversion}, 3);
    MgrColumn colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
    MgrColumn colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
    MgrColumn colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colString, this.colOid, this.colIndex, this.colDefaultVal, this.colAgentTable, this.colEnabled, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult, this.colTuning};
    static /* synthetic */ Class class$com$tridium$snmp$ui$BSnmpAgentPointManager;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpAgentPointModel(this);
    }

    protected MgrController makeController() {
        return new SnmpAgentPointController(this);
    }

    private void initExt(BSnmpAgentProxyExt bSnmpAgentProxyExt, BFacets bFacets, boolean bl) {
        if (bl) {
            this.lastOutputIndex = this.deviceExt.findNextOutputIndex(BInteger.make((int)this.lastOutputIndex)).getInt();
            bSnmpAgentProxyExt.setIndex(this.lastOutputIndex);
        } else {
            this.lastInputIndex = this.deviceExt.findNextInputIndex(BInteger.make((int)this.lastInputIndex)).getInt();
            bSnmpAgentProxyExt.setIndex(this.lastInputIndex);
        }
        bSnmpAgentProxyExt.setDeviceFacets(bFacets);
    }

    public void doLoadValue(BObject bObject, Context context) {
        if (bObject instanceof BSnmpAgentPointDeviceExt) {
            this.deviceExt = (BSnmpAgentPointDeviceExt)bObject;
        } else if (bObject instanceof BSnmpAgentPointFolder) {
            this.deviceExt = (BSnmpAgentPointDeviceExt)((BSnmpAgentPointFolder)bObject).getDeviceExt();
        }
        super.doLoadValue(bObject, context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SnmpAgentTableCol
    extends MgrColumn {
        public SnmpAgentTableCol() {
            super(lexicon.getText("agentTable.columnTitle.agentTable"), 2);
        }

        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BSnmpAgentProxyExt) {
                if (((BControlPoint)object).isWritablePoint()) {
                    return lexicon.getText("agentTable.strings.output");
                }
                return lexicon.getText("agentTable.strings.input");
            }
            return "";
        }
    }

    public static class SnmpAgentDefaultCol
    extends MgrColumn {
        boolean isDefault = false;

        public SnmpAgentDefaultCol() {
            super(lexicon.getText("agentTable.columnTitle.defaultValue"), 3);
        }

        public Object get(Object object) {
            if (object instanceof BControlPoint && !((BControlPoint)object).isWritablePoint()) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)object).getProxyExt();
                if (bAbstractProxyExt instanceof BSnmpAgentBooleanProxyExt) {
                    return ((BSnmpAgentBooleanProxyExt)bAbstractProxyExt).getDefaultValue();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentNumericProxyExt) {
                    return ((BSnmpAgentNumericProxyExt)bAbstractProxyExt).getDefaultValue();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentStringProxyExt) {
                    return ((BSnmpAgentStringProxyExt)bAbstractProxyExt).getDefaultValue();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentEnumProxyExt) {
                    return ((BSnmpAgentEnumProxyExt)bAbstractProxyExt).getDefaultValue();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && !((BControlPoint)bComponent).isWritablePoint()) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BSnmpAgentBooleanProxyExt) {
                    return ((BSnmpAgentBooleanProxyExt)bAbstractProxyExt).getDefaultValue().newCopy();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentNumericProxyExt) {
                    return ((BSnmpAgentNumericProxyExt)bAbstractProxyExt).getDefaultValue().newCopy();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentStringProxyExt) {
                    return ((BSnmpAgentStringProxyExt)bAbstractProxyExt).getDefaultValue().newCopy();
                }
                if (bAbstractProxyExt instanceof BSnmpAgentEnumProxyExt) {
                    return ((BSnmpAgentEnumProxyExt)bAbstractProxyExt).getDefaultValue().newCopy();
                }
            }
            this.isDefault = true;
            return BString.DEFAULT;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                if (((BControlPoint)bComponent).isWritablePoint()) {
                    return;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BSnmpAgentBooleanProxyExt) {
                    ((BSnmpAgentBooleanProxyExt)bAbstractProxyExt).setDefaultValue((BSnmpAgentBooleanDefaultValue)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BSnmpAgentNumericProxyExt) {
                    ((BSnmpAgentNumericProxyExt)bAbstractProxyExt).setDefaultValue((BSnmpAgentNumericDefaultValue)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BSnmpAgentStringProxyExt) {
                    ((BSnmpAgentStringProxyExt)bAbstractProxyExt).setDefaultValue((BSnmpAgentStringDefaultValue)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BSnmpAgentEnumProxyExt) {
                    ((BSnmpAgentEnumProxyExt)bAbstractProxyExt).setDefaultValue((BSnmpAgentStringDefaultValue)bValue.newCopy());
                }
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            Type type = null;
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                propertyArray = mgrEditRowArray[i].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)propertyArray).isWritablePoint()) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (type == null && (type = bAbstractProxyExt.getType()) != BSnmpAgentBooleanProxyExt.TYPE && type != BSnmpAgentNumericProxyExt.TYPE && type != BSnmpAgentStringProxyExt.TYPE && type != BSnmpAgentEnumProxyExt.TYPE) {
                    return null;
                }
                if (type == bAbstractProxyExt.getType()) continue;
                return null;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("defaultValue")};
            return SnmpAgentDefaultCol.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, null, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("defaultValue")};
            SnmpAgentDefaultCol.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }
    }

    class SnmpAgentPointController
    extends PointController {
        SnmpAgentPointController(BSnmpAgentPointManager bSnmpAgentPointManager2) {
            super((BPointManager)bSnmpAgentPointManager2);
        }

        public CommandArtifact doNew(Context context) throws Exception {
            BSnmpAgentPointManager.this.lastInputIndex = 0;
            BSnmpAgentPointManager.this.lastOutputIndex = 0;
            return super.doNew(context);
        }
    }

    public class SnmpAgentPointModel
    extends PointModel {
        SnmpAgentPointModel(BSnmpAgentPointManager bSnmpAgentPointManager2) {
            super((BPointManager)bSnmpAgentPointManager2);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpAgentPointManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList arrayList = new ArrayList();
            SnmpAgentPointModel.addBooleanPointTypes(arrayList, (boolean)true);
            SnmpAgentPointModel.addNumericPointTypes(arrayList, (boolean)true);
            SnmpAgentPointModel.addStringPointTypes(arrayList, (boolean)true);
            SnmpAgentPointModel.addEnumPointTypes(arrayList, (boolean)true);
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BControlPoint bControlPoint = (BControlPoint)mgrTypeInfo.newInstance();
            BFacets bFacets = (BFacets)bControlPoint.getFacets().newCopy();
            Object object = new BNullProxyExt();
            if (bControlPoint instanceof BBooleanPoint) {
                object = new BSnmpAgentBooleanProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)object, bFacets, bControlPoint.isWritablePoint());
            } else if (bControlPoint instanceof BNumericPoint) {
                object = new BSnmpAgentNumericProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)object, bFacets, bControlPoint.isWritablePoint());
            } else if (bControlPoint instanceof BStringPoint) {
                object = new BSnmpAgentStringProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)object, bFacets, bControlPoint.isWritablePoint());
            } else if (bControlPoint instanceof BEnumPoint) {
                object = new BSnmpAgentEnumProxyExt();
                BSnmpAgentPointManager.this.initExt((BSnmpAgentProxyExt)object, bFacets, bControlPoint.isWritablePoint());
            }
            bControlPoint.setProxyExt((BAbstractProxyExt)object);
            return bControlPoint;
        }
    }
}

