/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.ASNInput;
import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpCounter;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpGauge;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpIpAddress;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpOpaque;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpTimeticks;

public abstract class SnmpVar
implements SnmpConst {
    public int type;

    public static SnmpVar getSnmpVar(ASNInput aSNInput) throws ASNException {
        int n = aSNInput.peekTag();
        switch (n) {
            case 2: {
                SnmpInt snmpInt = new SnmpInt(aSNInput.getInt());
                snmpInt.type = n;
                return snmpInt;
            }
            case 4: {
                SnmpString snmpString = new SnmpString(aSNInput.getOctetString());
                snmpString.type = n;
                return snmpString;
            }
            case 5: {
                aSNInput.getNull();
                SnmpNull snmpNull = new SnmpNull();
                snmpNull.type = n;
                return snmpNull;
            }
            case 6: {
                SnmpOID snmpOID = new SnmpOID(aSNInput.getObjectID());
                snmpOID.type = n;
                return snmpOID;
            }
            case 64: {
                SnmpIpAddress snmpIpAddress = new SnmpIpAddress(aSNInput.getIpAddress());
                snmpIpAddress.type = n;
                return snmpIpAddress;
            }
            case 67: {
                SnmpTimeticks snmpTimeticks = new SnmpTimeticks(aSNInput.getTimetick());
                snmpTimeticks.type = n;
                return snmpTimeticks;
            }
            case 65: {
                SnmpCounter snmpCounter = new SnmpCounter(aSNInput.getCounter());
                snmpCounter.type = n;
                return snmpCounter;
            }
            case 70: {
                SnmpCounter snmpCounter = new SnmpCounter(aSNInput.getCounter64());
                snmpCounter.type = n;
                return snmpCounter;
            }
            case 66: {
                SnmpGauge snmpGauge = new SnmpGauge(aSNInput.getGauge());
                snmpGauge.type = n;
                return snmpGauge;
            }
            case 68: {
                SnmpOpaque snmpOpaque = new SnmpOpaque(aSNInput.getOpaque());
                return snmpOpaque;
            }
            case 128: 
            case 129: 
            case 130: {
                aSNInput.read();
                aSNInput.readBytes();
                SnmpExceptionVar snmpExceptionVar = new SnmpExceptionVar();
                snmpExceptionVar.type = n;
                return snmpExceptionVar;
            }
        }
        throw new ASNException();
    }

    public String toTagString() {
        return "SNMP VAR";
    }

    public String toStringValue() {
        return "";
    }

    public abstract void encode(ASNOutput var1);
}

