/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.services.BSnmpRecipient;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import javax.baja.sys.Sys;

public class SnmpTrap
extends SnmpPDU {
    protected BSnmpNetwork snmp;
    private int port;
    public static final int COLD_START = 0;
    public static final int WARM_START = 1;
    public static final int LINK_DOWN = 2;
    public static final int LINK_UP = 3;
    public static final int AUTHENTICATION_FAILURE = 4;
    public static final int EGP_NEIGHBOR_LOSS = 5;
    public static final int ENTERPRISE_SPECIFIC = 6;

    public SnmpTrap(BSnmpNetwork bSnmpNetwork, int n, int n2) {
        block2: {
            this.port = 162;
            this.snmp = bSnmpNetwork;
            this.port = bSnmpNetwork.getDefaultNetworkManagerTrapsPort();
            this.setVersion(0);
            this.setCommunity(bSnmpNetwork.getDefaultNetworkManagerTrapsCommunity());
            this.setCommand(164);
            try {
                this.setEnterprise(new SnmpOID(n >= 0 && n <= 5 ? "1.3.6.1.2.1.11" : "1.3.6.1.4.1.4131.1"));
                this.setSourceIp(Sys.getLocalHost());
                this.setDestinationIp(bSnmpNetwork.getManagerIp());
                this.setTrapType(n);
                this.setSpecificType(n2);
            }
            catch (Exception exception) {
                if (bSnmpNetwork == null) break block2;
                bSnmpNetwork.getSnmpLog().error("Unable to create SnmpTrap - ", (Throwable)exception);
            }
        }
    }

    public SnmpTrap(BSnmpRecipient bSnmpRecipient, int n, int n2) {
        block2: {
            this.port = 162;
            this.snmp = bSnmpRecipient.snmp();
            this.port = bSnmpRecipient.getNetworkManagerConfig().getNetworkManagerTrapsPort();
            this.setVersion(0);
            this.setCommunity(bSnmpRecipient.getNetworkManagerConfig().getNetworkManagerTrapsCommunity());
            this.setCommand(164);
            try {
                this.setEnterprise(new SnmpOID(n >= 0 && n <= 5 ? "1.3.6.1.2.1.11" : "1.3.6.1.4.1.4131.1"));
                this.setSourceIp(Sys.getLocalHost());
                this.setDestinationIp(bSnmpRecipient.getNetworkManagerConfig().getManagerIp());
                this.setTrapType(n);
                this.setSpecificType(n2);
            }
            catch (Exception exception) {
                if (this.snmp == null) break block2;
                this.snmp.getSnmpLog().error("Unable to create SnmpTrap - ", (Throwable)exception);
            }
        }
    }

    public synchronized void send() {
        block2: {
            try {
                this.setRemotePort(this.port);
                this.setUpTime(this.snmp.getTimeTick());
                ComUtil.send(this.snmp, this);
            }
            catch (Exception exception) {
                if (this.snmp == null) break block2;
                this.snmp.getSnmpLog().error("Unable to send SnmpTrap - ", (Throwable)exception);
            }
        }
    }

    public void addStringVariable(String string, String string2) {
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpString snmpString = new SnmpString(string2);
        this.addVariableBinding(new SnmpVarBind(snmpOID, snmpString));
    }

    public void addIntegerVariable(String string, int n) {
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpInt snmpInt = new SnmpInt(n);
        this.addVariableBinding(new SnmpVarBind(snmpOID, snmpInt));
    }
}

