/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.ASNInput;
import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.SnmpUtil;
import java.net.InetAddress;
import java.util.Vector;
import javax.baja.sys.BAbsTime;

public class SnmpPDU
implements SnmpConst {
    private InetAddress destAddr = null;
    private InetAddress srcAddr = null;
    private int version = -1;
    private String community = null;
    private int pduType = 0;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    private int errIndex = 0;
    private int errStat = 0;
    private int remotePort = 0;
    private int reqId = 0;
    private long upTime = 0L;
    private int trapType = 0;
    private int specificType = 0;
    private SnmpOID enterprise;
    private Vector vars;
    private boolean full = false;
    private long[] trapEnterprise = null;
    private byte[] trapAgentAddr = null;
    private int trapGeneric = 0;
    private int trapSpecific = 0;
    private long trapTimeStamp = 0L;

    public SnmpPDU() {
        this.vars = new Vector();
    }

    public SnmpPDU(BSnmpDevice bSnmpDevice, int n) {
        this.setVersion(bSnmpDevice.getVersion());
        this.setReqid(bSnmpDevice.snmpNet().getNextReqid());
        this.setCommand(n);
        this.setRemotePort(bSnmpDevice.getPort());
        this.setDestinationIp(bSnmpDevice.getInetAddress());
        this.setCommunity(bSnmpDevice.getCommunity());
        this.vars = new Vector();
    }

    public SnmpPDU(byte[] byArray) {
        this.decodeData(byArray);
    }

    public void setFull(boolean bl) {
        this.full = bl;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setCommand(int n) {
        this.pduType = n;
    }

    public void setCommunity(String string) {
        this.community = string;
    }

    public void setReqid(int n) {
        this.reqId = n;
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }

    public void setErrindex(int n) {
        this.errIndex = n;
    }

    public void setErrstat(int n) {
        this.errStat = n;
    }

    public void setNonRepeaters(int n) {
        this.nonRepeaters = n;
    }

    public void setMaxRepetitions(int n) {
        this.maxRepetitions = n;
    }

    public void setTrapType(int n) {
        this.trapType = n;
    }

    public void setSpecificType(int n) {
        this.specificType = n;
    }

    public void setUpTime(long l) {
        this.upTime = l;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this.enterprise = snmpOID;
    }

    public void setDestinationIp(InetAddress inetAddress) {
        this.destAddr = inetAddress;
    }

    public void setSourceIp(InetAddress inetAddress) {
        this.srcAddr = inetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getCommand() {
        return this.pduType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReqid() {
        return this.reqId;
    }

    public int getErrstat() {
        return this.errStat;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public int getErrindex() {
        return this.errIndex;
    }

    public InetAddress getSourceIp() {
        return this.srcAddr;
    }

    public InetAddress getDestinationIp() {
        return this.destAddr;
    }

    public String getCommunity() {
        return this.community != null ? this.community : "public";
    }

    public byte[] getData() {
        return this.encodeData();
    }

    public Vector getVariableBindings() {
        return this.vars;
    }

    public void setVariableBindings(Vector vector) {
        this.vars = vector;
    }

    public void clearVariableBindings() {
        this.vars.clear();
    }

    public void addVariableBinding(SnmpVarBind snmpVarBind) {
        this.vars.addElement(snmpVarBind);
    }

    public String getTrapEnterprise() {
        if (this.trapEnterprise == null) {
            return "null";
        }
        return SnmpUtil.longArrayToString(this.trapEnterprise);
    }

    public String getAgentAddr() {
        if (this.trapAgentAddr == null) {
            return "null";
        }
        return SnmpUtil.byteArrayToString(this.trapAgentAddr);
    }

    public String getGenericTrap() {
        return Integer.toString(this.trapGeneric);
    }

    public String getSpecificTrap() {
        return Integer.toString(this.trapSpecific);
    }

    public int getGenericTrapAsInt() {
        return this.trapGeneric;
    }

    public int getSpecificTrapAsInt() {
        return this.trapSpecific;
    }

    public String getTrapTimeStamp() {
        return Long.toString(this.trapTimeStamp) + "(" + BAbsTime.make((long)(this.trapTimeStamp * 10L)) + ")";
    }

    private void decodeData(byte[] byArray) {
        try {
            ASNInput aSNInput = new ASNInput(byArray);
            aSNInput.getSequenceLength();
            this.version = aSNInput.getInt();
            this.community = aSNInput.getString();
            this.pduType = aSNInput.getCommand();
            aSNInput.readLength();
            if (this.pduType == 164) {
                this.trapEnterprise = aSNInput.getObjectID();
                this.trapAgentAddr = aSNInput.getIpAddress();
                this.trapGeneric = aSNInput.getInt();
                this.trapSpecific = aSNInput.getInt();
                this.trapTimeStamp = aSNInput.getTimetick();
            } else {
                this.reqId = aSNInput.getInt();
                if (this.pduType == 165) {
                    this.nonRepeaters = aSNInput.getInt();
                    if (this.nonRepeaters < 0) {
                        this.nonRepeaters = 0;
                    }
                    this.maxRepetitions = aSNInput.getInt();
                } else {
                    this.errStat = aSNInput.getInt();
                    this.errIndex = aSNInput.getInt();
                }
            }
            int n = aSNInput.getSequenceLength();
            int n2 = n + aSNInput.getPosition();
            this.vars = new Vector();
            while (n2 > aSNInput.getPosition()) {
                aSNInput.getSequenceLength();
                this.vars.addElement(new SnmpVarBind(aSNInput));
            }
        }
        catch (ASNException aSNException) {
            System.out.println(" error in SnmpPDU.decodeData: " + (Object)((Object)aSNException));
            aSNException.printStackTrace();
        }
    }

    private byte[] encodeData() {
        ASNOutput aSNOutput = new ASNOutput();
        aSNOutput.addInt(this.version);
        aSNOutput.addString(this.community);
        int n = aSNOutput.getPosition();
        if (this.pduType == 164) {
            aSNOutput.addObjectId(this.enterprise.toValue());
            aSNOutput.addIpAddress(this.srcAddr.getAddress());
            aSNOutput.addInt(this.trapType);
            aSNOutput.addInt(this.specificType);
            aSNOutput.addTimeticks(this.upTime);
        } else {
            aSNOutput.addInt(this.reqId);
            if (this.pduType == 165) {
                aSNOutput.addInt(this.nonRepeaters);
                aSNOutput.addInt(this.maxRepetitions);
            } else {
                aSNOutput.addInt(this.errStat);
                aSNOutput.addInt(this.errIndex);
            }
        }
        try {
            int n2 = aSNOutput.getPosition();
            Object[] objectArray = new SnmpVarBind[this.vars.size()];
            this.vars.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                int n3 = aSNOutput.getPosition();
                if (objectArray[i] == null) {
                    System.out.println("a[i]==null");
                    continue;
                }
                if (((SnmpVarBind)objectArray[i]).getObjectID() == null) {
                    System.out.println("a[i].getObjectID()==null");
                    continue;
                }
                if (((SnmpVarBind)objectArray[i]).getVariable() == null) {
                    System.out.println("a[i].getVariable()==null");
                    continue;
                }
                aSNOutput.addObjectId(((SnmpVarBind)objectArray[i]).getObjectID().toValue());
                ((SnmpVarBind)objectArray[i]).getVariable().encode(aSNOutput);
                aSNOutput.insertTag(48, n3);
            }
            aSNOutput.insertTag(48, n2);
        }
        catch (Throwable throwable) {
            System.out.println(this.toString());
            throwable.printStackTrace();
        }
        aSNOutput.insertTag(this.pduType, n);
        aSNOutput.insertTag(48, 0);
        return aSNOutput.getBytes();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: ").append(this.version + 1);
        stringBuffer.append("\ncommunity: ").append(this.community);
        stringBuffer.append("\npdu type: ").append(SnmpPDU.translatePduType(this.pduType));
        if (this.pduType == 164) {
            stringBuffer.append("\nenterprise: ").append(this.enterprise);
            stringBuffer.append("\nsrcAddr: ").append(this.srcAddr);
            stringBuffer.append("\ntrapType: ").append(this.trapType);
            stringBuffer.append("\nspecificType: ").append(this.specificType);
            stringBuffer.append("\nupTime: ").append(this.upTime);
        } else {
            stringBuffer.append("\nreqId: ").append(this.reqId);
            if (this.pduType == 165) {
                stringBuffer.append("\nnonRepeaters: ").append(this.nonRepeaters);
                stringBuffer.append("\nmaxRepetitions: ").append(this.maxRepetitions);
            } else if (this.errStat != 0) {
                stringBuffer.append("\nerrStat: ").append(SnmpPDU.translateErrorStatus(this.errStat));
                stringBuffer.append("\nerrIndex: ").append(this.errIndex);
            }
        }
        stringBuffer.append("\nvariables:\n");
        this.scanVarBinds(stringBuffer);
        return stringBuffer.toString();
    }

    public String printVarBinds() {
        StringBuffer stringBuffer = new StringBuffer();
        this.scanVarBinds(stringBuffer);
        return stringBuffer.toString();
    }

    public SnmpVarBind[] getVaribleBindingArray() {
        Object[] objectArray = new SnmpVarBind[this.vars.size()];
        this.vars.copyInto(objectArray);
        return objectArray;
    }

    private void scanVarBinds(StringBuffer stringBuffer) {
        if (this.vars != null) {
            for (int i = 0; i < this.vars.size(); ++i) {
                if (this.vars.elementAt(i) == null) continue;
                stringBuffer.append(this.vars.elementAt(i)).append("\n");
            }
        }
    }

    public static String translatePduType(int n) {
        switch (n) {
            case 160: {
                return "GET_REQUEST";
            }
            case 161: {
                return "GET_NEXT_REQUEST";
            }
            case 162: {
                return "GET_RESPONSE";
            }
            case 163: {
                return "SET_REQUEST";
            }
            case 164: {
                return "TRAP_V1";
            }
            case 165: {
                return "GET_BULK_REQUEST";
            }
            case 166: {
                return "INFORM_REQUEST";
            }
            case 167: {
                return "TRAP_V2";
            }
            case 168: {
                return "REPORT";
            }
        }
        return "Unknown 0x" + Integer.toString(n & 0xFF, 16);
    }

    public static String translateErrorStatus(int n) {
        switch (n) {
            case 0: {
                return "no error";
            }
            case 1: {
                return "too big";
            }
            case 2: {
                return "no such name";
            }
            case 3: {
                return "bad value";
            }
            case 4: {
                return "readonly";
            }
            case 5: {
                return "general error";
            }
            case 6: {
                return "no access";
            }
            case 7: {
                return "wrong type";
            }
            case 8: {
                return "wrong length";
            }
            case 9: {
                return "wrong encoding";
            }
            case 10: {
                return "wrong value";
            }
            case 11: {
                return "no creation";
            }
            case 12: {
                return "inconsistent value";
            }
            case 13: {
                return "resource unavailable";
            }
            case 14: {
                return "commit failed";
            }
            case 15: {
                return "undo failed";
            }
            case 16: {
                return "authorization error";
            }
            case 17: {
                return "not writable";
            }
            case 18: {
                return "inconsistent name";
            }
            case 128: {
                return "no such object";
            }
            case 129: {
                return "no such instance";
            }
            case 130: {
                return "end of mib view";
            }
        }
        return "unknown";
    }
}

