/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNOutput;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.util.SnmpUtil;
import java.net.InetAddress;

public class SnmpIpAddress
extends SnmpVar {
    private byte[] a;
    private boolean valid = true;

    public SnmpIpAddress(byte[] byArray) {
        this.a = byArray;
        this.valid = true;
        this.type = 64;
    }

    public SnmpIpAddress(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.a = inetAddress.getAddress();
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void encode(ASNOutput aSNOutput) {
        aSNOutput.addIpAddress(this.a);
    }

    public String toTagString() {
        return "IP ADDRESS: " + SnmpUtil.byteArrayToString(this.a);
    }

    public String getIPString() {
        return SnmpUtil.byteArrayToString(this.a);
    }

    public String toStringValue() {
        return this.getIPString();
    }
}

