/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.SnmpConst;

public class ASNOutput
implements SnmpConst {
    private byte[] data = new byte[500];
    private int pos = 0;
    private int endOfData = 0;

    public byte[] getBytes() {
        byte[] byArray = new byte[this.endOfData];
        System.arraycopy(this.data, 0, byArray, 0, this.endOfData);
        return byArray;
    }

    public int getPosition() {
        return this.pos;
    }

    public void addInt(int n) {
        int n2 = this.pos;
        this.writeInt(n);
        this.insertTag(2, n2);
    }

    public void addString(String string) {
        this.addOctetString(string.getBytes());
    }

    public void addOctetString(byte[] byArray) {
        int n = this.pos;
        this.writeBytes(byArray);
        this.insertTag(4, n);
    }

    public void addOpaque(byte[] byArray) {
        int n = this.pos;
        this.writeBytes(byArray);
        this.insertTag(68, n);
    }

    public void addTimeticks(long l) {
        int n = this.pos;
        this.writeUnsignedLong(l);
        this.insertTag(67, n);
    }

    public void addNull() {
        this.write(5);
        this.write(0);
    }

    public void addObjectId(long[] lArray) {
        int n = this.pos;
        long l = lArray[0] * 40L + lArray[1];
        this.writeTagLong(l);
        for (int i = 2; i < lArray.length; ++i) {
            this.writeTagLong(lArray[i]);
        }
        this.insertTag(6, n);
    }

    public void addIpAddress(byte[] byArray) {
        int n = this.pos;
        this.writeBytes(byArray);
        this.insertTag(64, n);
    }

    public void addCounter(long l) {
        int n = this.pos;
        this.writeUnsignedInt(l);
        this.insertTag(65, n);
    }

    public void addCounter64(long l) {
        int n = this.pos;
        this.writeUnsignedInt(l);
        this.insertTag(70, n);
    }

    public void addGauge(long l) {
        int n = this.pos;
        this.writeUnsignedInt(l);
        this.insertTag(66, n);
    }

    public void writeBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i]);
        }
    }

    public void writeInt(int n) {
        int n2;
        int n3 = ASNOutput.findIntegerLength(n);
        if (n > 0 && (n & (n2 = 1 << 8 * n3 - 1)) != 0) {
            ++n3;
        }
        n2 = this.pos;
        for (int i = 1; i <= n3; ++i) {
            this.insert(n & 0xFF, n2);
            n >>= 8;
        }
    }

    private static int findIntegerLength(long l) {
        if (l == 0L) {
            return 1;
        }
        if (l > 0L) {
            if (l > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
            }
            if ((l & 0xFFFFFFFFFF000000L) != 0L) {
                return 4;
            }
            if ((l & 0xFF0000L) != 0L) {
                return 3;
            }
            if ((l & 0xFF00L) != 0L) {
                return 2;
            }
            return 1;
        }
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
        }
        if ((l & 0xFFFFFFFFFF000000L) != -16777216L) {
            return 4;
        }
        if ((l & 0x800000L) == 0L) {
            return 4;
        }
        if ((l & 0xFF0000L) != 0xFF0000L) {
            return 3;
        }
        if ((l & 0x8000L) == 0L) {
            return 3;
        }
        if ((l & 0xFF00L) != 65280L) {
            return 2;
        }
        if ((l & 0x80L) == 0L) {
            return 2;
        }
        return 1;
    }

    public void writeUnsignedInt(long l) {
        this.writeUnsignedLong(l);
    }

    public void writeUnsignedLong(long l) {
        int n = this.pos;
        int n2 = 255;
        while (l > 0L || n2 > 127) {
            n2 = (int)(l & 0xFFL);
            this.insert(n2, n);
            l >>= 8;
        }
    }

    public void insertLong(long l, int n) {
        if (l == 0L) {
            this.insert(0, n);
        }
        while (l > 0L) {
            this.insert((int)(l & 0xFFL), n);
            l >>= 8;
        }
    }

    public void writeTagLong(long l) {
        int n = this.pos;
        this.insert((int)(l & 0x7FL), n);
        l >>= 7;
        while (l > 0L) {
            this.insert((int)(l & 0x7FL | 0x80L), n);
            l >>= 7;
        }
    }

    private void insertLength(int n, int n2) {
        int n3 = this.lengthForLength(n);
        this.insertLong(n, n2);
        if (n3 > 1) {
            this.insert(n3 - 1 | 0x80, n2);
        }
    }

    private int lengthForLength(int n) {
        if (n <= 127) {
            return 1;
        }
        int n2 = 1;
        while (n > 255) {
            n >>= 8;
            ++n2;
        }
        return n2 + 1;
    }

    public String toString() {
        if (this.endOfData <= 0) {
            return "no data";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.endOfData;
        if (this.endOfData > this.data.length) {
            n = this.data.length;
        }
        if (n == 0) {
            return "";
        }
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(Integer.toString(this.data[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public void insertTag(int n, int n2) {
        int n3 = this.endOfData - n2;
        this.insert(n, n2);
        this.insertLength(n3, n2 + 1);
    }

    private void insert(int n, int n2) {
        this.pos = n2;
        int n3 = this.endOfData - this.pos;
        ++this.endOfData;
        if (this.endOfData >= this.data.length) {
            this.expand(50);
        }
        System.arraycopy(this.data, n2, this.data, n2 + 1, n3);
        this.write(n);
        this.pos = this.endOfData;
    }

    public void write(int n) {
        if (this.pos >= this.data.length) {
            this.expand(100);
        }
        this.data[this.pos] = (byte)n;
        ++this.pos;
        if (this.pos > this.endOfData) {
            this.endOfData = this.pos;
        }
    }

    private void expand(int n) {
        byte[] byArray = new byte[this.data.length + n];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }
}

