/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.snmptypes;

import com.tridium.snmp.snmptypes.ASNException;
import com.tridium.snmp.snmptypes.SnmpConst;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class ASNInput
extends ByteArrayInputStream
implements SnmpConst {
    public ASNInput(byte[] byArray) {
        super(byArray);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setBuffer(byte[] byArray) {
        this.buf = byArray;
        this.mark = 0;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public int peekTag() throws ASNException {
        if (this.available() == 0) {
            return -1;
        }
        int n = this.pos;
        int n2 = this.read();
        this.pos = n;
        return n2;
    }

    public int getSequenceLength() throws ASNException {
        this.verifyTag(48);
        return this.readLength();
    }

    public int getInt() throws ASNException {
        this.verifyTag(2);
        return this.readInt();
    }

    public String getString() throws ASNException {
        return new String(this.getOctetString());
    }

    public byte[] getOctetString() throws ASNException {
        this.verifyTag(4);
        return this.readBytes();
    }

    public long getTimetick() throws ASNException {
        this.verifyTag(67);
        return this.readUnsignedInt();
    }

    public void getNull() throws ASNException {
        this.verifyTag(5);
        this.readLength();
    }

    public long[] getObjectID() throws ASNException {
        this.verifyTag(6);
        Vector<Long> vector = new Vector<Long>(16);
        int n = this.readLength();
        int n2 = this.pos + n;
        long l = this.getTagLong();
        long l2 = l / 40L;
        long l3 = l % 40L;
        vector.addElement(new Long(l2));
        vector.addElement(new Long(l3));
        while (this.pos < n2) {
            vector.addElement(new Long(this.getTagLong()));
        }
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (Long)vector.elementAt(i);
        }
        return lArray;
    }

    public byte[] getIpAddress() throws ASNException {
        this.verifyTag(64);
        return this.readBytes();
    }

    public long getCounter() throws ASNException {
        this.verifyTag(65);
        return this.readUnsignedInt();
    }

    public long getCounter64() throws ASNException {
        this.verifyTag(70);
        return this.readUnsignedInt();
    }

    public long getGauge() throws ASNException {
        this.verifyTag(66);
        return this.readUnsignedInt();
    }

    public byte[] getOpaque() throws ASNException {
        this.verifyTag(68);
        return this.readBytes();
    }

    public long getTagLong() throws ASNException {
        int n;
        long l = 0L;
        do {
            if ((n = this.read()) < 0) {
                throw new ASNException();
            }
            l = (l << 7) + (long)(n & 0x7F);
        } while ((n & 0x80) != 0);
        return l;
    }

    public int getCommand() throws ASNException {
        int n = this.read() & 0xFF;
        if ((n >> 4 & 0xF) != 10) {
            throw new ASNException();
        }
        return n;
    }

    public byte[] readBytes() throws ASNException {
        int n = this.readLength();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.read();
        }
        return byArray;
    }

    public int readInt() throws ASNException {
        return this.readInt(this.readLength());
    }

    public int readInt(int n) throws ASNException {
        if (n <= 0) {
            return 0;
        }
        int n2 = this.read();
        if (n < 4 && (n2 & 0x80) != 0) {
            n2 |= 0xFFFFFF00;
        }
        --n;
        while (n > 0) {
            n2 <<= 8;
            n2 |= this.read();
            --n;
        }
        return n2;
    }

    public long readUnsignedInt() throws ASNException {
        return this.readUnsignedInt(this.readLength());
    }

    public long readUnsignedInt(int n) throws ASNException {
        long l = 0L;
        while (n > 0) {
            l <<= 8;
            l |= (long)this.read();
            --n;
        }
        return l;
    }

    public int readLength() throws ASNException {
        int n = this.read();
        if (n < 128) {
            return n;
        }
        int n2 = n & 0x7F;
        return (int)this.readUnsignedInt(n2);
    }

    private void verifyTag(int n) throws ASNException {
        int n2 = this.read();
        if (n2 != (byte)n) {
            System.out.println("invalid tag=" + n2 + " expected=" + n + " at pos=" + (this.getPosition() - 1));
            throw new ASNException();
        }
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }
}

