/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.services.ComUtil;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Vector;
import javax.baja.log.Log;

public class SnmpReceive
implements Runnable,
SnmpConst {
    private static final int NO_ACCESS = 0;
    private static final int READ_ONLY = 1;
    private static final int READ_WRITE = 2;
    private static final int PACKET_SIZE = 1500;
    private boolean done;
    private BSnmpNetwork snmp;
    private DatagramSocket sock;
    private Thread myThread;
    private Log log;

    public SnmpReceive(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
        this.log = bSnmpNetwork.getSnmpLog();
    }

    public final void start() {
        try {
            this.sock = new DatagramSocket(this.snmp.getSnmpReceivePort());
        }
        catch (Exception exception) {
            if (this.snmp != null) {
                this.log.error("SnmpReceive: unable to create socket on port " + this.snmp.getSnmpReceivePort(), (Throwable)exception);
            }
            return;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("*** Starting SnmpReceive Service");
        }
        this.done = false;
        this.myThread = new Thread((Runnable)this, "Snmp:Receive");
        this.myThread.start();
    }

    public final void stop() {
        if (this.log.isTraceOn()) {
            this.log.trace("*** Stopping SnmpReceive Service");
        }
        this.done = true;
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public void run() {
        if (this.log.isTraceOn()) {
            this.log.trace("SnmpReceive thread is now running.");
        }
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1500], 1500);
        while (!this.done) {
            datagramPacket.setLength(1500);
            SnmpPDU snmpPDU = ComUtil.receive(this.snmp, this.sock, datagramPacket);
            if (snmpPDU != null && snmpPDU.getVersion() > 1) continue;
            SnmpPDU snmpPDU2 = null;
            if (snmpPDU == null) continue;
            int n = this.checkReceivedRequest(snmpPDU);
            if (n == 0) {
                if (!this.log.isTraceOn()) continue;
                this.log.trace("Access denied.");
                continue;
            }
            if (snmpPDU.isFull()) {
                snmpPDU2 = new SnmpPDU();
                snmpPDU2.setErrstat(1);
                snmpPDU2.setErrindex(0);
            } else {
                try {
                    int n2 = snmpPDU.getCommand() & 0xFF;
                    switch (n2) {
                        case 160: {
                            snmpPDU2 = this.processGet(snmpPDU);
                            break;
                        }
                        case 161: {
                            snmpPDU2 = this.processGetNext(snmpPDU);
                            break;
                        }
                        case 165: {
                            snmpPDU2 = this.processBulkRequest(snmpPDU);
                            break;
                        }
                        case 163: {
                            if (n == 2) {
                                snmpPDU2 = this.processSet(snmpPDU);
                            }
                            break;
                        }
                        default: {
                            if (this.log.isTraceOn()) {
                                this.log.trace("Received Unprocessable SNMP request (Command: " + snmpPDU.getCommand() + ")");
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    this.log.error("Exception processing pdu:", (Throwable)exception);
                }
            }
            if (snmpPDU2 == null) continue;
            this.sendResponse(snmpPDU, snmpPDU2);
        }
    }

    private int checkReceivedRequest(SnmpPDU snmpPDU) {
        if (this.snmp.getIgnoreRequestsFromUnrecognizedSources() && !this.sourceIpRecognized(snmpPDU.getSourceIp().getHostAddress())) {
            if (this.log.isTraceOn()) {
                this.log.trace("Access denied: Unrecognized source");
            }
            return 0;
        }
        if (!this.snmp.getCheckCommunityOnRequests()) {
            return 2;
        }
        if (snmpPDU.getCommunity().equals(this.snmp.getReadWriteCommunity())) {
            return 2;
        }
        if (snmpPDU.getCommunity().equals(this.snmp.getReadOnlyCommunity())) {
            if (this.log.isTraceOn()) {
                this.log.trace("ReadOnly access: Not readWrite community member");
            }
            return 1;
        }
        if (this.log.isTraceOn()) {
            this.log.trace("Access denied: Not community member");
        }
        return 0;
    }

    private boolean sourceIpRecognized(String string) {
        String[] stringArray = this.snmp.getRecognizedSources().getAddressList();
        if (stringArray == null || stringArray.length <= 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void sendResponse(SnmpPDU snmpPDU, SnmpPDU snmpPDU2) {
        try {
            snmpPDU2.setVersion(snmpPDU.getVersion());
            snmpPDU2.setReqid(snmpPDU.getReqid());
            snmpPDU2.setCommunity(snmpPDU.getCommunity());
            snmpPDU2.setCommand(162);
            snmpPDU2.setRemotePort(snmpPDU.getRemotePort());
            snmpPDU2.setDestinationIp(snmpPDU.getSourceIp());
            ComUtil.send(this.snmp, snmpPDU2, this.sock);
        }
        catch (Exception exception) {
            this.log.error("Exception while sending response: ", (Throwable)exception);
        }
    }

    private SnmpPDU processSet(SnmpPDU snmpPDU) {
        int n;
        int n2;
        int n3 = snmpPDU.getVersion();
        SnmpVarBind[] snmpVarBindArray = snmpPDU.getVaribleBindingArray();
        SnmpPDU snmpPDU2 = new SnmpPDU();
        for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
            n = this.snmp.getMib().validateForSet(snmpVarBindArray[n2], snmpPDU2, n3);
            if (n == 0) continue;
            snmpPDU2.setErrstat(n);
            snmpPDU2.setErrindex(n2 + 1);
            return snmpPDU2;
        }
        for (n2 = 0; n2 < snmpVarBindArray.length; ++n2) {
            if (this.log.isTraceOn()) {
                this.log.trace("set var " + snmpVarBindArray[n2].toString());
            }
            if ((n = this.snmp.getMib().processSet(snmpVarBindArray[n2], snmpPDU2, n3)) == 0) continue;
            snmpPDU2.clearVariableBindings();
            if (n3 == 0) {
                snmpPDU2.setErrstat(n);
                snmpPDU2.setErrindex(n2 + 1);
                break;
            }
            snmpPDU2.setErrstat(n2 == 0 ? 14 : 15);
            snmpPDU2.setErrindex(0);
            break;
        }
        return snmpPDU2;
    }

    private SnmpPDU processGet(SnmpPDU snmpPDU) {
        int n = snmpPDU.getVersion();
        SnmpVarBind[] snmpVarBindArray = snmpPDU.getVaribleBindingArray();
        SnmpPDU snmpPDU2 = new SnmpPDU();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            if (this.log.isTraceOn()) {
                this.log.trace("get var " + snmpVarBindArray[i].toString());
            }
            SnmpOID snmpOID = snmpVarBindArray[i].getObjectID();
            int n2 = this.snmp.getMib().processGet(snmpOID, snmpPDU2, n);
            if (n2 == 0 || n != 0) continue;
            snmpPDU2.clearVariableBindings();
            snmpPDU2.setErrstat(n2);
            snmpPDU2.setErrindex(i + 1);
            break;
        }
        return snmpPDU2;
    }

    private SnmpPDU processGetNext(SnmpPDU snmpPDU) {
        int n = snmpPDU.getVersion();
        SnmpVarBind[] snmpVarBindArray = snmpPDU.getVaribleBindingArray();
        SnmpPDU snmpPDU2 = new SnmpPDU();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            if (this.log.isTraceOn()) {
                this.log.trace("getNext var " + snmpVarBindArray[i].toString());
            }
            SnmpOID snmpOID = snmpVarBindArray[i].getObjectID();
            SnmpVarBind snmpVarBind = this.snmp.getMib().processGetNext(snmpOID);
            if (snmpVarBind == null) {
                if (n == 0) {
                    snmpPDU2.clearVariableBindings();
                    snmpPDU2.setErrstat(2);
                    snmpPDU2.setErrindex(i + 1);
                    return snmpPDU2;
                }
                snmpVarBind = new SnmpVarBind(snmpOID, new SnmpExceptionVar(130));
            }
            snmpPDU2.addVariableBinding(snmpVarBind);
        }
        return snmpPDU2;
    }

    private SnmpPDU processBulkRequest(SnmpPDU snmpPDU) {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        SnmpVarBind[] snmpVarBindArray = snmpPDU.getVaribleBindingArray();
        int n5 = snmpPDU.getNonRepeaters();
        if (n5 > snmpVarBindArray.length) {
            n5 = snmpVarBindArray.length;
        }
        if ((n4 = snmpPDU.getMaxRepetitions()) < 0) {
            n4 = 0;
        }
        SnmpPDU snmpPDU2 = new SnmpPDU();
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.log.isTraceOn()) {
                this.log.trace("getBulk var " + snmpVarBindArray[n3].toString());
            }
            object = snmpVarBindArray[n3].getObjectID();
            SnmpVarBind snmpVarBind = this.snmp.getMib().processGetNext((SnmpOID)object);
            if (snmpVarBind == null) {
                snmpVarBind = new SnmpVarBind((SnmpOID)object, new SnmpExceptionVar(130));
            }
            snmpPDU2.addVariableBinding(snmpVarBind);
        }
        n3 = snmpVarBindArray.length - n5;
        object = new SnmpOID[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object[n2] = snmpVarBindArray[n2 + n5].getObjectID();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                SnmpVarBind snmpVarBind = this.snmp.getMib().processGetNext(object[n]);
                if (snmpVarBind == null) {
                    snmpVarBind = new SnmpVarBind(object[n], new SnmpExceptionVar(130));
                }
                object[n] = snmpVarBind.getObjectID();
                snmpPDU2.addVariableBinding(snmpVarBind);
            }
        }
        Vector vector = snmpPDU2.getVariableBindings();
        n = 0;
        for (int i = vector.size() - 1; i >= 0; --i) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)vector.elementAt(i);
            SnmpVar snmpVar = snmpVarBind.getVariable();
            if (snmpVar.type != 130) break;
            if (n == 0) {
                n = 1;
                continue;
            }
            vector.removeElementAt(i + 1);
        }
        return snmpPDU2;
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }
}

