/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.snmptypes.SnmpPDU;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class ComUtil {
    public static String insertLineFeeds(String string) {
        if (string.length() <= 75) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String(string);
        while (string2.length() > 75) {
            int n = string2.indexOf(" ", 75);
            if (n < 0) {
                n = 100;
            }
            if (n > string2.length()) {
                stringBuffer.append(string2);
                return stringBuffer.toString();
            }
            String string3 = string2.substring(0, n + 1);
            stringBuffer.append(string3);
            stringBuffer.append("\n");
            string2 = string2.substring(n, string2.length());
        }
        if (string2.length() > 0) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void send(BSnmpNetwork bSnmpNetwork, SnmpPDU snmpPDU) {
        ComUtil.send(bSnmpNetwork, snmpPDU, bSnmpNetwork.getSocket());
    }

    public static void send(BSnmpNetwork bSnmpNetwork, SnmpPDU snmpPDU, DatagramSocket datagramSocket) {
        block3: {
            byte[] byArray = snmpPDU.getData();
            if (bSnmpNetwork.getSnmpLog().isTraceOn()) {
                bSnmpNetwork.getSnmpLog().trace("Sending PDU: " + snmpPDU.getDestinationIp() + ":" + snmpPDU.getRemotePort() + "\n" + snmpPDU);
                ComUtil.printReport(byArray, byArray.length);
            }
            try {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, snmpPDU.getDestinationIp(), snmpPDU.getRemotePort());
                datagramSocket.send(datagramPacket);
            }
            catch (Exception exception) {
                if (bSnmpNetwork == null || !bSnmpNetwork.getSnmpLog().isTraceOn()) break block3;
                bSnmpNetwork.getSnmpLog().trace("Could not send packet: " + exception);
            }
        }
    }

    public static void printReport(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(Integer.toString(byArray[i] >> 4 & 0xF, 16) + Integer.toString(byArray[i] & 0xF, 16) + " ");
            if (i % 20 != 19) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static SnmpPDU receive(BSnmpNetwork bSnmpNetwork, DatagramSocket datagramSocket, DatagramPacket datagramPacket) {
        SnmpPDU snmpPDU;
        try {
            datagramSocket.receive(datagramPacket);
            byte[] byArray = datagramPacket.getData();
            if (bSnmpNetwork.getSnmpLog().isTraceOn()) {
                bSnmpNetwork.getSnmpLog().trace("Received packet \n");
                ComUtil.printReport(byArray, datagramPacket.getLength());
            }
            snmpPDU = new SnmpPDU(byArray);
            if (datagramPacket.getLength() >= byArray.length) {
                snmpPDU.setFull(true);
            } else {
                snmpPDU.setFull(false);
            }
            snmpPDU.setRemotePort(datagramPacket.getPort());
            snmpPDU.setSourceIp(datagramPacket.getAddress());
        }
        catch (Throwable throwable) {
            if (bSnmpNetwork != null && bSnmpNetwork.getSnmpLog().isTraceOn()) {
                bSnmpNetwork.getSnmpLog().trace("\n SnmpUtil.receive() exception " + throwable);
            }
            return null;
        }
        if (bSnmpNetwork.getSnmpLog().isTraceOn()) {
            bSnmpNetwork.getSnmpLog().trace("Received from: " + datagramPacket.getAddress() + ":" + datagramPacket.getPort() + "\n" + snmpPDU);
        }
        return snmpPDU;
    }
}

