/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.services;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.datatypes.BNetworkManagerConfiguration;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.snmptypes.AlarmTrap;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.collection.BICollection;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSnmpRecipient
extends BAlarmRecipient {
    public static Lexicon lex = Lexicon.make((String)"snmp");
    public static final Property networkManagerConfig = BSnmpRecipient.newProperty((int)0, (BValue)new BNetworkManagerConfiguration(), null);
    public static final Property snmpAlarmTable = BSnmpRecipient.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)lex.getText("recipient.strings.storeAlarms"), (String)lex.getText("recipient.strings.discardAlarms")));
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$services$BSnmpRecipient == null ? (class$com$tridium$snmp$services$BSnmpRecipient = BSnmpRecipient.class$("com.tridium.snmp.services.BSnmpRecipient")) : class$com$tridium$snmp$services$BSnmpRecipient));
    static /* synthetic */ Class class$com$tridium$snmp$services$BSnmpRecipient;

    public BNetworkManagerConfiguration getNetworkManagerConfig() {
        return (BNetworkManagerConfiguration)this.get(networkManagerConfig);
    }

    public void setNetworkManagerConfig(BNetworkManagerConfiguration bNetworkManagerConfiguration) {
        this.set(networkManagerConfig, (BValue)bNetworkManagerConfiguration, null);
    }

    public boolean getSnmpAlarmTable() {
        return this.getBoolean(snmpAlarmTable);
    }

    public void setSnmpAlarmTable(boolean bl) {
        this.setBoolean(snmpAlarmTable, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.initAlarmTable();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == snmpAlarmTable) {
            this.initAlarmTable();
        }
    }

    private void initAlarmTable() {
        if (!this.getSnmpAlarmTable()) {
            return;
        }
        String string = this.getInitialAlarmQuery();
        BOrd bOrd = BOrd.make((String)string.toString());
        BICollection bICollection = (BICollection)bOrd.resolve().get();
        Cursor cursor = bICollection.cursor();
        while (cursor.next()) {
            BAlarmRecord bAlarmRecord = (BAlarmRecord)cursor.get();
            if (!this.accept(bAlarmRecord)) continue;
            this.snmp().alarms().addAlarmEntry((BAlarmRecord)bAlarmRecord.newCopy());
        }
    }

    public void handleAlarm(BAlarmRecord bAlarmRecord) {
        try {
            if (!bAlarmRecord.isAcknowledged()) {
                AlarmEntry alarmEntry = this.getSnmpAlarmTable() ? this.snmp().alarms().addAlarmEntry(bAlarmRecord) : new AlarmEntry(bAlarmRecord, 0);
                if (this.snmp().isCommActive() && this.getNetworkManagerConfig().getRouteAlarmsToNetworkManager()) {
                    if (this.getNetworkManagerConfig().getUseDefaultNetworkManager()) {
                        AlarmTrap.sendAlarmTrap(this.snmp(), alarmEntry);
                    } else {
                        AlarmTrap.sendAlarmTrap(this, alarmEntry);
                    }
                }
            }
        }
        catch (Exception exception) {
            if (this.snmp() == null) {
                System.out.println("Exception generated in SnmpRecipient.  Could not find SnmpNetwork.  " + exception);
            }
            this.snmp().getSnmpLog().error("Exception generated in SnmpRecipient.", (Throwable)exception);
        }
    }

    public String getInitialAlarmQuery() {
        int n;
        String[] stringArray = this.getSubscribedAlarmClasses();
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * from openAlarms");
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (n2 > 0) {
                stringBuffer2.append(" or ");
                stringBuffer2.append("(");
                ++n3;
            }
            ++n2;
            stringBuffer2.append("alarmClass = '" + SlotPath.escape((String)string) + "'");
        }
        for (n = 0; n < n3; ++n) {
            stringBuffer2.append(")");
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(" where (");
            stringBuffer.append(stringBuffer2.toString() + ")");
        } else {
            stringBuffer.append(" where alarmClass = 'null'");
        }
        return stringBuffer.toString();
    }

    public BSnmpNetwork snmp() {
        return (BSnmpNetwork)Sys.getService((Type)BSnmpNetwork.TYPE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

