/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.point;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.messages.SnmpWriteAsyncRequest;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSnmpProxyExt
extends BProxyExt {
    public static final Property objectIdentifier = BSnmpProxyExt.newProperty((int)0, (String)"", null);
    public static final Property variableType = BSnmpProxyExt.newProperty((int)1, (BValue)BSnmpVariableTypeEnum.integerType, null);
    public static final Action forceRead = BSnmpProxyExt.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$point$BSnmpProxyExt == null ? (class$com$tridium$snmp$point$BSnmpProxyExt = BSnmpProxyExt.class$("com.tridium.snmp.point.BSnmpProxyExt")) : class$com$tridium$snmp$point$BSnmpProxyExt));
    public static final String ILLEGAL_OID = "Illegal Object Identifier";
    protected boolean configFault = false;
    protected boolean currentlySubscribed = false;
    static /* synthetic */ Class class$com$tridium$snmp$point$BSnmpProxyExt;

    public String getObjectIdentifier() {
        return this.getString(objectIdentifier);
    }

    public void setObjectIdentifier(String string) {
        this.setString(objectIdentifier, string, null);
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return (BSnmpVariableTypeEnum)this.get(variableType);
    }

    public void setVariableType(BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        this.set(variableType, (BValue)bSnmpVariableTypeEnum, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BSnmpPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isValidOID()) {
            this.configFault = true;
            this.readFail(ILLEGAL_OID);
        } else {
            this.configFault = false;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == objectIdentifier) {
            if (!this.isValidOID()) {
                this.configFault = true;
                this.readFail(ILLEGAL_OID);
            } else {
                this.configFault = false;
                this.setStale(true, null);
                if (this.getParentPoint().isWritablePoint()) {
                    this.getTuning().writeDesired();
                }
            }
        } else if (property == variableType && this.getParentPoint().isWritablePoint()) {
            this.getTuning().writeDesired();
        }
    }

    public boolean write(Context context) throws Exception {
        if (this.configFault || !this.getParentPoint().isWritablePoint()) {
            return false;
        }
        BStatusValue bStatusValue = this.getWriteValue();
        if (bStatusValue.getStatus().isNull()) {
            return false;
        }
        try {
            this.snmpNet().postCoalescingRequest(new SnmpWriteAsyncRequest(this, bStatusValue));
        }
        catch (Exception exception) {
            BSnmpNetwork.log.error("Could not post write for " + this.getParentPoint().getName(), (Throwable)exception);
            this.writeFail(BSnmpNetwork.lex.getText("postWriteFail") + ": " + exception);
            return false;
        }
        return true;
    }

    public void readSubscribed(Context context) throws Exception {
        if (this.currentlySubscribed) {
            return;
        }
        this.currentlySubscribed = true;
    }

    public void readUnsubscribed(Context context) throws Exception {
        if (!this.currentlySubscribed) {
            return;
        }
        this.currentlySubscribed = false;
    }

    protected synchronized BSnmpNetwork snmpNet() {
        if ((BSnmpDevice)this.getDevice() == null) {
            return null;
        }
        return ((BSnmpDevice)this.getDevice()).snmpNet();
    }

    public boolean isValidOID() {
        long[] lArray;
        SnmpOID snmpOID = new SnmpOID(this.getObjectIdentifier());
        return snmpOID.isValid() && (lArray = snmpOID.toValue()).length >= 2;
    }

    public boolean isCurrentlySubscribed() {
        return this.currentlySubscribed;
    }

    public boolean isConfigFault() {
        return this.configFault;
    }

    public abstract void setValue(SnmpVar var1);

    public void doWrite(BStatusValue bStatusValue) {
        BSnmpNetwork bSnmpNetwork = this.snmpNet();
        if (bSnmpNetwork == null || !bSnmpNetwork.isCommActive() || this.configFault) {
            return;
        }
        if (this.getParentPoint().isWritablePoint()) {
            SnmpVar snmpVar = this.getVariable(bStatusValue);
            if (snmpVar == null) {
                this.writeFail("Cannot write null SNMP variable value");
                return;
            }
            int n = ((BSnmpDevice)this.getDevice()).setVar(snmpVar, this.getObjectIdentifier());
            if (n == 0) {
                this.writeOk(bStatusValue);
            } else if (n == -1) {
                this.writeFail("No response to SNMP write request");
            } else {
                this.writeFail(SnmpPDU.translateErrorStatus(n));
            }
        }
    }

    protected abstract SnmpVar getVariable(BStatusValue var1);

    public void doForceRead() {
        BSnmpDevice bSnmpDevice = (BSnmpDevice)this.getDevice();
        SnmpPDU snmpPDU = new SnmpPDU(bSnmpDevice, 160);
        SnmpOID snmpOID = new SnmpOID(this.getObjectIdentifier());
        snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, new SnmpNull()));
        SnmpPDU snmpPDU2 = this.snmpNet().sendAsyncRequest(snmpPDU, (int)bSnmpDevice.getResponseTimeout().getMillis(), bSnmpDevice.getRetryCount());
        if (snmpPDU2 == null) {
            this.snmpNet().getSnmpLog().error("doForceRead failed in " + bSnmpDevice.getName() + ":" + this.getParent().getName());
            return;
        }
        SnmpVarBind snmpVarBind = (SnmpVarBind)snmpPDU2.getVariableBindings().elementAt(0);
        if (!snmpOID.equals(snmpVarBind.getObjectID())) {
            this.snmpNet().getSnmpLog().error("doForceRead failed in " + bSnmpDevice.getName() + ":" + this.getParent().getName());
            return;
        }
        this.setValue(snmpVarBind.getVariable());
    }

    public static BFacets adjustFacets(BFacets bFacets, BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        return bFacets;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

