/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib.table;

import com.tridium.snmp.mib.table.SmiTable;
import com.tridium.snmp.mib.table.TableEntry;
import java.util.Vector;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.util.IntHashMap;

public class PointTable
extends SmiTable {
    private boolean started = false;
    private Vector store = null;
    TableEntry[] aEntries = null;
    protected IntHashMap hash = new IntHashMap(50);
    boolean hashMod = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PointTable pointTable = this;
        synchronized (pointTable) {
            this.started = true;
            if (this.store != null) {
                for (int i = 0; i < this.store.size(); ++i) {
                    this.registerIoObject((TableEntry)this.store.elementAt(i));
                }
            }
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIoObject(TableEntry tableEntry) {
        int n = tableEntry.getIndex();
        if (n == 0) {
            PointTable pointTable = this;
            synchronized (pointTable) {
                if (!this.started) {
                    if (this.store == null) {
                        this.store = new Vector();
                    }
                    this.store.addElement(tableEntry);
                    return;
                }
                this.claimNextIndex(tableEntry);
            }
        }
        this.hashDevice(tableEntry);
    }

    public void unregisterIoObject(TableEntry tableEntry) {
        this.unhashDevice(tableEntry);
    }

    private synchronized void claimNextIndex(TableEntry tableEntry) {
        int n = 1;
        this.unregisterIoObject(tableEntry);
        while (this.hash.get(n) != null) {
            if (++n != 0) continue;
            return;
        }
        tableEntry.setIndex(n);
    }

    public synchronized TableEntry[] getArray() {
        if (this.aEntries == null || this.hash.size() != this.aEntries.length) {
            this.aEntries = new TableEntry[this.hash.size()];
        }
        if (this.hashMod) {
            this.hash.toArray((Object[])this.aEntries);
            this.hashMod = false;
        }
        return this.aEntries;
    }

    public synchronized int getNextIndex(int n) {
        int n2 = n + 1;
        while (this.hash.get(n2) != null) {
            if (++n2 != 0) continue;
            return 0;
        }
        return n2;
    }

    private synchronized void hashDevice(TableEntry tableEntry) {
        int n = tableEntry.getIndex();
        TableEntry tableEntry2 = (TableEntry)this.hash.get(n);
        if (tableEntry2 == null) {
            this.hash.put(n, (Object)tableEntry);
            this.hashMod = true;
            tableEntry.setLastHash(n);
        } else if (!tableEntry2.equals(tableEntry)) {
            String string = "Duplicate index detected in SmiTable for " + tableEntry2.getPointName() + " & " + tableEntry.getPointName() + ".  Will use next available index for " + tableEntry.getPointName();
            System.out.println(string);
            tableEntry.setIndex(0);
            this.registerIoObject(tableEntry);
        }
    }

    private synchronized void unhashDevice(TableEntry tableEntry) {
        int n = tableEntry.getLastHash();
        TableEntry tableEntry2 = (TableEntry)this.hash.get(n);
        if (tableEntry2 == null || !tableEntry2.equals(tableEntry)) {
            return;
        }
        this.hash.remove(n);
        this.hashMod = true;
        tableEntry.setLastHash(-1);
    }

    public TableEntry getNextEntry(int n) {
        int n2;
        TableEntry[] tableEntryArray = this.getArray();
        if (tableEntryArray.length == 0) {
            return null;
        }
        if (n == 0) {
            return tableEntryArray[0];
        }
        for (n2 = 0; n2 < tableEntryArray.length && tableEntryArray[n2].getIndex() != n; ++n2) {
        }
        if (++n2 >= tableEntryArray.length) {
            return null;
        }
        return tableEntryArray[n2];
    }

    public TableEntry getObject(int n) {
        return (TableEntry)this.hash.get(n);
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        TableEntry[] tableEntryArray = this.getArray();
        if (tableEntryArray != null && tableEntryArray.length > 0) {
            spyWriter.startTable(true);
            spyWriter.w((Object)"<tr>").th((Object)(tableEntryArray.length + " Entries as of " + BAbsTime.now())).w((Object)"</tr>\n");
            for (int i = 0; i < tableEntryArray.length; ++i) {
                spyWriter.tr((Object)tableEntryArray[i].toString());
            }
            spyWriter.endTable();
        }
    }
}

