/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib.table;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.table.AlarmEntry;
import com.tridium.snmp.mib.table.SmiTable;
import com.tridium.snmp.mib.table.TableEntry;
import java.util.Comparator;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BUuid;
import javax.baja.util.IntHashMap;
import javax.baja.util.SortUtil;

public class AlarmTable
extends SmiTable {
    TableEntry[] aEntries = null;
    private IntHashMap hash;
    private boolean hashModified = true;
    private BSnmpNetwork snmp;
    private int capacity;
    static /* synthetic */ Class class$com$tridium$snmp$mib$table$TableEntry;

    public AlarmTable(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
        this.capacity = bSnmpNetwork.getSnmpAlarmTableCapacity();
        this.hash = new IntHashMap(this.capacity);
    }

    public synchronized AlarmEntry addAlarmEntry(BAlarmRecord bAlarmRecord) {
        Object object;
        if (this.capacity < 1) {
            return new AlarmEntry(bAlarmRecord, 0);
        }
        BUuid bUuid = bAlarmRecord.getUuid();
        IntHashMap.Iterator iterator = this.hash.iterator();
        int n = 0;
        int n2 = 0;
        BAbsTime bAbsTime = BAbsTime.now();
        while (iterator.hasNext()) {
            object = (SnmpAlarmInfo)iterator.next();
            BUuid bUuid2 = ((SnmpAlarmInfo)object).uuid;
            BAbsTime bAbsTime2 = ((SnmpAlarmInfo)object).lastUpdate;
            if (bUuid.equals((Object)bUuid2)) {
                n = ((SnmpAlarmInfo)object).index;
                break;
            }
            if (!bAbsTime2.isBefore(bAbsTime)) continue;
            bAbsTime = bAbsTime2;
            n2 = iterator.key();
        }
        if (n < 1) {
            n = this.hash.size();
            if (n >= this.capacity) {
                n = n2;
                this.hash.remove(n);
                if (n >= this.capacity) {
                    n = 1;
                }
            } else if (this.hash.get(n) != null) {
                n = 1;
            } else if (n < 1) {
                n = 1;
            }
            while (this.hash.get(n) != null) {
                ++n;
            }
        }
        this.hash.put(n, (Object)new SnmpAlarmInfo(bAlarmRecord.getUuid(), bAlarmRecord.getLastUpdate(), n));
        this.hashModified = true;
        this.aEntries = null;
        object = new AlarmEntry(bAlarmRecord, n);
        if (this.snmp.getSnmpLog().isTraceOn()) {
            this.snmp.getSnmpLog().trace("Alarm Table added new entry: " + object);
        }
        return object;
    }

    public synchronized void setCapacity(int n) {
        this.capacity = n;
        if (n < 1) {
            this.clearAlarmTable();
            return;
        }
        int n2 = this.hash.size();
        if (n2 > n) {
            Object[] objectArray = new SnmpAlarmInfo[n2];
            this.hash.toArray(objectArray);
            SortUtil.sort((Object[])objectArray);
            int n3 = n2 - n;
            for (int i = 0; i < n3; ++i) {
                this.hash.remove(((SnmpAlarmInfo)objectArray[i]).index);
            }
        }
        this.hashModified = true;
    }

    public synchronized void clearAlarmTable() {
        this.hash.clear();
        this.hashModified = true;
    }

    public void acknowledgeAll() {
        TableEntry[] tableEntryArray = this.getArray();
        try {
            for (int i = 0; i < tableEntryArray.length; ++i) {
                AlarmEntry alarmEntry = (AlarmEntry)tableEntryArray[i];
                if (alarmEntry.isAcked()) continue;
                this.acknowledge(alarmEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AlarmEntry getAlarm(int n) {
        Object object = this.hash.get(n);
        if (object == null) {
            return null;
        }
        SnmpAlarmInfo snmpAlarmInfo = (SnmpAlarmInfo)object;
        try {
            BAlarmRecord bAlarmRecord = this.getAlarmService().getAlarmDb().getRecord(snmpAlarmInfo.uuid);
            if (bAlarmRecord == null) {
                return null;
            }
            return new AlarmEntry(bAlarmRecord, snmpAlarmInfo.index);
        }
        catch (Exception exception) {
            this.snmp.getSnmpLog().error("Could not find alarm for index " + n, (Throwable)exception);
            return null;
        }
    }

    public synchronized TableEntry[] getArray() {
        Object object;
        if (!this.hashModified) {
            return this.aEntries;
        }
        Array array = new Array(class$com$tridium$snmp$mib$table$TableEntry == null ? (class$com$tridium$snmp$mib$table$TableEntry = AlarmTable.class$("com.tridium.snmp.mib.table.TableEntry")) : class$com$tridium$snmp$mib$table$TableEntry, this.hash.size());
        IntHashMap.Iterator iterator = this.hash.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            object = this.getAlarm(iterator.key());
            if (object == null) continue;
            array.add(object);
        }
        this.aEntries = (TableEntry[])array.trim();
        object = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((TableEntry)object).getIndex() - ((TableEntry)object2).getIndex();
            }
        };
        SortUtil.sort((Object[])this.aEntries, (Object[])this.aEntries, (Comparator)object);
        this.hashModified = false;
        return this.aEntries;
    }

    public void acknowledge(AlarmEntry alarmEntry) {
        block2: {
            try {
                BAlarmRecord bAlarmRecord = alarmEntry.getAlarmRecord();
                bAlarmRecord.setAckState(BAckState.acked);
                this.getAlarmService().ackAlarm(bAlarmRecord);
            }
            catch (Exception exception) {
                if (this.snmp == null) break block2;
                this.snmp.getSnmpLog().error("Exception generated in Alarm Table during received acknowledgement for entry: " + alarmEntry, (Throwable)exception);
            }
        }
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SnmpAlarmInfo
    implements Comparable {
        BUuid uuid;
        BAbsTime lastUpdate;
        int index;

        SnmpAlarmInfo(BUuid bUuid, BAbsTime bAbsTime, int n) {
            this.uuid = bUuid;
            this.lastUpdate = bAbsTime;
            this.index = n;
        }

        public int compareTo(Object object) {
            SnmpAlarmInfo snmpAlarmInfo = (SnmpAlarmInfo)object;
            return this.lastUpdate.compareTo((Object)snmpAlarmInfo.lastUpdate);
        }
    }
}

