/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.export.BSnmpExportFolder;
import com.tridium.snmp.mib.GenericMib;
import com.tridium.snmp.mib.MibAlarmTable;
import com.tridium.snmp.mib.MibIISystem;
import com.tridium.snmp.mib.MibPointTable;
import com.tridium.snmp.mib.NiagObject;
import com.tridium.snmp.mib.TridiumStation;
import com.tridium.snmp.mib.table.PointContainer;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.object.BSnmpObjectExt;
import com.tridium.snmp.util.LocalToMib;

public class TridiumMib
extends GenericMib {
    public static final int TRIDIUM_ENTERPRISE = 4131;
    public static final String TRIDIUM = "1.3.6.1.4.1.4131";
    public static final String TRIDIUM_STATION = "1.3.6.1.4.1.4131.1";
    public static final String TRIDIUM_VERSION = "1.3.6.1.4.1.4131.1.1.0";
    public static final String TRIDIUM_ACTION = "1.3.6.1.4.1.4131.1.2.0";
    public static final String TRIDIUM_ALARM_TABLE = "1.3.6.1.4.1.4131.1.3";
    public static final String TRIDIUM_TIME_STAMP = "1.3.6.1.4.1.4131.1.3.1.1";
    public static final String TRIDIUM_UUID = "1.3.6.1.4.1.4131.1.3.1.2";
    public static final String TRIDIUM_SOURCE_STATE = "1.3.6.1.4.1.4131.1.3.1.3";
    public static final String TRIDIUM_ACK_STATE = "1.3.6.1.4.1.4131.1.3.1.4";
    public static final String TRIDIUM_ACK_REQUIRED = "1.3.6.1.4.1.4131.1.3.1.5";
    public static final String TRIDIUM_SOURCE = "1.3.6.1.4.1.4131.1.3.1.6";
    public static final String TRIDIUM_ALARM_CLASS = "1.3.6.1.4.1.4131.1.3.1.7";
    public static final String TRIDIUM_PRIORITY = "1.3.6.1.4.1.4131.1.3.1.8";
    public static final String TRIDIUM_NORMAL_TIME = "1.3.6.1.4.1.4131.1.3.1.9";
    public static final String TRIDIUM_ACK_TIME = "1.3.6.1.4.1.4131.1.3.1.10";
    public static final String TRIDIUM_USER = "1.3.6.1.4.1.4131.1.3.1.11";
    public static final String TRIDIUM_ALARM_DATA = "1.3.6.1.4.1.4131.1.3.1.12";
    public static final String TRIDIUM_ALARM_TRANSITION = "1.3.6.1.4.1.4131.1.3.1.13";
    public static final String TRIDIUM_LAST_UPDATE = "1.3.6.1.4.1.4131.1.3.1.14";
    public static final String TRIDIUM_INPUT_TABLE = "1.3.6.1.4.1.4131.1.4";
    public static final String TRIDIUM_INPUT_INDEX = "1.3.6.1.4.1.4131.1.4.1.1";
    public static final String TRIDIUM_INPUT_NAME = "1.3.6.1.4.1.4131.1.4.1.2";
    public static final String TRIDIUM_INPUT_VALUE = "1.3.6.1.4.1.4131.1.4.1.3";
    public static final String TRIDIUM_OUTPUT_TABLE = "1.3.6.1.4.1.4131.1.5";
    public static final String TRIDIUM_OUTPUT_INDEX = "1.3.6.1.4.1.4131.1.5.1.1";
    public static final String TRIDIUM_OUTPUT_NAME = "1.3.6.1.4.1.4131.1.5.1.2";
    public static final String TRIDIUM_OUTPUT_VALUE = "1.3.6.1.4.1.4131.1.5.1.3";
    public static final String TRIDIUM_EXPORT_TABLE = "1.3.6.1.4.1.4131.1.6";
    public static final String TRIDIUM_OBJECT_TABLE = "1.3.6.1.4.1.4131.1.7";
    private static BSnmpAccessEnum RW = BSnmpAccessEnum.readWrite;
    private static BSnmpAccessEnum RO = BSnmpAccessEnum.readOnly;

    public TridiumMib(BSnmpNetwork bSnmpNetwork) {
        super(bSnmpNetwork);
        this.init(bSnmpNetwork);
    }

    protected void init(BSnmpNetwork bSnmpNetwork) {
        this.addOidEntry("1.3.6.1.2.1.1.1.0", 3, "mandatory", RO, new MibIISystem(bSnmpNetwork), "System Description", "The System Description");
        this.addOidEntry("1.3.6.1.2.1.1.2.0", 3, "mandatory", RO, new MibIISystem(bSnmpNetwork), "Object ID", "The Object ID");
        this.addOidEntry("1.3.6.1.2.1.1.3.0", 3, "mandatory", RO, new MibIISystem(bSnmpNetwork), "System up time", "The System Up Time");
        this.addOidEntry("1.3.6.1.2.1.1.4.0", 3, "mandatory", RO, new MibIISystem(bSnmpNetwork), "contact", "The Contact");
        this.addOidEntry("1.3.6.1.2.1.1.5.0", 3, "mandatory", RW, new MibIISystem(bSnmpNetwork), "System Name", "The System Name");
        this.addOidEntry("1.3.6.1.2.1.1.6.0", 3, "mandatory", RW, new MibIISystem(bSnmpNetwork), "System location", "The System Location");
        this.addOidEntry("1.3.6.1.2.1.1.7.0", 3, "mandatory", RO, new MibIISystem(bSnmpNetwork), "System Services", "The System Services");
        this.addOidEntry(TRIDIUM_VERSION, 3, "mandatory", RO, new TridiumStation(bSnmpNetwork), "Tridium Version", "The Tridium Version");
        this.addOidEntry(TRIDIUM_ACTION, 3, "mandatory", RO, new TridiumStation(bSnmpNetwork), "Tridium Action", "The Tridium Action");
        this.addOidEntry(TRIDIUM_ALARM_TABLE, 4, "mandatory", RO, new MibAlarmTable(bSnmpNetwork), "Tridium Alarm Table", "The Tridium Alarm Table");
        this.addOidEntry(TRIDIUM_INPUT_TABLE, 4, "mandatory", RO, new MibPointTable(bSnmpNetwork, TRIDIUM_INPUT_TABLE, true), "Tridium input Table", "The Tridium input Table");
        this.addOidEntry(TRIDIUM_OUTPUT_TABLE, 4, "mandatory", RO, new MibPointTable(bSnmpNetwork, TRIDIUM_OUTPUT_TABLE, false), "Tridium output Table", "The Tridium output Table");
        this.addTableEntries("Exports", bSnmpNetwork.getLocalDevice().getExports());
        BSnmpExportFolder[] bSnmpExportFolderArray = LocalToMib.getExportFolders(bSnmpNetwork.getLocalDevice());
        for (int i = 0; i < bSnmpExportFolderArray.length; ++i) {
            this.addTableEntries(bSnmpExportFolderArray[i].getDisplayName(null), bSnmpExportFolderArray[i]);
        }
        this.addObjects(bSnmpNetwork);
    }

    private void addTableEntries(String string, PointContainer pointContainer) {
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        String string3 = pointContainer.getObjectIdentifier() + ".1";
        this.addOidEntry(string3, 4, "mandatory", RO, new MibPointTable(pointContainer, string3, true), string2 + " input Table", string2 + " input Table");
        string3 = pointContainer.getObjectIdentifier() + ".2";
        this.addOidEntry(string3, 4, "mandatory", RO, new MibPointTable(pointContainer, string3, false), string2 + " output Table", string2 + " output Table");
    }

    private void addObjects(BSnmpNetwork bSnmpNetwork) {
        PointTable pointTable = bSnmpNetwork.objects();
        TableEntry[] tableEntryArray = pointTable.getArray();
        NiagObject niagObject = new NiagObject(bSnmpNetwork, pointTable);
        for (int i = 0; i < tableEntryArray.length; ++i) {
            BSnmpObjectExt bSnmpObjectExt = (BSnmpObjectExt)tableEntryArray[i];
            String string = bSnmpObjectExt.getName();
            String string2 = bSnmpObjectExt.getObjectIdentifier();
            BSnmpAccessEnum bSnmpAccessEnum = bSnmpObjectExt.isSettablePoint() ? RW : RO;
            this.addOidEntry(string2, 3, "mandatory", bSnmpAccessEnum, niagObject, string, string);
        }
    }

    protected String getName() {
        return "TridiumMib";
    }
}

