/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.OidElement;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;

public class OidEntry
extends OidElement {
    String oid;
    MibObject mibObj;
    BSnmpAccessEnum access;
    String name;
    String status;
    String desc;
    String objSyntax;
    BSnmpVariableTypeEnum varType;
    BSnmpMipEntryTypeEnum elementType;
    public BEnumRange enumRange = null;
    public Range range = null;
    public Range size = null;

    public OidEntry(String string, int n, String string2, String string3, String string4, MibObject mibObject, long l, BSnmpAccessEnum bSnmpAccessEnum) {
        super(l);
        this.oid = string;
        this.entryType = n;
        this.access = bSnmpAccessEnum;
        this.name = string2;
        this.status = string3;
        this.desc = string4;
        this.mibObj = mibObject;
    }

    public OidEntry(String string, int n, String string2, String string3, String string4, MibObject mibObject, long l, BSnmpAccessEnum bSnmpAccessEnum, String string5, BSnmpMipEntryTypeEnum bSnmpMipEntryTypeEnum, BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        this(string, n, string2, string3, string4, mibObject, l, bSnmpAccessEnum);
        this.objSyntax = string5;
        this.elementType = bSnmpMipEntryTypeEnum;
        this.varType = bSnmpVariableTypeEnum;
    }

    public String toString() {
        return super.toString() + "  oid = " + this.oid;
    }

    public boolean isOidEntry() {
        return true;
    }

    public BSnmpMipEntryTypeEnum getElementType() {
        return this.elementType;
    }

    public String getOid() {
        return this.oid;
    }

    public BSnmpAccessEnum getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getObjSyntax() {
        return this.objSyntax;
    }

    public MibObject getMibObject() {
        return this.mibObj;
    }

    public BSnmpVariableTypeEnum getVariableType() {
        return this.varType;
    }

    public BFacets getRangeFacets() {
        if (this.range == null) {
            return BFacets.DEFAULT;
        }
        return BFacets.makeNumeric(null, (int)1, (double)this.range.min, (double)this.range.max);
    }

    public static class Range {
        double min;
        double max;
    }
}

