/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.table.PointEntry;
import com.tridium.snmp.mib.table.PointTable;
import com.tridium.snmp.object.BSnmpObjectExt;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;

public class NiagObject
implements MibObject,
SnmpConst {
    public static final int LEVEL = 9;
    PointTable pt;

    public NiagObject(BSnmpNetwork bSnmpNetwork, PointTable pointTable) {
        this.pt = pointTable;
    }

    public SnmpVar getValue(SnmpOID snmpOID) {
        try {
            int n = this.getIndex(snmpOID);
            if (n == -1) {
                return null;
            }
            PointEntry pointEntry = (PointEntry)this.pt.getObject(n);
            if (pointEntry == null) {
                return null;
            }
            return pointEntry.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private int getIndex(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        if (lArray.length <= 9) {
            return -1;
        }
        return (int)lArray[9];
    }

    public SnmpOID getNextOid(SnmpOID snmpOID) {
        try {
            long[] lArray = snmpOID.toLongArray();
            if (lArray.length <= 9) {
                return new SnmpOID("1.3.6.1.4.1.4131.1.1.0.0");
            }
            PointEntry pointEntry = (PointEntry)this.pt.getNextEntry((int)lArray[9]);
            if (pointEntry == null) {
                return null;
            }
            return new SnmpOID(((BSnmpObjectExt)pointEntry).getObjectIdentifier());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public int validateForSet(SnmpVarBind snmpVarBind) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        int n = this.getIndex(snmpOID);
        PointEntry pointEntry = (PointEntry)this.pt.getObject(n);
        if (pointEntry == null) {
            return 6;
        }
        if (!pointEntry.isSettablePoint()) {
            return 17;
        }
        try {
            pointEntry.tryDecodeForSet(snmpVarBind.getVariable());
        }
        catch (Throwable throwable) {
            return 7;
        }
        return 0;
    }

    public int setValue(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU) {
        try {
            SnmpOID snmpOID = snmpVarBind.getObjectID();
            int n = this.getIndex(snmpOID);
            PointEntry pointEntry = (PointEntry)this.pt.getObject(n);
            if (pointEntry == null) {
                return 2;
            }
            if (!pointEntry.isSettablePoint()) {
                return 4;
            }
            SnmpVar snmpVar = pointEntry.setValue(snmpVarBind.getVariable());
            if (snmpVar == null) {
                return 3;
            }
            snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, snmpVar));
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 3;
        }
    }
}

