/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.util.SnmpUtil;

public abstract class MibTable
implements MibObject {
    private int numberRows;
    private int numberColumns;

    public abstract int getObjectLevel();

    public abstract int getLastId();

    public abstract TableEntry getNextEntry(int var1);

    public abstract String getFirstOid();

    public int getNumberRows() {
        return this.numberRows;
    }

    public int getNumberColumns() {
        return this.numberColumns;
    }

    public void setNumberRows(int n) {
        this.numberRows = n;
    }

    public void setNumberColumns(int n) {
        this.numberColumns = n;
    }

    boolean isOidForMyTable(long[] lArray) {
        int n = this.getObjectLevel();
        if (lArray.length < n) {
            return false;
        }
        long[] lArray2 = SnmpUtil.getLongArray(this.getFirstOid());
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public SnmpOID getNextOid(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArrayCopy();
        int n = this.getObjectLevel();
        int n2 = n + 1;
        TableEntry tableEntry = this.getNextEntry(0);
        if (tableEntry == null) {
            return null;
        }
        long l = tableEntry.getIndex();
        if (!this.isOidForMyTable(lArray) || lArray.length < n || lArray[n] == 0L) {
            return new SnmpOID(this.getFirstOid() + "." + l);
        }
        if (lArray[n] > (long)this.getLastId()) {
            return null;
        }
        if (lArray.length == n2) {
            return new SnmpOID(snmpOID + "." + l);
        }
        long l2 = lArray[n2];
        tableEntry = this.getNextEntry((int)l2);
        if (tableEntry == null) {
            if (lArray[n] >= (long)this.getLastId()) {
                return null;
            }
            int n3 = n;
            lArray[n3] = lArray[n3] + 1L;
            lArray[n2] = this.getNextEntry(0).getIndex();
        } else {
            lArray[n2] = tableEntry.getIndex();
        }
        return new SnmpOID(lArray);
    }
}

