/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpTimeticks;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;

public class MibIISystem
implements MibObject,
SnmpConst,
MibConst {
    private BSnmpNetwork snmp;
    public static final int LEVEL = 7;
    public static final int DESCR = 1;
    public static final int OBJECT_ID = 2;
    public static final int UP_TIME = 3;
    public static final int CONTACT = 4;
    public static final int NAME = 5;
    public static final int LOCATION = 6;
    public static final int SERVICES = 7;

    public MibIISystem(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    public SnmpVar getValue(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        SnmpVar snmpVar = null;
        switch ((int)lArray[7]) {
            case 1: {
                snmpVar = new SnmpString("Tridium station");
                break;
            }
            case 2: {
                snmpVar = new SnmpOID("1.3.6.1.4.1.4131.1");
                break;
            }
            case 3: {
                snmpVar = new SnmpTimeticks(this.snmp().getTimeTick());
                break;
            }
            case 4: {
                snmpVar = new SnmpString(this.snmp().getContact());
                break;
            }
            case 5: {
                snmpVar = new SnmpString(this.snmp().getSystemName());
                break;
            }
            case 6: {
                snmpVar = new SnmpString(this.snmp().getLocation());
                break;
            }
            case 7: {
                snmpVar = new SnmpInt(72);
                break;
            }
            default: {
                return null;
            }
        }
        return snmpVar;
    }

    public int validateForSet(SnmpVarBind snmpVarBind) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        try {
            switch ((int)lArray[7]) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    return 17;
                }
                case 4: {
                    ((SnmpString)snmpVarBind.getVariable()).toValue();
                    break;
                }
                case 5: {
                    ((SnmpString)snmpVarBind.getVariable()).toValue();
                    break;
                }
                case 6: {
                    ((SnmpString)snmpVarBind.getVariable()).toValue();
                    break;
                }
                default: {
                    return 6;
                }
            }
        }
        catch (Exception exception) {
            return 7;
        }
        return 0;
    }

    public int setValue(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        long[] lArray = snmpOID.toLongArray();
        SnmpString snmpString = null;
        try {
            switch ((int)lArray[7]) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    return 4;
                }
                case 4: {
                    this.snmp().setContact(((SnmpString)snmpVarBind.getVariable()).toValue());
                    snmpString = new SnmpString(this.snmp().getContact());
                    break;
                }
                case 5: {
                    this.snmp().setSystemName(((SnmpString)snmpVarBind.getVariable()).toValue());
                    snmpString = new SnmpString(this.snmp().getSystemName());
                    break;
                }
                case 6: {
                    this.snmp().setLocation(((SnmpString)snmpVarBind.getVariable()).toValue());
                    snmpString = new SnmpString(this.snmp().getLocation());
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        catch (Exception exception) {
            return 3;
        }
        snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, snmpString));
        return 0;
    }

    public SnmpOID getNextOid(SnmpOID snmpOID) {
        long[] lArray = snmpOID.toLongArray();
        if (lArray.length <= 8) {
            return new SnmpOID("1.3.6.1.2.1.1.1.0.0");
        }
        if (lArray[7] >= 7L) {
            return null;
        }
        lArray[7] = lArray[7] + 1L;
        return new SnmpOID(lArray);
    }
}

