/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.enums.BSnmpAccessEnum;
import com.tridium.snmp.mib.MibConst;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.OidElement;
import com.tridium.snmp.mib.OidEntry;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpExceptionVar;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import java.util.StringTokenizer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;

public class GenericMib
implements MibConst,
SnmpConst {
    private OidElement oidBase = new OidElement(1L);
    protected BSnmpNetwork snmp;
    public static final String SYSTEM_DESCR = "1.3.6.1.2.1.1.1.0";
    public static final String SYSTEM_OBJECT_ID = "1.3.6.1.2.1.1.2.0";
    public static final String SYSTEM_UP_TIME = "1.3.6.1.2.1.1.3.0";
    public static final String SYSTEM_CONTACT = "1.3.6.1.2.1.1.4.0";
    public static final String SYSTEM_NAME = "1.3.6.1.2.1.1.5.0";
    public static final String SYSTEM_LOCATION = "1.3.6.1.2.1.1.6.0";
    public static final String SYSTEM_SERVICES = "1.3.6.1.2.1.1.7.0";
    public static final String MIBII_SNMP = "1.3.6.1.2.1.11";

    public GenericMib(BSnmpNetwork bSnmpNetwork) {
        this.snmp = bSnmpNetwork;
    }

    public int validateForSet(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU, int n) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        OidElement oidElement = this.findElement(snmpOID.toLongArray());
        int n2 = 0;
        n2 = oidElement == null || !oidElement.isOidEntry() ? 11 : ((OidEntry)oidElement).getMibObject().validateForSet(snmpVarBind);
        if (n == 0) {
            n2 = this.makeV1Error(n2);
        }
        return n2;
    }

    private int makeV1Error(int n) {
        if (n < 6) {
            return n;
        }
        switch (n) {
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 17: {
                return 4;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                return 5;
            }
        }
        return 5;
    }

    public int processSet(SnmpVarBind snmpVarBind, SnmpPDU snmpPDU, int n) {
        SnmpOID snmpOID = snmpVarBind.getObjectID();
        OidElement oidElement = this.findElement(snmpOID.toLongArray());
        if (oidElement == null || !oidElement.isOidEntry()) {
            return n == 0 ? 2 : 6;
        }
        return ((OidEntry)oidElement).getMibObject().setValue(snmpVarBind, snmpPDU);
    }

    public int processGet(SnmpOID snmpOID, SnmpPDU snmpPDU, int n) {
        OidElement oidElement = this.findElement(snmpOID.toLongArray());
        SnmpVar snmpVar = null;
        if (oidElement == null || !oidElement.isOidEntry()) {
            if (n == 0) {
                return 2;
            }
            snmpVar = new SnmpExceptionVar(128);
        } else {
            snmpVar = ((OidEntry)oidElement).getMibObject().getValue(snmpOID);
            if (snmpVar == null) {
                if (n == 0) {
                    return 2;
                }
                snmpVar = new SnmpExceptionVar(129);
            }
        }
        snmpPDU.addVariableBinding(new SnmpVarBind(snmpOID, snmpVar));
        return 0;
    }

    public SnmpVarBind processGetNext(SnmpOID snmpOID) {
        OidEntry oidEntry = this.findNext(snmpOID);
        if (oidEntry == null) {
            return null;
        }
        SnmpOID snmpOID2 = null;
        SnmpVar snmpVar = null;
        switch (oidEntry.entryType) {
            case 4: {
                MibObject mibObject = oidEntry.mibObj;
                snmpOID2 = mibObject.getNextOid(snmpOID);
                snmpVar = mibObject.getValue(snmpOID2);
                break;
            }
            default: {
                snmpOID2 = new SnmpOID(oidEntry.getOid());
                snmpVar = oidEntry.mibObj.getValue(snmpOID2);
            }
        }
        return new SnmpVarBind(snmpOID2, snmpVar);
    }

    protected OidElement findElement(long[] lArray) {
        OidElement oidElement = this.oidBase;
        int n = 1;
        while (n < lArray.length) {
            if ((oidElement = oidElement.getChild(lArray[n++])) == null) {
                return null;
            }
            if (!oidElement.isOidEntry()) continue;
            return oidElement;
        }
        return oidElement;
    }

    protected OidEntry findNext(SnmpOID snmpOID) {
        OidEntry oidEntry = (OidEntry)this.findElementForNext(snmpOID.toLongArray());
        do {
            if (oidEntry == null) {
                return null;
            }
            if (oidEntry.entryType == 3) {
                return oidEntry;
            }
            SnmpOID snmpOID2 = oidEntry.mibObj.getNextOid(snmpOID);
            if (snmpOID2 == null) continue;
            return oidEntry;
        } while ((oidEntry = this.findNextEntry(oidEntry)) != null);
        return null;
    }

    private OidElement findElementForNext(long[] lArray) {
        OidElement oidElement = this.oidBase;
        for (int i = 1; i < lArray.length; ++i) {
            long l = lArray[i];
            OidElement oidElement2 = oidElement.child;
            while (true) {
                if (oidElement2 == null) {
                    return null;
                }
                if (oidElement2.index == l) break;
                if (oidElement2.index > l) {
                    return this.bury(oidElement2);
                }
                oidElement2 = oidElement2.next;
            }
            oidElement = oidElement2;
            if (!oidElement.isOidEntry()) continue;
            break;
        }
        if (!oidElement.isOidEntry()) {
            return this.bury(oidElement);
        }
        if (oidElement.entryType == 3) {
            return this.findNextEntry((OidEntry)oidElement);
        }
        return oidElement;
    }

    private OidElement bury(OidElement oidElement) {
        OidElement oidElement2 = oidElement;
        while (!oidElement2.isOidEntry()) {
            oidElement2 = oidElement2.child;
        }
        return oidElement2;
    }

    private OidEntry findNextEntry(OidEntry oidEntry) {
        OidEntry[] oidEntryArray = this.getOidEntries();
        for (int i = 0; i < oidEntryArray.length - 1; ++i) {
            if (oidEntryArray[i] != oidEntry) continue;
            return oidEntryArray[i + 1];
        }
        return null;
    }

    protected OidEntry findOidEntry(SnmpOID snmpOID) {
        OidEntry[] oidEntryArray = this.getOidEntries();
        String string = snmpOID.toString();
        String string2 = string + ".0";
        for (int i = 0; i < oidEntryArray.length; ++i) {
            if (oidEntryArray[i].oid.compareTo(string) != 0 && oidEntryArray[i].oid.compareTo(string2) != 0) continue;
            return oidEntryArray[i];
        }
        return null;
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    protected void init() {
    }

    protected void addOidEntry(String string, int n, String string2, BSnmpAccessEnum bSnmpAccessEnum, MibObject mibObject, String string3, String string4) {
        OidElement oidElement = this.oidBase;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextElement();
        long l = Long.parseLong((String)stringTokenizer.nextElement());
        while (stringTokenizer.hasMoreElements()) {
            OidElement oidElement2 = oidElement.getChild(l);
            if (oidElement2 == null) {
                oidElement2 = new OidElement(l);
                oidElement.addChild(oidElement2);
            }
            oidElement = oidElement2;
            l = Long.parseLong((String)stringTokenizer.nextElement());
        }
        oidElement.addChild(new OidEntry(string, n, string3, string2, string4, mibObject, l, bSnmpAccessEnum));
    }

    public OidEntry[] getOidEntries() {
        return this.oidBase.getOidEntries();
    }

    public OidElement getOidBase() {
        return this.oidBase;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startTable(true);
        spyWriter.w((Object)"<tr>").th((Object)(this.getName() + " as of " + BAbsTime.now())).w((Object)"</tr>\n");
        this.spyElem(spyWriter, this.oidBase);
        spyWriter.endTable();
    }

    private void spyElem(SpyWriter spyWriter, OidElement oidElement) {
        spyWriter.tr((Object)oidElement.toString());
        if (oidElement.child != null) {
            this.spyElem(spyWriter, oidElement.child);
        }
        if (oidElement.next != null) {
            this.spyElem(spyWriter, oidElement.next);
        }
    }

    public void dump() {
        System.out.println(this.getName() + " as of " + BAbsTime.now());
        this.dumpElem(this.oidBase);
    }

    private void dumpElem(OidElement oidElement) {
        System.out.println((oidElement instanceof OidEntry ? "Entry:" : "Elem :") + oidElement.toString());
        if (oidElement.child != null) {
            this.dumpElem(oidElement.child);
        }
        if (oidElement.next != null) {
            this.dumpElem(oidElement.next);
        }
    }

    protected String getName() {
        return "GenericMib";
    }
}

