/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.messages;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.snmptypes.SnmpPDU;

public class SnmpRequest
implements Runnable {
    protected SnmpPDU msg;
    protected boolean responseExpected;
    protected SnmpPDU response = null;
    protected boolean complete = false;
    protected BSnmpNetwork snmpNet;
    protected int timeout;
    protected int retryCount;

    public SnmpRequest() {
    }

    public SnmpRequest(BSnmpNetwork bSnmpNetwork, SnmpPDU snmpPDU, int n, int n2, boolean bl) {
        this.snmpNet = bSnmpNetwork;
        this.msg = snmpPDU;
        this.timeout = n;
        this.retryCount = n2;
        this.responseExpected = bl;
    }

    public String toString() {
        return new String("SnmpRequest: " + this.msg);
    }

    public void run() {
        this.execute();
    }

    public synchronized void execute() {
        this.response = null;
        try {
            if (this.msg == null) {
                this.snmpNet.getSnmpLog().message("SnmpRequest received null message to send.  Not sending null message.");
                return;
            }
            if (!this.responseExpected) {
                this.snmpNet.snmpDriver().send(this.msg);
            } else {
                this.response = this.snmpNet.snmpDriver().sendRequest(this.msg, this.timeout, this.retryCount);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.snmpNet != null) {
                this.snmpNet.getSnmpLog().error("SnmpRequest caught exception in execute(): ", (Throwable)runtimeException);
            }
            this.complete = true;
            this.notify();
            return;
        }
        this.complete = true;
        this.notify();
    }

    public synchronized SnmpPDU getResponse(int n) {
        block3: {
            if (!this.complete) {
                try {
                    this.wait(n);
                }
                catch (Exception exception) {
                    if (this.snmpNet == null) break block3;
                    this.snmpNet.getSnmpLog().error("SnmpRequest caught exception in getResponse(): ", (Throwable)exception);
                }
            }
        }
        return this.response;
    }
}

