/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.BSnmpNetworkObject;
import com.tridium.snmp.alarm.BSnmpAlarmDeviceExt;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.point.BSnmpProxyExt;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.table.BSnmpTable;
import com.tridium.snmp.util.BSnmpWalkMibJob;
import com.tridium.util.ArrayUtil;
import java.net.InetAddress;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BSnmpDevice
extends BSnmpNetworkObject
implements BIPollable {
    public static final Property pollFrequency = BSnmpDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property retryCount = BSnmpDevice.newProperty((int)0, (int)2, null);
    public static final Property responseTimeout = BSnmpDevice.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    public static final Property ipAddress = BSnmpDevice.newProperty((int)0, (String)"", null);
    public static final Property port = BSnmpDevice.newProperty((int)0, (int)161, (BFacets)BFacets.makeInt(null, (int)0, (int)4999));
    public static final Property snmpVersion = BSnmpDevice.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    public static final Property community = BSnmpDevice.newProperty((int)0, (String)"public", null);
    public static final Property maxVariableBindingsPerRequest = BSnmpDevice.newProperty((int)0, (int)10, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property points = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpPointDeviceExt(), null);
    public static final Property traps = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpAlarmDeviceExt(), null);
    public static final Property mib = BSnmpDevice.newProperty((int)0, (String)"", null);
    public static final Action walkMib = BSnmpDevice.newAction((int)4, (BValue)new BMibListTable(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$snmp$BSnmpDevice == null ? (class$com$tridium$snmp$BSnmpDevice = BSnmpDevice.class$("com.tridium.snmp.BSnmpDevice")) : class$com$tridium$snmp$BSnmpDevice));
    Vector tables = null;
    BSnmpNetwork net = null;
    static /* synthetic */ Class class$com$tridium$snmp$BSnmpDevice;
    static /* synthetic */ Class class$com$tridium$snmp$point$BSnmpProxyExt;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    public void setResponseTimeout(BRelTime bRelTime) {
        this.set(responseTimeout, (BValue)bRelTime, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String string) {
        this.setString(ipAddress, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public int getSnmpVersion() {
        return this.getInt(snmpVersion);
    }

    public void setSnmpVersion(int n) {
        this.setInt(snmpVersion, n, null);
    }

    public String getCommunity() {
        return this.getString(community);
    }

    public void setCommunity(String string) {
        this.setString(community, string, null);
    }

    public int getMaxVariableBindingsPerRequest() {
        return this.getInt(maxVariableBindingsPerRequest);
    }

    public void setMaxVariableBindingsPerRequest(int n) {
        this.setInt(maxVariableBindingsPerRequest, n, null);
    }

    public BPointDeviceExt getPoints() {
        return (BPointDeviceExt)this.get(points);
    }

    public void setPoints(BPointDeviceExt bPointDeviceExt) {
        this.set(points, (BValue)bPointDeviceExt, null);
    }

    public BSnmpAlarmDeviceExt getTraps() {
        return (BSnmpAlarmDeviceExt)this.get(traps);
    }

    public void setTraps(BSnmpAlarmDeviceExt bSnmpAlarmDeviceExt) {
        this.set(traps, (BValue)bSnmpAlarmDeviceExt, null);
    }

    public String getMib() {
        return this.getString(mib);
    }

    public void setMib(String string) {
        this.setString(mib, string, null);
    }

    public BOrd walkMib(BMibListTable bMibListTable) {
        return (BOrd)this.invoke(walkMib, (BValue)bMibListTable, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snmpNet().getPollScheduler().subscribe(this);
    }

    public void stopped() throws Exception {
        this.snmpNet().getPollScheduler().unsubscribe(this);
        super.stopped();
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLexicon().getText("device.strings.snmpDevice")).append("[" + this.getIpAddress() + "]:");
        stringBuffer.append(this.isDown() ? this.getLexicon().getText("device.strings.down") : this.getLexicon().getText("device.strings.up"));
        return stringBuffer.toString();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == status) {
            this.updateMyStatus();
        }
    }

    protected IFuture postPing() {
        if (this.snmpNet() != null) {
            return this.snmpNet().postRequest((Runnable)new Invocation((BComponent)this, ping, null, null));
        }
        this.doPing();
        return null;
    }

    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.snmpNet() == null) {
            this.pingFail("No snmp network found");
            return;
        }
        SnmpPDU snmpPDU = new SnmpPDU(this, 160);
        SnmpOID snmpOID = new SnmpOID("1.3.6.1.2.1.1.1.0");
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID, new SnmpNull());
        snmpPDU.addVariableBinding(snmpVarBind);
        SnmpPDU snmpPDU2 = this.snmpNet().sendAsyncRequest(snmpPDU, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        if (this.snmpNet().getSnmpLog().isTraceOn()) {
            this.snmpNet().getSnmpLog().trace("ping(): SnmpDevice " + this.getName() + "[" + this.getIpAddress() + "] is " + (snmpPDU2 == null ? "down" : "up"));
        }
        if (snmpPDU2 != null) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
    }

    public boolean isActive() {
        return !this.isDisabled() && !this.isDown() && !this.isFault() && this.net.isCommActive();
    }

    public void poll() {
        int n;
        if (!this.isActive() || !Sys.atSteadyState()) {
            return;
        }
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        Array array = new Array(class$com$tridium$snmp$point$BSnmpProxyExt == null ? (class$com$tridium$snmp$point$BSnmpProxyExt = BSnmpDevice.class$("com.tridium.snmp.point.BSnmpProxyExt")) : class$com$tridium$snmp$point$BSnmpProxyExt);
        for (n = 0; n < bControlPointArray.length; ++n) {
            BSnmpProxyExt bSnmpProxyExt;
            if (!(bControlPointArray[n].getProxyExt() instanceof BSnmpProxyExt) || !(bSnmpProxyExt = (BSnmpProxyExt)bControlPointArray[n].getProxyExt()).isCurrentlySubscribed() || bSnmpProxyExt.isConfigFault()) continue;
            array.add((Object)bSnmpProxyExt);
        }
        if (array.size() > 0) {
            this.updateInputs((BSnmpProxyExt[])array.trim());
        }
        if (this.tables != null) {
            for (n = 0; n < this.tables.size(); ++n) {
                ((BSnmpTable)((Object)this.tables.elementAt(n))).poll();
            }
        }
    }

    private void updateMyStatus() {
        if (this.tables != null) {
            for (int i = 0; i < this.tables.size(); ++i) {
                ((BSnmpTable)((Object)this.tables.elementAt(i))).updateStatus();
            }
        }
    }

    private void updateInputs(BSnmpProxyExt[] bSnmpProxyExtArray) {
        int n = this.getMaxVariableBindingsPerRequest();
        int n2 = 0;
        while (n2 < bSnmpProxyExtArray.length) {
            Object object;
            SnmpPDU snmpPDU = new SnmpPDU(this, 160);
            int n3 = n2;
            for (int i = 0; i < n && n2 < bSnmpProxyExtArray.length; ++i) {
                BSnmpProxyExt bSnmpProxyExt = bSnmpProxyExtArray[n2++];
                SnmpOID snmpOID = new SnmpOID(bSnmpProxyExt.getObjectIdentifier());
                object = new SnmpVarBind(snmpOID, new SnmpNull());
                snmpPDU.addVariableBinding((SnmpVarBind)object);
            }
            SnmpPDU snmpPDU2 = this.snmpNet().sendAsyncRequest(snmpPDU, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
            if (snmpPDU2 == null) {
                this.snmpNet().getSnmpLog().error("poll failed in " + this.getName());
                return;
            }
            int n4 = snmpPDU2.getErrstat();
            int n5 = snmpPDU2.getErrindex();
            if (n5 != 0) {
                int n6 = n3 + n5 - 1;
                bSnmpProxyExtArray[n6].readFail(SnmpPDU.translateErrorStatus(n4));
                bSnmpProxyExtArray = (BSnmpProxyExt[])ArrayUtil.removeOne((Object[])bSnmpProxyExtArray, (int)n6);
                n2 = n3;
                continue;
            }
            object = snmpPDU2.getVariableBindings();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                BSnmpProxyExt bSnmpProxyExt = bSnmpProxyExtArray[n3 + i];
                SnmpVarBind snmpVarBind = (SnmpVarBind)((Vector)object).elementAt(i);
                String string = snmpVarBind.getObjectID().toString();
                if (string.lastIndexOf(bSnmpProxyExt.getObjectIdentifier()) == -1) {
                    this.snmpNet().getSnmpLog().error("poll error: " + string + "!=" + bSnmpProxyExt.getObjectIdentifier());
                    continue;
                }
                bSnmpProxyExt.setValue(snmpVarBind.getVariable());
            }
        }
    }

    public void registerTable(BSnmpTable bSnmpTable) {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        if (this.tables.contains((Object)bSnmpTable)) {
            return;
        }
        this.tables.add(bSnmpTable);
    }

    public void unregisterTable(BSnmpTable bSnmpTable) {
        if (this.tables == null) {
            return;
        }
        this.tables.removeElement((Object)bSnmpTable);
    }

    public synchronized SnmpPDU updateGetNext(String string) {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return null;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setVersion(this.getVersion());
        snmpPDU.setReqid(this.snmpNet().getNextReqid());
        snmpPDU.setCommand(161);
        snmpPDU.setRemotePort(this.getPort());
        snmpPDU.setDestinationIp(inetAddress);
        snmpPDU.setCommunity(this.getCommunity());
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID, new SnmpNull());
        snmpPDU.addVariableBinding(snmpVarBind);
        SnmpPDU snmpPDU2 = this.snmpNet().sendAsyncRequest(snmpPDU, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        return snmpPDU2;
    }

    public synchronized SnmpPDU updateGet(String string) {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return null;
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setVersion(this.getVersion());
        snmpPDU.setReqid(this.snmpNet().getNextReqid());
        snmpPDU.setCommand(160);
        snmpPDU.setRemotePort(this.getPort());
        snmpPDU.setDestinationIp(inetAddress);
        snmpPDU.setCommunity(this.getCommunity());
        SnmpOID snmpOID = new SnmpOID(string);
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID, new SnmpNull());
        snmpPDU.addVariableBinding(snmpVarBind);
        SnmpPDU snmpPDU2 = this.snmpNet().sendAsyncRequest(snmpPDU, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        return snmpPDU2;
    }

    public synchronized int setVar(SnmpVar snmpVar, String string) {
        BSnmpNetwork bSnmpNetwork = this.snmpNet();
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.setVersion(this.getVersion());
        snmpPDU.setReqid(bSnmpNetwork.getNextReqid());
        snmpPDU.setCommand(163);
        snmpPDU.setRemotePort(this.getPort());
        snmpPDU.setDestinationIp(this.getInetAddress());
        snmpPDU.setCommunity(this.getCommunity());
        SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(string), snmpVar);
        snmpPDU.addVariableBinding(snmpVarBind);
        SnmpPDU snmpPDU2 = bSnmpNetwork.sendAsyncRequest(snmpPDU, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        if (snmpPDU2 == null) {
            return -1;
        }
        return snmpPDU2.getErrstat();
    }

    public BSnmpNetwork snmpNet() {
        if (this.net == null) {
            BComplex bComplex = this.getParent();
            while (!(bComplex instanceof BSnmpNetwork)) {
                bComplex = bComplex.getParent();
            }
            this.net = (BSnmpNetwork)bComplex;
        }
        return this.net;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getIpAddress());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getVersion() {
        if (this.getSnmpVersion() == 1) {
            return 0;
        }
        if (this.getSnmpVersion() == 2) {
            return 1;
        }
        this.setSnmpVersion(2);
        return 1;
    }

    public BOrd doWalkMib(BMibListTable bMibListTable) {
        return new BSnmpWalkMibJob(this, bMibListTable).submit(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

