/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bajascript.test;

import com.tridium.bajascript.test.BoxFrameSender;
import com.tridium.bajascript.util.BajaScriptUtil;
import com.tridium.js.test.BJasmineTest;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTest;
import javax.baja.util.BFolder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class BAbstractTestBajaScript
extends BJasmineTest {
    public static final Type TYPE = Sys.loadType(BAbstractTestBajaScript.class);
    protected String testDir;
    protected String jsTestDir;
    protected String envDir;
    protected BFolder testFolder;
    private static final Log log = Log.getLog((String)"bajascript.test");
    private static final String hostName = "localhost";
    private static final int httpPort = 2412;
    private static BoxFrameSender boxFrameSender;
    private BTest.TestStationHandler station;

    public Type getType() {
        return TYPE;
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass() throws Exception {
        System.out.println("*** Starting Station ***");
        this.station = BAbstractTestBajaScript.createTestStation((BOrd)BOrd.make((String)"module://testBajaScript/com/tridium/bajascript/test/rc/BajaScriptTestStation.xml"));
        this.station.startStation();
    }

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        BOrd[] bOrdArray;
        super.beforeMethod();
        if (System.getProperty("bajaScript.debug", "false").equals("true")) {
            System.out.println("*** Running tests directly from file system ***");
            bOrdArray = Sys.getBajaHome().getParent().toString().replace("\\", "/");
            System.out.println("BAbstractTestBajaScript.setup Home: " + (String)bOrdArray);
            this.testDir = "file:/" + (String)bOrdArray + "/util/testBajaScript/src/com/tridium/bajascript/test/";
        } else {
            this.testDir = "module://testBajaScript/com/tridium/bajascript/test/";
        }
        this.jsTestDir = this.testDir + "rc/js/";
        this.envDir = this.jsTestDir + "env/";
        boxFrameSender = new BoxFrameSender(this.getExecutor(), hostName, 2412);
        this.addJavaToJsProp("boxFrameSender", boxFrameSender);
        bOrdArray = BajaScriptUtil.getBsFiles();
        for (int i = 0; i < bOrdArray.length; ++i) {
            boolean bl = bOrdArray[i].toString().indexOf("ctypes.js") == -1 && bOrdArray[i].toString().indexOf("json2.js") == -1;
            this.run(bOrdArray[i], bl);
        }
        this.getExecutor().waitToBeEmpty();
        this.run(BOrd.make((String)(this.envDir + "boxFrameSender.js")), "BoxFrameSender", true);
        this.run(BOrd.make((String)(this.envDir + "setupJasmineEnv.js")), "Setting up Jasmine environment", true);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        super.cleanup();
        System.out.println("*** Stopping Station ***");
        this.station.releaseStation();
        Thread.sleep(1000L);
        System.out.println("*** Station stopped ***");
    }

    protected void fail(String string) {
        log.warning("failed test: " + string);
    }

    protected final void execute() throws Exception {
        this.run(BOrd.make((String)(this.jsTestDir + "rhinoStopTest.js")), "Stopping BajaScript", true);
        this.run(BOrd.make((String)(this.envDir + "rhinoRunBajaScript.js")), "Running BajaScript Jasmine tests", true);
        this.getExecutor().waitToBeEmpty();
        Assert.assertTrue((boolean)this.isTestPassed(), (String)"BajaScript Jasmine Tests Failed");
    }

    protected void run(BOrd bOrd, boolean bl) throws Exception {
        this.run(bOrd, "", bl);
    }

    protected void run(BOrd bOrd, String string, boolean bl) throws Exception {
        BIFile bIFile = (BIFile)bOrd.get();
        if (string.length() == 0) {
            string = bIFile.getFileName();
        }
        System.out.println("*** Loading: " + string + " ***");
        String string2 = FileUtil.readString((BIFile)((BIFile)bOrd.get()));
        if (bl) {
            this.checkWithJsLint(string2);
        }
        this.runJs(string2, string);
    }
}

