<?php

class ServiceUtility {

  public function backup($pluginsBackupDir) {
    if (!file_exists($pluginsBackupDir))
      return false;
    
    $pluginDir = __DIR__;
    $pluginDirName = basename($pluginDir);
    $pluginBackupDir = build_file_path($pluginsBackupDir, $pluginDirName);
    if (!file_exists($pluginBackupDir))
      mkdir($pluginBackupDir, 0777, TRUE);

    $rootBackupDir = build_file_path($pluginBackupDir, "root");
    rmIfExists($rootBackupDir);
    mkdir($rootBackupDir, 0777, TRUE);

    //backup HTTPS cert files 
    $httpsCertsDir = "/etc/nginx/certs";
    if (file_exists($httpsCertsDir)) {
      $tarFilePath = build_file_path($rootBackupDir, "nginx_certs.tar");
      $output = shell_exec("tar -C /etc/nginx -cf $tarFilePath certs && echo 'SUCCESS'");
      if (is_null($output) || preg_match("/SUCCESS\s*$/", $output) != 1) {
        error_log("failed to backup " . $httpsCertsDir . " to " . $tarFilePath);
        return false;
      }
    }

    //backup openvpn config and cert files 
    $openvpnConfDir = "/etc/openvpn";
    if (file_exists($openvpnConfDir)) {
      $tarFilePath = build_file_path($rootBackupDir, "openvpn.tar");
      $output = shell_exec("tar -C /etc -cf $tarFilePath openvpn easy-rsa && echo 'SUCCESS'");
      if (is_null($output) || preg_match("/SUCCESS\s*$/", $output) != 1) {
        error_log("failed to backup " . $openvpnConfDir . " to " . $tarFilePath);
        return false;
      }
    }

    return true;
  }

  public function restore($backupDir) {
    $pluginDir = __DIR__;

    if(!empty($backupDir)) {
      if (!file_exists($backupDir))
        return false;

      $pluginDirName = basename(__DIR__);
      $pluginBackupDir = build_file_path($backupDir, "cpt", "plugins", $pluginDirName);
      $files = array();
      $files[] = build_file_path($pluginBackupDir, 'root');
      foreach($files as $file) {
        if (!file_exists($file))
          continue;

        $dstPath = build_file_path($pluginDir, 'root');
        if (!recurseCopy($file, $dstPath)) {
          error_log("failed to restore " . $file . " to " . $dstPath);
          return false;
        }
      }
    }

    $nginxCertsBackupFile = build_file_path($pluginDir, 'root', 'nginx_certs.tar');
    if (file_exists($nginxCertsBackupFile)) {
      $output = shell_exec("tar -C /etc/nginx -xf $nginxCertsBackupFile && echo 'SUCCESS'");
      if (is_null($output) || preg_match("/SUCCESS\s*$/", $output) != 1) {
        error_log("failed to restore " . $nginxCertsBackupFile . " to /etc/nginx");
        return false;
      }
    }

    $openvpnBackupFile = build_file_path($pluginDir, 'root', 'openvpn.tar');
    if (file_exists($openvpnBackupFile)) {
      $output = shell_exec("tar -C /etc -xf $openvpnBackupFile && echo 'SUCCESS'");
      if (is_null($output) || preg_match("/SUCCESS\s*$/", $output) != 1) {
        error_log("failed to restore " . $openvpnBackupFile . " to /etc");
        return false;
      }
    }

    //cleanup 
    rmIfExists(build_file_path($pluginDir, 'root'));
    return true;
  }
}

return new ServiceUtility();

?>
