<?php

class NetworkConfigUtility {

  //NOTE: network config files are handled(backup/restore) by the general
  //backup and restore process, here we only backup/restore user uploaded cert
  //files
  public function backup($pluginsBackupDir) {
    if (!file_exists($pluginsBackupDir))
      return false;
    
    $pluginDir = __DIR__;
    $pluginDirName = basename($pluginDir);
    $pluginBackupDir = build_file_path($pluginsBackupDir, $pluginDirName);
    if (!file_exists($pluginBackupDir))
      mkdir($pluginBackupDir, 0777, TRUE);

    $files = array();
    $files[] = build_file_path($pluginDir, "uploads"); 
    foreach($files as $file) {
      if (!file_exists($file))
        continue;
      
      $dstPath = build_file_path($pluginBackupDir, basename($file));
      if (!recurseCopy($file, $dstPath)) {
        error_log("failed to backup " . $file . " to " . $dstPath);
        return false;
      }
    }
    return true;
  }

  public function restore($backupDir) {
    if(!empty($backupDir)) {
      if (!file_exists($backupDir))
        return false;

      $pluginDirName = basename(__DIR__);
      $pluginBackupDir = build_file_path($backupDir, "cpt", "plugins", $pluginDirName);
      $files = array();
      $files[] = build_file_path($pluginBackupDir, "uploads");
      foreach($files as $file) {
        if (!file_exists($file))
          continue;

        $dstPath = build_file_path(__DIR__, basename($file));
        if (!recurseCopy($file, $dstPath)) {
          error_log("failed to restore " . $file . " to " . $dstPath);
          return false;
        }
      }
    }
    return true;
  }
}

return new NetworkConfigUtility();

?>
