<?php

class LogoUtility {

  public function backup($pluginsBackupDir) {
    if (!file_exists($pluginsBackupDir))
      return false;
    
    $pluginDir = __DIR__;
    $pluginDirName = basename($pluginDir);
    $pluginBackupDir = build_file_path($pluginsBackupDir, $pluginDirName);
    if (!file_exists($pluginBackupDir))
      mkdir($pluginBackupDir, 0777, TRUE);

    $logoBaseName = isOEM() ? "login-logo-slc" : "login-logo";

    $files = array();
    $files[] = build_file_path(imgPath(), $logoBaseName . ".png");
    $files[] = build_file_path(imgPath(), $logoBaseName . ".png.orig");
    foreach($files as $file) {
      if (!file_exists($file))
        continue;
      
      $dstPath = build_file_path($pluginBackupDir, basename($file));
      if (!recurseCopy($file, $dstPath)) {
        error_log("failed to backup " . $file . " to " . $dstPath);
        return false;
      }
    }
    return true;
  }

  public function restore($backupDir) {
    $logoBaseName = isOEM() ? "login-logo-slc" : "login-logo";
    if(!empty($backupDir)) {
      if (!file_exists($backupDir))
        return false;

      $pluginDirName = basename(__DIR__);
      $pluginBackupDir = build_file_path($backupDir, "cpt", "plugins", $pluginDirName);
      $files = array();
      $files[] = build_file_path($pluginBackupDir, $logoBaseName . ".png");
      $files[] = build_file_path($pluginBackupDir, $logoBaseName . ".png.orig");
      foreach($files as $file) {
        if (!file_exists($file))
          continue;

        $dstPath = build_file_path(imgPath(), basename($file));
        if (!recurseCopy($file, $dstPath)) {
          error_log("failed to restore " . $file . " to " . $dstPath);
          return false;
        }
      }
    }

    return true;
  }
}

return new LogoUtility();

?>
