"use strict";
$(function() {

  //define components 
  var featureAccessControlComp = { //{{{1
    template: '#feature_access_control_template',
    data: function() {
      return {
        feature_mapping: window.feature_mapping,
        features: _.keys(window.feature_mapping),
        rules: window.access_rules,
        spinner: null,
      };
    },
    methods: {
      getSpinner: function() {
        if (!this.spinner)
          this.spinner = new Spinner();
        return this.spinner;
      },

      doSave: function() {
        let self = this;
        $.ajax({
          type: 'POST',
          dataType: 'json',
          data: {action: 'update_rules', rules: this.rules},
          beforeSend: function() {
            self.getSpinner().spin(self.$el);
          },
          success: function(resp) {
            if (resp.redirect)
              redirect(resp.redirect);
          },
          error: function(data, status) {
            console.warn("failed to save feature access contro l data");
            console.warn(data);
          },
          complete: function() {
            self.getSpinner().stop();
          },
        });
      },
      onFeatureChanged: function(user_name, feature, enabled) {
        if (enabled)
          return; 

        //when disable a parent feature, disable all its children features for the same user
        for (var i=0; i<this.rules.length; ++i) {
          var rule = this.rules[i];
          if (rule.user_name != user_name)
            continue;

          for (var j=0; j<this.features.length; ++j) {
            var fid = this.features[j];
            if (this.feature_mapping[fid].parent === undefined || this.feature_mapping[fid].parent != feature)
              continue;
            rule.rules[fid] = 'f';
          }
          this.$set(this.rules, i, rule);
          break;
        }
      },
    },
  }; //}}}1

  //create&init root object
  var app = new Vue({ //{{{1
    el: '#feature_acess_control_content',
    data: {
    },
    methods: {
    },
    components: {
      // 'alert': alertComp,
      'feature-access-control': featureAccessControlComp
    }
  }); //}}}1

});

// vim: foldmethod=marker
