<?php 
//vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');
include_once "base_controller.php";

class FeatureAccessController extends BaseController {

  protected function signinRequired() {
    return true;
  }

  // protected function adminRequired() {
  //   return true;
  // }
  protected function featureId() {
    return basename(__DIR__);
  }

  public function accessRules() {
    $model = new FeatureAccessControl();
    $access_list = array();
    foreach($model->rules(NULL) as $rule) {
      if ($rule['is_admin'] == 't')
        continue;
      if ($rule['user_name'] == 'Kiosk') {
        continue;
      }
      $access = array();
      $access['user_name'] = $rule['user_name'];
      $access['user_id'] = $rule['user_id'];
      $access['rule_id'] = $rule['rule_id'];
      $access['rules'] = $rule['rules'];
      $access_list[] = $access;
    }
    return $access_list;
  }

  protected function doAjaxPost() {
    $response = array();
    
    if (!isset($_POST['action'])) {
      $this->renderAjaxError($response, "missing parameter");
      return;
    }

    $action = $_POST['action'];
    if ($action == 'update_rules') {
      if (!isset($_POST['rules'])) {
        $this->renderAjaxError($response, "parameter 'rules' is required");
        return;
      }
      $rules = $_POST['rules'];
      $model = new FeatureAccessControl();
      $model->updateRules($rules);
    } else { 
      $this->renderAjaxError($response, "action '$action' is not supported");
      return;
    }

    $this->renderAjaxSuccess(array('resultCode' => 0));
  }
}

$controller = new FeatureAccessController();
$controller->run();

$features = collectFeatures();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title><?php $controller->echoPageTitle("Feature Access Control") ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <?php $controller->faviconHTMLInfo() ?>
  </head>
  <body>
    <div class="container" id="feature_acess_control_content">
      <div class="navbar">
        <div class="navbar-inner">
          <a id="home_nav_btn" class="brand" href="<?php echo $controller->utilityUrl() ?>"><?php echo $controller->utilityLabel() ?></a>
          <!-- <ul class="nav"> -->
          <!--   <li class="divider&#45;vertical"></li> -->
          <!--   <li v&#45;for="sec in sections" :class="{active:isSectionActive(sec)}"><a href="#" @click="active_sec_id=sec.sec_id">{{ sec.name }}</a></li> -->
          <!-- </ul> -->
        </div>
      </div>

      <div class="row">
        <div><h2 style="text-align:center">Feature Access Control Panel</h2></div>
        <feature-access-control></feature-access-control>
      </div>
    </div>

    <!-- component templates -->
    <script type="text/x-template" id="feature_access_control_template">
      <div class="span12">
        <table class="table table-striped table-hover">
          <thead>
            <tr>
              <th></th>
              <th v-for="rule in rules">{{ rule.user_name }}</th>
            </tr>
          </thead>
          <tbody>
            <tr v-for="name in features">
              <td>{{ feature_mapping[name].name }}</td>
              <td v-for="rule in rules">
                <label class="checkbox">
                  <input type="checkbox" true-value="t" false-value="f" v-model="rule.rules[name]" @change="onFeatureChanged(rule.user_name, name, rule.rules[name] == 't')"> <span class="label" :class="[rule.rules[name] == 't' ? 'label-info' : '',]" >{{ rule.rules[name] == 't' ? 'Enabled' : 'Disabled' }}</span>
                </label>
              </td>
            </tr>
          </tbody>
        </table>
        <div class="pull-right">
        <button class="btn btn-large btn-primary" type="button" @click="doSave">Save</button>
        </div>
      </div>
    </script>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/bootstrap.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/underscore-min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>

<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>
    <script type="text/javascript" src="<?php A('../../js/plugin-utils.js') ?>"></script>

    <script language="javascript" type="text/javascript">
      "use strict";
      window.feature_mapping = <?=json_encode($features) ?>; 
      window.access_rules = <?= json_encode($controller->accessRules()) ?>

      window.in_iframe = window !== window.parent;
      if (window.in_iframe) {
        let elem = document.getElementById("home_nav_btn");
        if(elem) elem.setAttribute("href", "#");
      }
    </script>

    <script type="text/javascript" src="<?php A('js/feature_access_control.js') ?>"></script>
  </body>
</html>
