<?php 
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');

include_once "base_controller.php";

class LogViewer extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function featureId() {
    return basename(__DIR__);
  }

  public function doAjaxGet() {
    $action = 'load_log';
    if (isset($_GET['action']))
      $action = $_GET['action'];

    $response = array();
    if ($action == 'load_log')
        $this->loadLog();
    else
      $this->renderAjaxError($response, "invalid action: " . $action);
  }

  protected function loadLog() {
    $response = array();
    $log_file_path = "/var/log/mqtt-service.log";
    if (file_exists($log_file_path))
      $response['log'] = file_get_contents($log_file_path);
    else
      $response['log'] = '';
    $this->renderAjaxSuccess2($response);
  }
}

$controller = new LogViewer();
$controller->run();

?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <title>Data Service Log Viewer</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="<?php A('../../css/bootstrap.min.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('../../css/common.css') ?>" media="screen" />
    <link rel="stylesheet" href="<?php A('css/data_service_config.css') ?>" media="screen" />
  </head>
  <body>
    <div class="container-fluid wide-page" id="log_viewer">
      <h3 class="text-center">Data Service Log Viewer</h3>
      <div class="row" style="margin-bottom: 10px">
        <div class="span4" style="margin-left:0">
          <label class="pull-left" style="padding-top:5px; padding-right:6px;">Filter:</label>
          <input type="text" v-model.trim="filterStr"> 
          <span class="help-inline" style="padding-bottom:10px;" >
            <a href="#" id="filter_help">?</a>
          </span>
        </div>

        <div class="span4" style="margin-left:0">
          <label class="pull-left" style="padding-top:5px; padding-right:6px;">Level:</label>
          <select class="pull-left" v-model="activeLogLevel">
            <option value="0">ALL</option>
            <option v-for="value in 6" :value="value">{{ reversedLogLevels[value].toUpperCase() }}</option>
          </select>
        </div>

        <div class="span2">
          <label class="checkbox pull-left" style="padding-top:5px; margin-left:20px;">
            <input type="checkbox" v-model="reversed"> Reversed
          </label>
        </div>

        <div class="span2" style="margin-left:40px;">
          <button class="btn btn-primary pull-right" v-on:click="refreshLog"><i class="icon-refresh"></i> Refresh</button>
        </div>
      </div>
      <div class="row">
        <pre>
<p v-for="log in logs" v-if="isLogLineVisible(log)" :class="logLineStyle(log)">    
{{ log }}
</p>
        </pre>
      </div>
    </div>

    <script type="text/javascript" src="<?php A('../../js/jquery-1.10.0.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/bootstrap.min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/underscore-min.js') ?>"></script>
    <script type="text/javascript" src="<?php A('../../js/spin.min.js') ?>"></script>
<?php
  if (isset($_GET["dev"])) {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.js') ?>"></script>
<?php
  } else {
?>
    <script type="text/javascript" src="<?php A('../../js/vue.min.js') ?>"></script>
<?php
  }
?>
    <script type="text/javascript" src="<?php A('js/log_viewer.js') ?>"></script>
  </body>
