<?php
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . '../../app');

include_once "db.php";
include_once "mqtt_service_base.php";

class CertFileManagerController extends MQTTServiceBase {
  private function certDir() {
    $curPath = dirname(__FILE__);
    $uploadDir = $curPath . DIRECTORY_SEPARATOR . "uploads";
    if (!is_dir($uploadDir))
      mkdir($uploadDir, 0777, true);

    $certDir = $uploadDir . DIRECTORY_SEPARATOR . "certs";
    if (!is_dir($certDir))
      mkdir($certDir, 0700, true);

    return $certDir;
  }
  
  protected function doAjaxGet() {
    $response = array();
    //GOTCHA: php on FW does not support glob with GLOB_BRACE option
    // $pattern = $this->certDir() . DIRECTORY_SEPARATOR . "*.{png,jpg,jpeg,gif}";
    $pattern = $this->certDir() . DIRECTORY_SEPARATOR . "*";
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    foreach(glob($pattern) as $filename)
    {
      $baseName = basename($filename);
      if (startsWith($baseName, "_"))
        continue;
      $response[] = '{"path": "' . $baseName . '", "size": ' . filesize($filename) . '}';
    }
    die('{"response": {"files": [' . implode(",", $response) . ']}}');
  }
  
  protected function doAjaxPost() {
    if (isset($_POST['action']) && $_POST['action'] == "delete")
      $this->deleteFile();
    else
      $this->uploadFile();
  }
  
  protected function uploadFile() {
    if (empty($_FILES)) {
      http_response_code(400);
      exit(L('No file specified'));
    }
    
    $response = array();
    $tempFile = $_FILES['file']['tmp_name'];
    $fileName = basename($_FILES['file']['name']);

    //check free disk space
    $freeSpace = disk_free_space($this->certDir());
    if (filesize($tempFile)+500*1024 > $freeSpace) {
      http_response_code(400);
      exit(L('No disk space specified'));
    }

    $targetFilePath = "";
    if (endsWith($fileName, '.tgz') && startsWith($fileName, 'mqtt-config'))
    {
      $curDir = dirname(__FILE__);
      $targetFilePath = $curDir . DIRECTORY_SEPARATOR . $fileName;
      move_uploaded_file($tempFile, $targetFilePath);
      $this->applyConfig($targetFilePath);
    }
    else
    { //accept cert file
      $targetFilePath = $this->certDir() . DIRECTORY_SEPARATOR . $fileName;
      move_uploaded_file($tempFile, $targetFilePath);
      $response['file_path'] = $targetFilePath;
    }

    die('{"response": ' . map2json($response) . '}');
  }

  protected function deleteFile() {
    $response = array();
    $name = $_POST['name'];
    $certDir = $this->certDir();
    $targetFilePath = realpath($certDir . DIRECTORY_SEPARATOR . $name);
    if (!startsWith($targetFilePath, $certDir))
      $this->renderAjaxError($response, L('invalid file name'));
    
    unlink($targetFilePath);
    $this->renderAjaxSuccess($response);
  }

  protected function applyConfig($configTarFilePath) {
    if (!file_exists($configTarFilePath))
      return;

    $curDir = dirname(__FILE__);
    $cmd = "gzip -c -d " . $configTarFilePath . " | tar -C {$curDir} -f - -x";
    if (!execShellCmd($cmd)) {
      error_log("failed to uncompress mqtt config file");
      unlink($configTarFilePath);
      return;
    }
    else
      unlink($configTarFilePath);

    $confPath = build_file_path($curDir, "data_mapping.json");
    $error = $this->restartService($confPath);
    if (!is_null($error))
      error_log($error);
  }
}

$controller = new CertFileManagerController();
$controller->run();

?>
