"use strict";
// vim: ts=2 sw=2
$(function() {
  Dropzone.autoDiscover = false;

  window.fileSelectorComp = { // {{{1
    template: '#file_selector_template',
    props: ['server_url'],
    data: function() {
      return {
        url: this.server_url,
        title: "Choose File",
        previewMsg: "Loading Files ...",
        dzElem: null,
        onFileRemovedCallback: null,
        callback: null,
        userdata: null,
      };
    },
    mounted: function() {
      this.dzElem = $(this.$el).find("#file_upload_panel");
      this.dzElem.dropzone({
        url: this.url,
        paramName: 'file',
        previewTemplate: document.querySelector("#file_preview_template").innerHTML,
        previewsContainer: ".dropzone-previews .files",
        maxFileSize: 1,
        clickable: true,
        createImageThumbnails: false,
        // accept: _.bind(this.acceptFile, this),
        // refs: http://pki-tutorial.readthedocs.io/en/latest/mime.html
        acceptedFiles: '.crt,.pem,.key,.cer,.der',
      });

      var dz = Dropzone.forElement(this.dzElem.get(0));
      dz.on('addedfile', _.bind(this.onFileAdded, this));
      this.onFileRemovedCallback = _.bind(this.onFileRemoved, this);
      dz.on('removedfile', this.onFileRemovedCallback);

      var lazyBind = _.debounce(_.bind(this.bindClickEvent, this), 300);
      dz.on("complete", lazyBind);
    },

    methods: {
      setPreviewMsg: function(msg) {
        $(this.$el).find(".dropzone-previews .dz-message").text(msg);
      },

      getDropzone: function() {
        return Dropzone.forElement(this.dzElem.get(0));
      },

      acceptFile: function(file, done) {
        var previewElems = this.dzElem.find(".dz-complete.dz-preview:not(.dz-error)");
        var found = false;
        previewElems.find(".dz-filename span").each(function(index) {
          found = found || $(this).text() == file.name;
        });
        
        if (found)
          done(file.name + " already exists.");
        else
          done();
      },

      bindClickEvent: function() {
        var dzPanel = $(this.$el).find("#file_upload_panel");
        dzPanel.find(".dz-image-preview").off("click").on("click", function(e) {
          if ($(this).hasClass("dz-error")) return;
          dzPanel.find(".dz-image-preview").removeClass("dz-image-selected");
          $(this).addClass("dz-image-selected");
        });
      },

      onFileAdded: function(file) {
        var dz = this.getDropzone();
        dz.emit("thumbnail", file, "img/cert.png");
      },

      onFileRemoved: function(file) {
        if (file.status && file.status == "error")
          return;

        $.ajax({
          method: "POST",
          url: this.url, 
          data: {action: 'delete', 'name': file.name},
          dataType: "json",
          success: function(data) {
            if (data.redirect)
              redirect(data.redirect);
          },
        });
      },

      getFilePath: function() {
        var selectedImg = this.dzElem.find(".dropzone-previews .dz-image-selected");
        var filename = selectedImg.find("[data-dz-name]").text();

        if (selectedImg.hasClass("dz-error") || !filename) {
          return null;
        } else {
          return filename;
        }
      },

      doModal: function(title, userdata, callback) {
        var self = this;

        this.callback = callback;
        this.userdata = userdata;

        //remove old data
        var dz = this.getDropzone();
        if (dz) {
          dz.off('removedfile', this.onFileRemovedCallback);
          dz.removeAllFiles(true);
          dz.on('removedfile', this.onFileRemovedCallback);
        }
        this.dzElem.find(".file-row").remove();

        this.title = title || "Choose File";
        $(this.$el).modal({
          keyboard: false
        });

        $.ajax({
          url: this.url,
          method: "GET",
          dataType: "json", 
          beforeSend: function() {
            self.setPreviewMsg("Loading files ...");
          },
        }).done(function(data) {
          if (data.redirect)
            redirect(data.redirect);

          if (!data.response || !data.response.files || data.response.files.constructor !== Array)
          {
            self.setPreviewMsg("Can not fetch certificate file list");
            return;
          }

          var index = 0;
          var files = data.response.files;
          for(index=0; index < files.length; ++index) {
            var fileData = files[index];
            var path = fileData.path;
            var size = fileData.size;
            if (!path)
              continue;

            var mockFile = {name: path.split("/").pop(), size: size};
            dz.emit("addedfile", mockFile);
            // dz.emit("thumbnail", mockFile, "img/cert.png");
            // dz.createThumbnailFromUrl(mockFile, "", self.lazyBind);
            dz.emit("complete", mockFile);
            if (mockFile.previewElement)
              mockFile.previewElement.classList.add("dz-success");
          }

          //preselect current selected file
          self.dzElem.find(".dropzone-previews .file-row").filter(function() {
            return $(this).find('[data-dz-name]').text() === self.userdata;
          }).addClass("dz-image-selected");

          self.setPreviewMsg("Select From Uploaded Files:");
        }).fail(function() {
          self.setPreviewMsg("No Cert File Available.");
        });
      },

      saveFilePath: function() {
        var filename = this.getFilePath();
        if (this.callback)
          if (filename)
            this.callback(filename);
          else {
            alert("Selected file is invalid.");
            return;
          }

        $(this.$el).modal('hide');
      },

    },
  }; // }}}1
});
