"use strict";
// vim: ts=2 sw=2
$(function() {

  window.msgbus = new Vue();

  window.alertComp = {
    template: '#alert-template',
    data: function() {
      return {
        title: 'Success',
        msg: '',
        level: 'success',
        show: false,
      };
    },
    mounted: function() {
      var self = this;
      msgbus.$on('alert', _.bind(this.display, this));
      msgbus.$on('alert:clear', function() { self.show = false; });
    },
    methods: {
      display: function(title, msg, level, delay_time) {
        if (title)
          this.title = title;
        if (msg)
          this.msg = msg;
        if (level)
          this.level = level;

        if (_.isNull(delay_time) || _.isUndefined(delay_time))
          delay_time = 5000;

        this.show = true;
        var self = this;
        if (delay_time > 0)
          _.delay(function() { self.show = false; }, delay_time);
      },
    },
    computed: {
      label_class: function() {
        return "alert-" + this.level;
      },
    },
  };

});

