"use strict";
// Generated by CoffeeScript 1.6.2
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  jQuery(function() {
    var L, SigninView, _ref;

    L = function(str) {
      return l18n(str, "js/signin.js");
    };
    SigninView = (function(_super) {
      __extends(SigninView, _super);

      function SigninView() {
        _ref = SigninView.__super__.constructor.apply(this, arguments);
        return _ref;
      }

      SigninView.prototype.el = '#signinForm';

      SigninView.prototype.events = {
        "click #signinBtn": "login"
      };

      SigninView.prototype.initialize = function() {
        this.template = _.template($('#signinFormContent').html());
        return this.render();
      };

      SigninView.prototype.render = function() {
        this.$el.html(this.template());
        $('#show-password').off("click").on('click', function() {
          var passwordField = $('#password');
          var fieldType = passwordField.attr('type');
          if (fieldType === 'password') {
            passwordField.attr('type', 'text');
            $(this).children().removeClass('icon-eye-open').addClass('icon-eye-close');
          } else {
            passwordField.attr('type', 'password');
            $(this).children().removeClass('icon-eye-close').addClass('icon-eye-open');
          }
        });
        return this;
      };

      SigninView.prototype.userName = function() {
        return this.$el.find('#username').val();
      };

      SigninView.prototype.password = function() {
        return this.$el.find('#password').val();
      };

      SigninView.prototype.validate = function() {
        var password, username;

        username = this.userName();
        if (_.str.isBlank(username)) {
          $('.alert').addClass('alert-error').text(L("user name is invalid")).show();
          return false;
        }
        password = this.password();
        if (_.str.isBlank(password)) {
          $('.alert').addClass('alert-error').text(L("password is invalid")).show();
          return false;
        }
        return true;
      };

      SigninView.prototype.fetchAuthenToken = function(url) {
        return $.ajax({
          url: url,
          type: 'GET',
          dataType: 'json',
          data: {
            'user[name]': this.userName()
          },
          success: function(data) {
            if (!data) {
              return $('.alert').addClass('alert-error').text(L("Failed to signin")).show();
            }
            if (data.error) {
              return $('.alert').addClass('alert-error').text(data.error.text).show();
            }
            if (!data.authToken || data.authToken.length == 0) {
              return $('.alert').addClass('alert-error').text(L("Failed to signin")).show();
            }
          },
          error: function(jqXHR, status, error) {
            return $('.alert').addClass('alert-error').text(L("Failed to signin")).show();
          }
        });
      };

      SigninView.prototype.login = function(e) {
        var formValues, url,
          _this = this;

        e.preventDefault();
        $('.alert').hide();
        if (!this.validate()) {
          return;
        }
        url = "signin.php";
        console.info("Signing in ...");
        formValues = {
          'user[name]': this.userName()
        };
        return this.fetchAuthenToken(url).done(function(data) {
          var authToken, shaObj1, shaObj2, token1, token2, _ref1;

          if (!data || data.error) {
            return;
          }
          authToken = data.authToken;
          if (!authToken || authToken.length == 0) {
            return;
          }
          _ref1 = _.str.words(authToken, '_'), token1 = _ref1[0], token2 = _ref1[1];
          shaObj1 = new jsSHA("SHA-256", 'TEXT');
          shaObj1.update(_this.password() + token1);
          shaObj2 = new jsSHA("SHA-256", 'TEXT');
          shaObj2.update(shaObj1.getHash('HEX') + token2);
          formValues['user[authHash]'] = shaObj2.getHash('HEX');
          formValues['remember_me'] = _this.$el.find('input[name="remember_me"]').is(':checked');
          return $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: formValues,
            success: function(data) {
              if (data.error) {
                return $('.alert').addClass('alert-error').text(data.error.text).show();
              } else {
                console.info("sign in successfully");
                return window.location.href = data.redirectUrl;
              }
            },
            error: function(jqXHR, status, error) {
              return $('.alert').addClass('alert-error').text(L("Failed to signin")).show();
            }
          });
        });
      };

      return SigninView;

    })(Backbone.View);
    window.signinView = new SigninView;
    return $("#languages > select").change(function() {
      var newLang;

      newLang = $("#languages > select").val();
      return window.location.href = "?lang=" + newLang;
    });
  });

}).call(this);
