"use strict";
(function() {
  
  var UserLibClass = function() 
  {
    this.requiredScripts = function() {   
      // *Note*, you need to put the javascript files under CPT/grweb/public/user_codes folder
      //         manually, otherwise these files cannot be deployed to device
      //return ["../user_codes/highcharts/js/highcharts.js",
      //        "../user_codes/highcharts/js/highcharts-more.js",
      //        "../user_codes/highcharts/js/exporting.js"];
    };
    
    this.init = function() { 
      this.setupUI(); 
    };
    
    this.loadSettings = function() {
      this.onImage = this.readData("@OnImage");
      this.offImage = this.readData("@OffImage");
      this.onTextColor = this.readData("@OnTextColor");
      this.offTextColor = this.readData("@OffTextColor");
    }
    
    this.setupUI = function() {
      var e = $(this.elem);
      this.loadSettings();
    
      if (!_.str.isBlank(this.onImage) && !_.str.isBlank(this.offImage))
        e.append("<div><img class='bool-image' style='display:block; margin-left:auto; margin-right:auto;' src='"+this.onImage+"'><div>");
    
      var onText = this.readData("@OnText");
      var offText = this.readData("@OffText");
      if (!_.str.isBlank(onText) && !_.str.isBlank(offText))
        e.append("<div><p class='bool-text' style='text-align:center;'>"+onText+"</p></div>");
        
      this.updateUI(this.readData("@data"));
      
      $(this.elem).on("settingsChanged", _.bind(this.loadSettings, this));
    }
    
    this.updateUI = function(dataVal) {
      var e = $(this.elem);
      var isOn = _.str.toBoolean(dataVal);
      e.find(".bool-image").attr("src", isOn ? this.onImage : this.offImage);
      var color = isOn ? this.onTextColor : this.offTextColor;
      var onText = this.readData("@OnText");
      var offText = this.readData("@OffText");
      e.find(".bool-text").text(isOn ? onText : offText)
      .css("color", this.handleColorData(color))
    }
    // [required] when user property changed, this callback method will be called
    // it is a good place to update widget with new data, you can read user property's value by:
    // this.readData("@UserPropertyName")
    this.update = function(userPropertyName) {
      if (userPropertyName != "@data")
        return;
        
      var dataVal = this.readData("@data");
      this.updateUI(dataVal);
    };
    
    this.cleanup = function() {
    };
                  
        
  };

  var userLib = new UserLibClass();
  var external_scripts = _.has(userLib, 'requiredScripts') ? userLib.requiredScripts() : [];
  if (external_scripts == null)
    external_scripts = [];
  external_scripts.push("../js/underscore.string.min.js");

  //TODO: generate settings from user_lib
  freeboard.loadWidgetPlugin({
    'external_scripts': external_scripts,
    'fill_size': false,
    'type_name': 'CPT_Label_BoolLabel_Widget',
    'display_name': 'BoolLabel',
    'description': 'BoolLabel Widget converted from CPT Graphics'    ,
    'settings': [
      {
        'name': '@OffImage',
        'display_name': '@OffImage',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@OffText',
        'display_name': '@OffText',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@OffTextColor',
        'display_name': '@OffTextColor',
        'type': 'text',
        'default_value': '',
        'editor': 'color'
      },
      {
        'name': '@OnImage',
        'display_name': '@OnImage',
        'type': 'text',
        'default_value': '',
        'editor': 'image'
      },
      {
        'name': '@OnText',
        'display_name': '@OnText',
        'type': 'calculated',
        'default_value': '',
        'editor': ''
      },
      {
        'name': '@OnTextColor',
        'display_name': '@OnTextColor',
        'type': 'text',
        'default_value': '',
        'editor': 'color'
      },
      {
        'name': '@data',
        'display_name': '@data',
        'type': 'calculated',
        'default_value': '',
        'editor': '',
        'description': 'path of boolean slot'
      },
      {
        'name': 'rows',
        'display_name': 'Rows',
        'type': 'option',
        'default_value': '2',
        'options': [{'name': '1 row', 'value': 1}, {'name': '2 rows', 'value': 2}, {'name': '3 rows', 'value': 3}, {'name': '4 rows', 'value': 4}, {'name': '5 rows', 'value': 5}, {'name': '6 rows', 'value': 6}, {'name': '7 rows', 'value': 7}, {'name': '8 rows', 'value': 8}]
      }      
    ], 
    newInstance: function(settings, newInstanceCallback)
    {
      var wa = new WidgetAdapter(settings);
      wa = _.extend(wa, new UserLibClass());
      newInstanceCallback(wa);
    }
  });

})();
