<?php 

function buildJsAssetManifest($patterns) {
  $content = array();
  foreach($patterns as $pat) {
    foreach(glob($pat) as $filepath) {
      if (!file_exists($filepath))
        continue;
      $stat = stat($filepath);
      if (!$stat)
        continue;

      $content[$filepath] = array();
      $content[$filepath]['size'] = $stat['size'];
      $content[$filepath]['mtime'] = $stat['mtime'];
    }
  }
  return $content;
}

function getAssetManifest() {
  $filepath = "./js_assets.json";
  if (file_exists($filepath)) {
    return json_decode(file_get_contents($filepath));
  } else {
    $content = buildJsAssetManifest(array(
      "../user_codes/*/*.js", 
      "../user_codes/*/*/*.js", 
      "../user_codes/*/*.css", 
      "../js/*.js", 
      "../css/*.css")
    );
    file_put_contents($filepath, json_encode($content));
    return $content;
  }
}
