"use strict";
// Generated by CoffeeScript 1.6.2
(function () {
  var AccountViewModel,
    BackupViewModel,
    DashboardManager,
    JsTreeModel,
    L,
    PermEntry,
    PermissionViewModel,
    RestoreViewModel,
    SidebarControl,
    UploadViewModel,
    ajaxCompleteHandler,
    closeFreeboardDialog,
    h4,
    isDashboardModified,
    updateQueryString,
    validatePassword,
    __bind = function (fn, me) {
      return function () {
        return fn.apply(me, arguments);
      };
    };

  ajaxCompleteHandler = function (event, xhr, settings) {
    var err, obj, _ref, _ref1;

    if (
      !settings.dataType ||
      settings.dataType.toLowerCase() !== 'json' ||
      !xhr.responseText ||
      xhr.responseText.length === 0 ||
      settings.crossDomain
    ) {
      return;
    }
    obj = null;
    try {
      obj = JSON.parse(xhr.responseText);
    } catch (_error) {
      err = _error;
      console.error('can not parse json request: ' + err.message);
      return;
    }
    if (obj.redirect) {
      if (/signin\.php$/.test(obj.redirect)) {
        window.location.href =
          obj.redirect + '?success_url=' + window.location.href;
        return;
      }
    }
    if (
      /data_api\.php/.test(settings.url) &&
      ((_ref = obj.response) != null
        ? (_ref1 = _ref.errorMsg) != null
          ? _ref1.length
          : void 0
        : void 0) > 0
    ) {
      return iziToast.warning({
        title: 'Data Update Error',
        message: obj.response.errorMsg,
      });
    }
  };

  L = function (str) {
    return l18n(str, 'dashboard/js/page.js');
  };

  updateQueryString = function (key, value, url) {
    var anchor, hash, re, separator;

    if (!url) {
      url = window.location.href;
    }
    re = new RegExp('([?&])' + key + '=.*?(&|#|$)(.*)', 'gi');
    if (re.test(url)) {
      if (value != null) {
        return url.replace(re, '$1' + key + '=' + value + '$2$3');
      } else {
        hash = url.split('#');
        url = hash[0].replace(re, '$1$3').replace(/(&|\?)$/, '');
        anchor = hash[1];
        if (anchor != null) {
          url += '#' + hash[1];
        }
        return url;
      }
    } else {
      if (value != null) {
        separator = url.indexOf('?') !== -1 ? '&' : '?';
        hash = url.split('#');
        url = hash[0] + separator + key + '=' + value;
        anchor = hash[1];
        if (anchor != null) {
          url += '#' + hash[1];
        }
        return url;
      } else {
        return url;
      }
    }
  };

  closeFreeboardDialog = function () {
    return $('#modal_overlay').fadeOut(200, function () {
      return $(this).remove();
    });
  };

  isDashboardModified = function () {
    var dashboardData, elem, newContent, oldContent;

    elem = document.getElementById('contentJson');
    if ((elem != null ? elem.innerHTML : void 0) == null) {
      return true;
    }
    oldContent = $.trim(elem.innerHTML);
    dashboardData = freeboard.serialize();
    newContent = JSON.stringify(dashboardData);
    return oldContent !== newContent;
  };

  h4 = function (msg) {
    return '<h4>' + msg + '</h4>';
  };

  validatePassword = function (input, name, minLength) {
    var maxLength;

    if (name == null) {
      name = 'input';
    }
    if (minLength == null) {
      minLength = 12;
    }
    if (input.length < minLength) {
      return L('{name} should be longer than {minLength} characters').supplant({
        name: name,
        minLength: minLength,
      });
    }
    maxLength = 32;
    if (input.length >= maxLength) {
      return L('{name} should be shorter than {maxLength} characters').supplant(
        {
          name: name,
          maxLength: maxLength,
        }
      );
    }
    if (!/[a-z]/.test(input)) {
      return L('{name} must include lowercase characters').supplant({
        name: name,
      });
    }
    if (!/[A-Z]/.test(input)) {
      return L('{name} must include uppercase characters').supplant({
        name: name,
      });
    }
    if (!/[0-9]/.test(input)) {
      return L('{name} must include number characters').supplant({
        name: name,
      });
    }
    if (!/[!-.:-@^-`{-~]/.test(input)) {
      return L('{name} must include punctuation characters').supplant({
        name: name,
      });
    }
  };

  JsTreeModel = (function () {
    function JsTreeModel(isActive) {
      this.deleteNode = __bind(this.deleteNode, this);
      this.renameNode = __bind(this.renameNode, this);
      this.onNodeRenamed = __bind(this.onNodeRenamed, this);
      this.onDndStop = __bind(this.onDndStop, this);
      this.isTopNode = __bind(this.isTopNode, this);
      this.isActive = isActive;
    }

    JsTreeModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    JsTreeModel.prototype.create = function (dashboardList) {
      var dashboard,
        jstree_conf,
        nodes,
        _i,
        _len,
        _this = this;

      nodes = [];
      for (_i = 0, _len = dashboardList.length; _i < _len; _i++) {
        dashboard = dashboardList[_i];
        nodes.push(this.createNode(dashboard));
      }
      $(document).on('dnd_stop.vakata', this.onDndStop);
      jstree_conf = {
        core: {
          multiple: false,
          themes: {
            dots: false,
            responsive: false,
          },
          check_callback: function (
            operation,
            node,
            node_parent,
            node_position,
            more
          ) {
            return node_parent !== '#';
          },
          data: nodes,
        },
        plugins: ['unique'],
      };
      if (window.perms.canManageWidget) {
        jstree_conf.plugins.push('dnd');
        jstree_conf.plugins.push('contextmenu');
        jstree_conf.contextmenu = {
          select_node: false,
          items: function (node, callback) {
            var obj;

            obj = {
              rename: {
                label: _this.L('Rename'),
                action: _this.renameNode,
              },
              delete: {
                label: _this.L('Delete'),
                action: _this.deleteNode,
              },
            };
            if (node.parent !== '#') {
              return obj;
            }
          },
        };
      }
      return $('#jstree').jstree(jstree_conf);
    };

    JsTreeModel.prototype.isTopNode = function (parent_id) {
      return _.isEmpty(parent_id) || parent_id === '0' || parent_id === '#';
    };

    JsTreeModel.prototype.createNode = function (board) {
      var child, icon;

      icon =
        (this.isTopNode(board.parent_id) && 'jstree-folder') || 'jstree-file';
      return (child = {
        id: board.id,
        parent: (this.isTopNode(board.parent_id) && '#') || board.parent_id,
        text: board.name,
        icon: icon,
        state: {
          selected: this.isActive(board.id),
          opened: this.isTopNode(board.parent_id),
        },
      });
    };

    JsTreeModel.prototype.boardName = function (id) {
      var inst, _ref;

      inst = $('#jstree').jstree(true);
      return inst != null
        ? (_ref = inst.get_node(id)) != null
          ? _ref.text
          : void 0
        : void 0;
    };

    JsTreeModel.prototype.layoutData = function (id) {
      var children, data, inst, node, parent;

      inst = $('#jstree').jstree(true);
      node = inst.get_node(id);
      parent = inst.get_node(node.parent);
      children = parent.children;
      return (data = {
        id: id,
        parent_id: parent.id,
        sibling_ids: children.join(','),
      });
    };

    JsTreeModel.prototype.onDndStop = function (event, data) {
      var layout_data, _ref, _ref1;

      if (
        !(
          (data != null
            ? (_ref = data.data) != null
              ? (_ref1 = _ref.nodes) != null
                ? _ref1.length
                : void 0
              : void 0
            : void 0) > 0
        )
      ) {
        return;
      }
      layout_data = this.layoutData(data.data.nodes[0]);
      layout_data['action'] = 'layout';
      return $.ajax({
        url: 'index.php',
        method: 'POST',
        dataType: 'json',
        data: layout_data,
      });
    };

    JsTreeModel.prototype.onNodeRenamed = function (
      node,
      status,
      cancelled,
      old_text
    ) {
      var inst,
        _this = this;

      if (!(status && !cancelled)) {
        return;
      }
      if (!/^[-_a-zA-Z0-9]{1,64}$/.test(node.text)) {
        inst = $.jstree.reference('#jstree');
        inst.set_text(node, old_text);
        return;
      }
      return $.ajax({
        url: 'index.php',
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'rename',
          id: node.id,
          new_name: node.text,
        },
        success: function (data) {
          inst = $.jstree.reference('#jstree');
          if (data.error != null) {
            return console.warn(
              'failed to rename node: ' + old_text + ' to ' + node.text
            );
          } else {
            return (window.curDashboardId = node.id);
          }
        },
      });
    };

    JsTreeModel.prototype.renameNode = function (node) {
      var inst,
        obj,
        old_text,
        _this = this;

      inst = $.jstree.reference(node.reference);
      obj = inst.get_node(node.reference);
      old_text = obj.text;
      return inst.edit(obj, obj.text, function (node, status, cancelled) {
        return _this.onNodeRenamed(node, status, cancelled, old_text);
      });
    };

    JsTreeModel.prototype.doDeleteNode = function (node) {
      var id_list,
        inst,
        obj,
        _this = this;

      inst = $.jstree.reference(node.reference);
      obj = inst.get_node(node.reference);
      id_list = [obj.id];
      inst.delete_node(obj);
      return $.ajax({
        url: 'index.php',
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'delete',
          id_list: id_list.join(','),
        },
        success: function (data) {
          var topNode;

          if (data.error != null) {
            return console.warn('failed to delete node');
          } else {
            inst = $.jstree.reference('#jstree');
            topNode = inst.get_node('1');
            if (topNode.children != null && topNode.children.length > 0) {
              return inst.activate_node(topNode.children[0]);
            } else {
              return $('#jstree').trigger('AllNodeRemoved');
            }
          }
        },
      });
    };

    JsTreeModel.prototype.deleteNode = function (node) {
      var inst,
        obj,
        _this = this;

      inst = $.jstree.reference(node.reference);
      obj = inst.get_node(node.reference);
      return freeboard.showDialog(
        this.L("<h4>Are you sure to delete dashboard '") +
        obj.text +
        "' ?</h4>",
        this.L('Confirm to delete'),
        this.L('Yes'),
        this.L('No'),
        function () {
          return _this.doDeleteNode(node);
        }
      );
    };

    JsTreeModel.prototype.addNode = function (board) {
      var jstree, node, root;

      if (board == null) {
        return;
      }
      jstree = $('#jstree').jstree(true);
      node = jstree.get_node(board.id);
      if (node) {
        return;
      }
      root = jstree.get_node('1');
      node = jstree.create_node(root, this.createNode(board));
      jstree.deselect_all();
      return jstree.select_node(node);
    };

    JsTreeModel.prototype.checkUniqueness = function (name) {
      var child, inst, root, _i, _len, _ref;

      inst = $('#jstree').jstree(true);
      root = inst.get_node('1');
      if (root.children == null || root.children.length <= 0) {
        return true;
      }
      _ref = root.children;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        child = _ref[_i];
        if (inst.get_node(child).text === name) {
          return false;
        }
      }
      return true;
    };

    return JsTreeModel;
  })();

  DashboardManager = (function () {
    function DashboardManager() {
      this.onAllNodeRemoved = __bind(this.onAllNodeRemoved, this);
      this.newDashboard = __bind(this.newDashboard, this);
      this.onDashboardsLoaded = __bind(this.onDashboardsLoaded, this);
      var _this = this;

      this.prevDataSources = null;
      this.jsTreeModel = new JsTreeModel(function (id) {
        return id === window.curDashboardId;
      });
      $('#jstree').on('AllNodeRemoved', this.onAllNodeRemoved);
      this.nameViewModel = {
        name: ko.observable('default'),
        error_msg: ko.observable(''),
      };
      this.render();
    }

    DashboardManager.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    DashboardManager.prototype.render = function () {
      var content,
        elem,
        jsonContent,
        redirect_url,
        _this = this;

      elem = document.getElementById('contentJson');
      if ((elem != null ? elem.innerHTML : void 0) != null) {
        content = $.trim(elem.innerHTML);
        if (content.length === 0) {
          redirect_url = window.location.origin + window.location.pathname;
          if (redirect_url !== window.location.href) {
            return (window.location.href = redirect_url);
          } else {
            return this.newDashboard(false);
          }
        } else {
          jsonContent = JSON.parse(content);
          return freeboard.loadDashboard(jsonContent, function () {
            return freeboard.setEditing(false);
          });
        }
      } else {
        return this.newDashboard();
      }
    };

    DashboardManager.prototype.loadDashboard = function (id) {
      if (id == null) {
        return;
      }
      return (window.location.href = updateQueryString('dashboard_id', id));
    };

    DashboardManager.prototype.onDashboardsLoaded = function (data) {
      var _this = this;

      if (data.response != null && data.response.length > 0) {
        $('#jstree').on('activate_node.jstree', function (e, data) {
          var instance, node, _ref;

          node = data != null ? data.node : void 0;
          instance = data != null ? data.instance : void 0;
          if ((node != null ? node.parent : void 0) === '#') {
            instance.toggle_node(node);
            if (instance != null) {
              instance.deselect_node(
                data != null
                  ? (_ref = data.node) != null
                    ? _ref.id
                    : void 0
                  : void 0,
                true
              );
            }
            return instance != null
              ? instance.select_node(window.curDashboardId, true)
              : void 0;
          } else {
            return _this.loadDashboard(node != null ? node.id : void 0);
          }
        });
        return this.jsTreeModel.create(data.response);
      } else {
        return freeboard.setEditing(true);
      }
    };

    DashboardManager.prototype.loadDashboards = function () {
      return $.ajax({
        dataType: 'json',
        url: 'index.php',
        data: {
          action: 'list',
        },
        beforeSend: function () {
          return freeboard.showLoadingIndicator(true);
        },
        success: this.onDashboardsLoaded,
        complete: function () {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    DashboardManager.prototype.newDashboard = function (cancelBtn) {
      var cancelText,
        dom,
        _this = this;

      if (cancelBtn == null) {
        cancelBtn = true;
      }
      if (!window.perms.canManageWidget) {
        console.warn('can not create dashboard: permission denied');
        return;
      }
      dom = $($('#name_dialog_tpl').html());
      ko.applyBindings(this.nameViewModel, dom[0]);
      cancelText = cancelBtn ? this.L('Cancel') : null;
      return freeboard.showDialog(
        dom,
        this.L('New Dashboard Name'),
        this.L('Save'),
        cancelText,
        function () {
          var name;

          name = _this.nameViewModel.name();
          if (!/[-_a-zA-Z0-9.]+/.test(name)) {
            _this.nameViewModel.error_msg(
              _this.L(
                'invalid dashboard name. (valid characters: alpha, number, _ and -)'
              )
            );
            return true;
          } else if (!_this.jsTreeModel.checkUniqueness(name)) {
            _this.nameViewModel.error_msg(
              _this.L("dashboard's name alreay exists")
            );
            return true;
          } else {
            if (window.curDashboardId) {
              _this.prevDataSources = freeboard.serialize().datasources;
            }
            freeboard.newDashboard();
            _this.doSaveDashboard(null, name);
            freeboard.setEditing(false);
            return false;
          }
        }
      );
    };

    DashboardManager.prototype.doSaveDashboard = function (id, name) {
      var content,
        dashboardData,
        data,
        _this = this;

      console.info('save dashboard: ' + name);
      dashboardData = freeboard.serialize();
      if (this.prevDataSources) {
        dashboardData.datasources = this.prevDataSources;
      }
      this.prevDataSources = null;
      content = JSON.stringify(dashboardData);
      data = {
        action: 'save',
        name: name,
        content: content,
      };
      if (id != null) {
        data.id = id;
      }
      return $.ajax('index.php', {
        data: data,
        dataType: 'json',
        method: 'POST',
        beforeSend: function () {
          return freeboard.showLoadingIndicator(true);
        },
        success: function (data) {
          var elem;

          if (data.redirect != null) {
            return (window.location.href = data.redirect);
          } else {
            if (data.error != null) {
              return console.warn('can not save dashboard');
            } else {
              console.info('dashbaord saved');
              freeboard.setEditing(false);
              elem = document.getElementById('contentJson');
              if ((elem != null ? elem.innerHTML : void 0) != null) {
                return (elem.innerHTML = content);
              }
            }
          }
        },
        complete: function () {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    DashboardManager.prototype.saveDashboard = function () {
      if (window.curDashboardId) {
        return this.doSaveDashboard(
          window.curDashboardId,
          this.jsTreeModel.boardName(window.curDashboardId)
        );
      } else {
        return this.saveDashboardAs();
      }
    };

    DashboardManager.prototype.saveDashboardAs = function () {
      var dom,
        _this = this;

      dom = $($('#name_dialog_tpl').html());
      ko.applyBindings(this.nameViewModel, dom[0]);
      return freeboard.showDialog(
        dom,
        this.L('Dashboard Name'),
        this.L('Save'),
        this.L('Cancel'),
        function () {
          var name;

          name = _this.nameViewModel.name();
          if (!/[-_a-zA-Z0-9.]+/.test(name)) {
            _this.nameViewModel.error_msg(
              _this.L(
                'invalid dashboard name. (valid characters: alpha, number, _ and -)'
              )
            );
            return true;
          } else if (!_this.jsTreeModel.checkUniqueness(name)) {
            _this.nameViewModel.error_msg(
              _this.L("dashboard's name alreay exists")
            );
            return true;
          } else {
            _this.doSaveDashboard(null, name);
            freeboard.setEditing(false);
            return false;
          }
        }
      );
    };

    DashboardManager.prototype.onAllNodeRemoved = function () {
      return this.newDashboard(false);
    };

    return DashboardManager;
  })();

  SidebarControl = (function () {
    function SidebarControl() {
      this.enableTouch = __bind(this.enableTouch, this);
      this.unhighlight = __bind(this.unhighlight, this);
      this.highlight = __bind(this.highlight, this);
      var _this = this;

      this.el = $('#sidebar_toggle_btn');
      this.el.mouseenter(this.highlight);
      this.el.mouseleave(this.unhighlight);
      this.slideout = new Slideout({
        panel: document.getElementById('dashboard_panel'),
        menu: document.getElementById('sidebar'),
        padding: 200,
      });
      this.el.click(function () {
        return _this.slideout.toggle();
      });
      this.slideout.on('open', function () {
        return _this.el.text('-');
      });
      this.slideout.on('close', function () {
        return _this.el.text('+');
      });
    }

    SidebarControl.prototype.highlight = function () {
      return this.el.css({
        color: '#B88F51',
        'border-color': '#B88F51',
        cursor: 'pointer',
      });
    };

    SidebarControl.prototype.unhighlight = function () {
      return this.el.css({
        color: 'rgba(128,128,128,0.3)',
        'border-color': 'rgba(128,128,128,0.3)',
        cursor: 'auto',
      });
    };

    SidebarControl.prototype.enableTouch = function (enable) {
      if (enable) {
        return this.slideout.enableTouch();
      } else {
        return this.slideout.disableTouch();
      }
    };

    return SidebarControl;
  })();

  PermEntry = (function () {
    function PermEntry(
      userName,
      dashboardId,
      pageName,
      canManageDataSource,
      canManageWidget,
      canViewDashboard,
      canWriteDataSource
    ) {
      this.userName = userName;
      this.dashboardId = dashboardId;
      this.pageName = pageName;
      this.canManageDataSource = ko.observable(canManageDataSource === 't');
      this.canWriteDataSource = ko.observable(canWriteDataSource === 't');
      this.canManageWidget = ko.observable(canManageWidget === 't');
      this.canViewDashboard = ko.observable(canViewDashboard === 't');
    }

    PermEntry.prototype.postData = function () {
      return {
        userName: this.userName,
        dashboardId: this.dashboardId,
        canManageDataSource: this.canManageDataSource() ? 't' : 'f',
        canWriteDataSource: this.canWriteDataSource() ? 't' : 'f',
        canManageWidget: this.canManageWidget() ? 't' : 'f',
        canViewDashboard: this.canViewDashboard() ? 't' : 'f',
      };
    };

    return PermEntry;
  })();

  PermissionViewModel = (function () {
    function PermissionViewModel() {
      this.savePerm = __bind(this.savePerm, this);
      this.showPermUI = __bind(this.showPermUI, this);
      var btnElem;

      btnElem = $('#permission_control_btn');
      btnElem.click(this.showPermUI);
      this.viewModel = null;
    }

    PermissionViewModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    PermissionViewModel.prototype.renderPermData = function (resp) {
      var dom,
        entry,
        found,
        modelEntry,
        permEntry,
        prevUserName,
        u,
        _i,
        _j,
        _len,
        _len1,
        _ref,
        _ref1;

      if (resp == null) {
        return;
      }
      if (
        ((_ref = this.viewModel) != null ? _ref.selectedUser : void 0) != null
      ) {
        prevUserName = this.viewModel.selectedUser().userName;
      }
      this.viewModel = {
        selectedUser: ko.observable(),
        users: [],
        error_msg: ko.observable(''),
      };
      for (_i = 0, _len = resp.length; _i < _len; _i++) {
        entry = resp[_i];
        found = false;
        permEntry = new PermEntry(
          entry.userName,
          entry.dashboardId,
          entry.pageName,
          entry.canManageDataSource,
          entry.canManageWidget,
          entry.canViewDashboard,
          entry.canWriteDataSource
        );
        _ref1 = this.viewModel.users;
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          u = _ref1[_j];
          if (!(u.userName === entry.userName)) {
            continue;
          }
          found = true;
          u.perms.push(permEntry);
        }
        if (!found) {
          modelEntry = {
            userId: entry.userId,
            userName: entry.userName,
            perms: [permEntry],
          };
          this.viewModel.users.push(modelEntry);
          if (prevUserName === entry.userName) {
            this.viewModel.selectedUser(modelEntry);
          }
        }
      }
      dom = $($('#user_perm_tpl').html());
      ko.applyBindings(this.viewModel, dom[0]);
      return freeboard.showDialog(
        dom,
        this.L('Manage Permission'),
        this.L('Save'),
        this.L('Cancel'),
        this.savePerm
      );
    };

    PermissionViewModel.prototype.showPermUI = function () {
      var _this = this;

      freeboard.showLoadingIndicator(true);
      return $.ajax({
        url: 'permission_controller.php',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
          if (data.error != null) {
            return console.warn(
              'failed to get permission data, error: ' + data.error
            );
          } else {
            return _this.renderPermData(data.data);
          }
        },
        error: function (data, status) {
          return console.warn('failed to get permission data: ' + status);
        },
        complete: function (data, status) {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    PermissionViewModel.prototype.savePerm = function () {
      var data, perm, userData;

      userData = this.viewModel.selectedUser();
      data = {
        user_id: userData.userId,
        perms: (function () {
          var _i, _len, _ref, _results;

          _ref = userData.perms;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            perm = _ref[_i];
            _results.push(perm.postData());
          }
          return _results;
        })(),
      };
      freeboard.showLoadingIndicator(true);
      $.ajax({
        url: 'permission_controller.php',
        method: 'POST',
        dataType: 'json',
        data: data,
        success: function (data) {
          if (data.error != null) {
            return console.warn('failed to save permission data');
          }
        },
        error: function (data, status) {
          return console.warn('failed to save permission data: ' + status);
        },
        complete: function (data, status) {
          return freeboard.showLoadingIndicator(false);
        },
      });
      return false;
    };

    return PermissionViewModel;
  })();

  AccountViewModel = (function () {
    function AccountViewModel() {
      this.saveAccount = __bind(this.saveAccount, this);
      this.validatePassword = __bind(this.validatePassword, this);
      this.showAccountUI = __bind(this.showAccountUI, this);
      var btnElem;

      btnElem = $('#account_control_btn');
      btnElem.click(this.showAccountUI);
      this.viewModel = null;
      if (window.shouldChangePassword) {
        this.showAccountUI();
      }
    }

    AccountViewModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    AccountViewModel.prototype.renderAccountData = function (resp) {
      var dom,
        found,
        model,
        prevUserName,
        u,
        user,
        _i,
        _j,
        _len,
        _len1,
        _ref,
        _ref1;

      if (resp == null) {
        return;
      }
      if (
        ((_ref = this.viewModel) != null ? _ref.selectedUser : void 0) != null
      ) {
        prevUserName = this.viewModel.selectedUser().userName;
      }
      if (!prevUserName) {
        prevUserName = window.cur_account_info.name;
      }
      this.viewModel = {
        selectedUser: ko.observable(),
        users: [],
        error_msg: ko.observable(''),
      };

      for (_i = 0, _len = resp.length; _i < _len; _i++) {
        user = resp[_i];
        found = false;
        _ref1 = this.viewModel.users;
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          u = _ref1[_j];
          if (u.userName === user.name) {
            found = true;
          }
        }
        if (!found) {
          model = {
            userId: user.user_id,
            userName: user.name,
            newPassword: '',
            verifyPassword: '',
          };
          this.viewModel.users.push(model);
          if (prevUserName === user.name) {
            this.viewModel.selectedUser(model);
          }
        }
      }
      dom = $($('#user_account_tpl').html());
      ko.applyBindings(this.viewModel, dom[0]);
      dom.find('#show-new-password').off("click").on('click', function () {
        var passwordField = $(this).parent().find('#newPassword');
        var fieldType = passwordField.attr('type');
        if (fieldType === 'password') {
          passwordField.attr('type', 'text');
          $(this).children().removeClass('icon-eye-open').addClass('icon-eye-close');
        } else {
          passwordField.attr('type', 'password');
          $(this).children().removeClass('icon-eye-close').addClass('icon-eye-open');
        }
      });
      dom.find('#show-verify-password').off("click").on('click', function () {
        var passwordField = $(this).parent().find('#verifyPassword');
        var fieldType = passwordField.attr('type');
        if (fieldType === 'password') {
          passwordField.attr('type', 'text');
          $(this).children().removeClass('icon-eye-open').addClass('icon-eye-close');
        } else {
          passwordField.attr('type', 'password');
          $(this).children().removeClass('icon-eye-close').addClass('icon-eye-open');
        }
      });
      return freeboard.showDialog(
        dom,
        this.L('Manage Account'),
        this.L('Save'),
        this.L('Cancel'),
        this.saveAccount
      );
    };

    AccountViewModel.prototype.showAccountUI = function () {
      var _this = this;

      freeboard.showLoadingIndicator(true);
      return $.ajax({
        url: '../app/account_management.php',
        method: 'GET',
        dataType: 'json',
        success: function (data) {
          if (data.error != null) {
            return console.warn(
              'failed to get account data, error: ' + data.error
            );
          } else {
            return _this.renderAccountData(data.data);
          }
        },
        error: function (data, status) {
          return console.warn('failed to get account data: ' + status);
        },
        complete: function (data, status) {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    AccountViewModel.prototype.validatePassword = function () {
      var error, userData;

      this.viewModel.error_msg('');
      userData = this.viewModel.selectedUser();
      error = validatePassword(userData.newPassword, 'password');
      if (error) {
        this.viewModel.error_msg(error);
        return false;
      }
      if (userData.newPassword !== userData.verifyPassword) {
        this.viewModel.error_msg(this.L('inputed passwords are different'));
        return false;
      }
      return true;
    };

    AccountViewModel.prototype.saveAccount = function () {
      var userData;

      userData = this.viewModel.selectedUser();
      if (!this.validatePassword()) {
        return true;
      }
      freeboard.showLoadingIndicator(true);
      return $.ajax({
        url: '../app/account_management.php?user_id=' + userData.userId,
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'updateAccount',
          user: {
            id: userData.userId,
            password: userData.newPassword,
          },
        },
        success: closeFreeboardDialog,
        complete: function (data, status) {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    return AccountViewModel;
  })();

  BackupViewModel = (function () {
    function BackupViewModel() {
      this.doBackup = __bind(this.doBackup, this);
      this.showBackupPanel = __bind(this.showBackupPanel, this);
      var btnElem;

      btnElem = $('#backup_btn');
      btnElem.click(this.showBackupPanel);
      this.viewModel = null;
    }

    BackupViewModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    BackupViewModel.prototype.showBackupPanel = function () {
      var dom;

      this.viewModel = {
        name: ko.observable(moment().format('YYYYMMDD') + '_backup'),
        backupNetworkConf: ko.observable(true),
        msg: ko.observable(''),
        is_error: ko.observable(false),
      };
      dom = $($('#backup_panel_tpl').html());
      ko.applyBindings(this.viewModel, dom[0]);
      return freeboard.showDialog(
        dom,
        this.L('Backup'),
        this.L('Backup'),
        this.L('Close'),
        this.doBackup
      );
    };

    BackupViewModel.prototype.validateName = function () {
      if (/^[_0-9a-zA-Z]+$/.test(this.viewModel.name())) {
        this.viewModel.msg('');
        return true;
      } else {
        this.viewModel.is_error(true);
        this.viewModel.msg(
          '<h4>' +
          this.L(
            'backup name can only include number, character and underscore.'
          ) +
          '</h4>'
        );
        return false;
      }
    };

    BackupViewModel.prototype.doBackup = function () {
      var _this = this;

      if (!this.validateName()) {
        return true;
      }
      $.ajax({
        url: '../app/utility.php',
        method: 'POST',
        dataType: 'json',
        data: {
          action: 'backup',
          data: {
            name: this.viewModel.name(),
            type: 'flash',
            dataOnly: true,
            backupHistoryDB: true,
            backupNetworkConf: this.viewModel.backupNetworkConf(),
          },
        },
        beforeSend: function () {
          _this.viewModel.is_error(false).msg(
            '<h4>' +
            _this.L("Make backup '{name}'...").supplant({
              name: _this.viewModel.name(),
            }) +
            '</h4>'
          );
          return freeboard.showLoadingIndicator(true);
        },
        success: function (data) {
          var url;

          if (data.error) {
            _this.viewModel.is_error(true);
            return _this.viewModel.msg('<h4>' + data.error.text + '</h4>');
          } else {
            _this.viewModel.is_error(false);
            url =
              '../app/utility.php?action=download&data[name]=' +
              _this.viewModel.name() +
              '&data[type]=flash';
            return _this.viewModel.msg(
              '<h4>' +
              _this.L('Backup is done.') +
              "<a class='text-button' style='float:right' target='_blank' href='" +
              url +
              "'>" +
              _this.L('Download') +
              '</a></h4>'
            );
          }
        },
        error: function (data, status) {
          _this.viewModel.is_error(true);
          return _this.viewModel.msg(
            '<h4>' + _this.L('Backup failed: ') + status + '</h4>'
          );
        },
        complete: function () {
          return freeboard.showLoadingIndicator(false);
        },
      });
      return true;
    };

    return BackupViewModel;
  })();

  RestoreViewModel = (function () {
    function RestoreViewModel() {
      this.restoreBackup = __bind(this.restoreBackup, this);
      this.deleteBackup = __bind(this.deleteBackup, this);
      this.downloadBackup = __bind(this.downloadBackup, this);
      this.loadBackups = __bind(this.loadBackups, this);
      this.initViewModel = __bind(this.initViewModel, this);
      var btnElem;

      btnElem = $('#restore_btn');
      btnElem.click(this.loadBackups);
      this.viewModel = null;
    }

    RestoreViewModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    RestoreViewModel.prototype.initViewModel = function () {
      return (this.viewModel = {
        backups: ko.observableArray(),
        msg: ko.observable(''),
        is_error: ko.observable(false),
        restoreBackup: this.restoreBackup,
        downloadBackup: this.downloadBackup,
        deleteBackup: this.deleteBackup,
      });
    };

    RestoreViewModel.prototype.loadBackups = function () {
      var _this = this;

      this.initViewModel();
      return $.ajax({
        type: 'GET',
        url: '../app/utility.php',
        dataType: 'json',
        data: {
          action: 'list_backups',
        },
        beforeSend: function () {
          return freeboard.showLoadingIndicator(true);
        },
        success: function (data) {
          var b, _i, _len, _ref;

          if (data.backups) {
            _ref = _.sortBy(data.backups, 'ts').reverse();
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              b = _ref[_i];
              b.restoreNetworkConf = false;
              b.preset = b.name.startsWith('@');
              _this.viewModel.backups.push(b);
            }
            if (_this.viewModel.backups().length === 0) {
              _this.viewModel
                .is_error(false)
                .msg('<h4>' + _this.L('No backup available.') + '</h4>');
            }
            return _this.createRestorePanel();
          } else {
            return _this.viewModel
              .is_error(true)
              .msg(_this.L('Wrong response format: ') + JSON.stringify(data));
          }
        },
        error: function (data, status) {
          return _this.viewModel
            .is_error(true)
            .msg('<h4>' + _this.L('List backups failed: ') + status + '</h4>');
        },
        complete: function () {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    RestoreViewModel.prototype.createRestorePanel = function () {
      var dom;

      dom = $($('#restore_panel_tpl').html());
      ko.applyBindings(this.viewModel, dom[0]);
      return freeboard.showDialog(
        dom,
        this.L('Restore'),
        null,
        this.L('Close')
      );
    };

    RestoreViewModel.prototype.downloadBackup = function (backup) {
      if (backup.preset) {
        this.viewModel
          .is_error(true)
          .msg('<h4>can not download preset backup</h4>');
        return;
      }
      return window.open(
        '../app/utility.php?action=download&data[name]=' +
        backup.name +
        '&data[type]=' +
        backup.type,
        '_blank'
      );
    };

    RestoreViewModel.prototype.deleteBackup = function (backup) {
      if (backup.preset) {
        this.viewModel
          .is_error(true)
          .msg('<h4>can not delete preset backup</h4>');
        return;
      }
      var confirmed,
        _this = this;

      this.viewModel.msg('');
      confirmed = confirm(
        L("Are you sure to delete backup '{name}' ?").supplant({
          name: backup.name,
        })
      );
      if (!confirmed) {
        return;
      }
      return $.ajax({
        type: 'POST',
        url: '../app/utility.php',
        dataType: 'json',
        data: {
          action: 'delete',
          data: {
            name: backup.name,
            type: backup.type,
          },
        },
        beforeSend: function () {
          _this.viewModel.is_error(false).msg(
            '<h4>' +
            _this.L("Delete backup '{name}' ...").supplant({
              name: backup.name,
            }) +
            '</h4>'
          );
          return freeboard.showLoadingIndicator(true);
        },
        success: function (data) {
          if (data.error) {
            return _this.viewModel
              .is_error(true)
              .msg('<h4>' + data.error.text + '</h4>');
          } else {
            _this.viewModel.is_error(false).msg(
              L("<h4>Backup '{name}' is deleted!</h4>").supplant({
                name: backup.name,
              })
            );
            return _this.viewModel.backups.remove(backup);
          }
        },
        error: function (data, status) {
          return _this.viewModel.is_error(true).msg(
            '<h4>' +
            L("Failed to delete backup '{name}': {error}").supplant({
              name: backup.name,
              error: status,
            }),
            +'</h4>'
          );
        },
        complete: function () {
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    RestoreViewModel.prototype.restoreBackup = async function (backup) {
      var result = await this.doRestore(backup, false);
      if (result.error && result.error.code) {
        if (result.error.code === 1001) {
          var confirmed = confirm(L("Due to security policy updates, your account will be restored to default settings. If confirmed, you must reset your account again."));
          if (!confirmed) {
            return;
          }

          this.doRestore(backup, true);
        }
      }
    };

    RestoreViewModel.prototype.doRestore = function (backup, prompt) {
      var _this = this;

      this.viewModel.msg('');
      return $.ajax({
        type: 'POST',
        url: '../app/utility.php',
        dataType: 'json',
        data: {
          action: 'restore',
          data: {
            name: backup.name,
            type: backup.type,
            prompt: prompt,
            withNetworkConf: backup.restoreNetworkConf,
          },
        },
        beforeSend: function () {
          _this.viewModel.is_error(false).msg(
            '<h4>' +
            _this.L("Restore to backup '{name}' ...").supplant({
              name: backup.name,
            }) +
            '</h4>'
          );
          return freeboard.showLoadingIndicator(true);
        },
        success: function (data) {
          if (data.error) {
            if (data.error.code && data.error.code === 1001) {
              // do not show error message
              return freeboard.showLoadingIndicator(false, 0);
            } else {
              _this.viewModel
              .is_error(true)
              .msg('<h4>' + data.error.text + '</h4>');
              return freeboard.showLoadingIndicator(false);
            }
          } else {
            _this.viewModel.is_error(false).msg(
              '<h4>' +
              L(
                "<h4>Succeed restoring to backup '{name}'!</h4>reloading now, please wait ..."
              ).supplant({
                name: backup.name,
              }) +
              '</h4>'
            );
            return _.delay(function () {
              return location.reload();
            }, 2000);
          }
        },
        error: function (data, status) {
          _this.viewModel.is_error(true).msg(
            '<h4>' +
            L("Failed to restore backup '{name}': {error}").supplant({
              name: backup.name,
              error: status,
            }),
            +'</h4>'
          );
          return freeboard.showLoadingIndicator(false);
        },
      });
    };

    return RestoreViewModel;
  })();

  UploadViewModel = (function () {
    function UploadViewModel() {
      this.doUpload = __bind(this.doUpload, this);
      this.onUploadRestore = __bind(this.onUploadRestore, this);
      this.onUpload = __bind(this.onUpload, this);
      this.showUploadPanel = __bind(this.showUploadPanel, this);
      var btnElem;

      btnElem = $('#upload_btn');
      btnElem.click(this.showUploadPanel);
      this.viewModel = null;
      this.elem = null;
    }

    UploadViewModel.prototype.L = function (str) {
      return l18n(str, 'dashboard/js/page.js');
    };

    UploadViewModel.prototype.showUploadPanel = function () {
      var dom;

      this.viewModel = {
        msg: ko.observable(''),
        is_error: ko.observable(false),
        state: ko.observable('ready'),
        restoreNetworkConf: ko.observable(false),
        onUpload: this.onUpload,
        onUploadRestore: this.onUploadRestore,
      };
      dom = $($('#upload_panel_tpl').html());
      ko.applyBindings(this.viewModel, dom[0]);
      freeboard.showDialog(dom, this.L('Upload'), null, this.L('Close'));
      return (this.elem = dom);
    };

    UploadViewModel.prototype.validateFile = function (file) {
      var name;

      if (!file) {
        this.viewModel
          .is_error(true)
          .msg(h4(this.L('Please select a file first')));
        return false;
      }
      name = file.name;
      if (/\.tgz+$/.test(name)) {
        this.viewModel.is_error(false).msg('');
        return true;
      } else {
        this.viewModel
          .is_error(true)
          .msg(h4(this.L("Upload file must end with '.tgz'(gzipped tar)")));
        return false;
      }
    };

    UploadViewModel.prototype.onUpload = function () {
      return this.doUpload();
    };

    UploadViewModel.prototype.onUploadRestore = function () {
      return this.doUploadRestore();
    };

    UploadViewModel.prototype.doUploadRestore = async function () {
      var result = await this.doUpload(true);
      if (result.error && result.error.code) {
        if (result.error.code === 1001) {
          var confirmed = confirm(L("Due to security policy updates, your account will be restored to default settings. If confirmed, you must reset your account again."));
          if (!confirmed) {
            return;
          }

          var _this = this;
          var backup = result.backup;
          return $.ajax({
            type: 'POST',
            url: '../app/utility.php',
            dataType: 'json',
            data: {
              action: 'restore',
              data: {
                name: backup.name,
                type: backup.type,
                prompt: true,
                withNetworkConf: backup.withNetworkConf,
              },
            },
            beforeSend: function () {
              _this.viewModel.is_error(false).msg(
                '<h4>' +
                _this.L("Restore to backup '{name}' ...").supplant({
                  name: backup.name,
                }) +
                '</h4>'
              );
              return freeboard.showLoadingIndicator(true);
            },
            success: function (data) {
              if (data.error) {
                _this.viewModel
                .is_error(true)
                .msg('<h4>' + data.error.text + '</h4>');
                return freeboard.showLoadingIndicator(false);
              } else {
                _this.viewModel.is_error(false).msg(
                  '<h4>' +
                  L(
                    "<h4>Succeed restoring to backup '{name}'!</h4>reloading now, please wait ..."
                  ).supplant({
                    name: backup.name,
                  }) +
                  '</h4>'
                );
                return _.delay(function () {
                  return location.reload();
                }, 2000);
              }
            },
            error: function (data, status) {
              _this.viewModel.is_error(true).msg(
                '<h4>' +
                L("Failed to restore backup '{name}': {error}").supplant({
                  name: backup.name,
                  error: status,
                }),
                +'</h4>'
              );
              return freeboard.showLoadingIndicator(false);
            },
          });
        }
      }
    };

    UploadViewModel.prototype.doUpload = function (restoreNow) {
      return new Promise((resolve,reject)=>{
        var data,
        _this = this;
        data = {
          action: 'upload',
          'data[type]': 'flash',
          'data[withNetworkConf]': this.viewModel.restoreNetworkConf,
          'data[prompt]': 'false',
        };
        if (restoreNow) {
          data['data[restoreNow]'] = 'true';
        }
        this.elem.find('form').ajaxSubmit({
          type: 'POST',
          url: '../app/utility.php',
          data: data,
          dataType: 'json',
          beforeSubmit: function (arr, form, options) {
            var a, i, index, _i, _len;
  
            index = -1;
            i = 0;
            for (_i = 0, _len = arr.length; _i < _len; _i++) {
              a = arr[_i];
              if (a.name === 'backupTarBall') {
                index = i;
                break;
              } else {
                ++i;
              }
            }
            if (index === -1) {
              _this.viewModel.is_error(true).msg(h4(L('Invalid form data')));
              return false;
            }
            if (arr[index].name === 'backupTarBall') {
              if (!_this.validateFile(arr[index].value)) {
                return false;
              }
              _this.viewModel
                .is_error(false)
                .msg(h4(L('Uploading file ...')))
                .state('uploading');
              freeboard.showLoadingIndicator(true);
              return true;
            }
          },
          uploadProgress: function (event, pos, total, percentComplete) {
            _this.viewModel.msg(
              h4(
                L('Uploading file ({percent}%) ...').supplant({
                  percent: percentComplete,
                })
              )
            );
            if (percentComplete === 100) {
              return _this.viewModel.msg(
                h4(L('Uploaded. Start to unpack it ...'))
              );
            }
          },
          success: function (data, statusText, xhr, form) {
            resolve(data);
            if (data.redirect != null) {
              return (window.location.href = data.redirect);
            } else {
              if (data.error != null) {
                if (data.error.code && data.error.code === 1001) {
                  // do not show error message
                  return;
                } else {
                  return _this.viewModel.is_error(true).msg(h4(data.error.text));
                }
              } else {
                if (data.msg != null) {
                  _this.viewModel.is_error(false).msg(h4(data.msg));
                } else {
                  _this.viewModel.is_error(false).msg(h4(L('All Done!')));
                }
                if (data.reloadRequired != null && data.reloadRequired) {
                  return _.delay(function () {
                    _this.viewModel
                      .is_error(false)
                      .msg(h4(L('Reloading now ...')));
                    return location.reload();
                  }, 2000);
                }
              }
            }
          
          },
          complete: function () {
            _this.viewModel.state('ready');
            return freeboard.showLoadingIndicator(false, 0);
          },
        });
        return true;
      });
    };

    return UploadViewModel;
  })();

  head.js(window.widgetUrls, function () {
    return $(function () {
      $(document).ajaxComplete(ajaxCompleteHandler);
      freeboard.initialize(
        window.perms.canManageDataSource || window.perms.canManageWidget
      );
      window.manager = new DashboardManager();
      window.sidebarControl = new SidebarControl();
      window.permViewModel = new PermissionViewModel();
      window.accountViewModel = new AccountViewModel();
      window.backupViewModel = new BackupViewModel();
      window.restoreViewModel = new RestoreViewModel();
      window.uploadViewModel = new UploadViewModel();
      $(window).trigger('uiReady');
      manager.loadDashboards();
      $(window).on('beforeunload', function (e) {
        var confirmMessage, enableConfirmOnClose;

        enableConfirmOnClose = Cookies.get('UIOption.enableConfirmOnClose');
        if (enableConfirmOnClose) {
          enableConfirmOnClose = enableConfirmOnClose === 'true';
        } else {
          enableConfirmOnClose = false;
        }
        if (!(enableConfirmOnClose && isDashboardModified())) {
          return void 0;
        }
        _.defer(function () {
          var inst, selected_ids;

          inst = $('#jstree').jstree(true);
          if (!inst) {
            return;
          }
          selected_ids = inst.get_selected();
          inst.deselect_node(selected_ids);
          return inst.select_node(window.curDashboardId, true);
        });
        confirmMessage = 'Do you want to leave this page ?';
        (e || window.event).returnValue = confirmMessage;
        return confirmMessage;
      });
      $(window).on('unload', function () {
        return freeboard.showLoadingIndicator(true);
      });
      return ($.fn.progress_fnc = function (options) {
        var div, progress, settings;

        settings = $.extend(
          {
            type: 'start',
          },
          options
        );
        div = $(this);
        progress = div.find('.cssProgress');
        return progress.each(function () {
          var percentage, progress_bar, progress_label, progress_value, self;

          self = $(this);
          progress_bar = self.find('.cssProgress-bar');
          progress_label = self.find('.cssProgress-label, .cssProgress-label2');
          progress_value = progress_bar.data('percent');
          percentage = parseInt(progress_value, 10) + '%';
          progress_bar.css({
            transition: 'none',
            '-webkit-transition': 'none',
            '-moz-transition': 'none',
          });
          if (settings.type === 'start') {
            progress_bar.width(percentage);
            return progress_label.text(percentage);
          } else if (settings.type === 'reset') {
            progress_bar.css('width', '0%');
            return progress_label.text('0%');
          } else {
            return console.warn('invalid settings.type: ' + settings.type);
          }
        });
      });
    });
  });
}.call(this));
