<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "settings.php";
include_once "base_controller.php";

class SettingsController extends BaseController {
  protected function signinRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $u = $this->curUser();
    $response = array();
    if (!$u->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("permission denied"));

    $s = Settings::instance();
    $ttl_enabled = $s->value('session', 'ttl_enabled', 'f');
    $ttl_value = $s->session_ttl_val();

    $response = "{\"data\": {\"ttl_enabled\": \"$ttl_enabled\", \"ttl_value\": \"$ttl_value\"}}";
    die($response);
  }
  
  protected function doAjaxPost() {
    $response = array();
    $u = $this->curUser();
    if (!$u->isAccountManagementEnabled())
      $this->renderAjaxError($response, L("permission denied"));

    $action = $_POST['action'];
    if ($action == 'updateSessionTTL')
      $this->updateSessionTTL($response);
    else
      $this->renderAjaxError($response, sprintf(L("action %s is not supportted"), $action));
    $this->renderAjaxSuccess($response);
  }

  protected function updateSessionTTL($response) {
    $s = Settings::instance();
    $s->setValue('session', 'ttl_enabled', $_POST['ttl_enabled']);
    $s->setValue('session', 'ttl_value', $_POST['ttl_value']);
    $s->save();

    return $response;
  } 
  
}

$controller = new SettingsController();
$controller->run();

?>
