<?php 
include_once "db.php";
include_once "base_controller.php";
include_once "notification_client.php";
include_once "datetime_utils.php";
include_once "fi_config_file.php";
include_once "jwt_key_store.php";

class ProvisionController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  protected function adminRequired() {
    return true;
  }
  
  protected function doAjaxPost() {
    $response = array();
    $action = $_POST['action'];
    
    $err = "";
    if ($action == 'deploy_pub_key') {
      $err = $this->deployPubKey();
    } else if ($action == 'delete_tunnel') {
      $err = $this->deleteTunnel();
    } else if ($action == 'link_account_ids') {
      $err = $this->linkAccountWithId(true);
    } else if ($action == 'link_accounts') {
      $err = $this->linkAccounts(true);
    } else if ($action == 'unlink_accounts') {
      $err = $this->linkAccounts(false);
    } else {
      $this->renderAjaxError($response, sprintf(L("action %s is not supportted"), $action));
    }
    if (empty($err))
      $this->renderAjaxSuccess($response);
    else
      $this->renderAjaxError($response, $err);
  }

  private function deployPubKey() {
    $ip = clientIP();
    if (empty($ip)) {
      return L("invalid IP");
    }
    if (!isset($_POST['data']))
      return L("invalid data parameter");
    $data = $_POST['data'];

    if (!isset($data['issuer']))
      return L("invalid 'issuer' parameter");
    $issuer = $data['issuer'];
    if (!isset($data['pub_key']))
      return L("invalid 'pub_key' parameter");
    $pub = $data['pub_key'];

    $pname = platformName();
    $store = new JWTKeyStore($pname);
    $result = $store->update($issuer, $pub);
    if (!$result)
      return sprintf(L("failed to save public key for issuer: '%s'"), $issuer);

    $fiConfFile = new FIConfigFile($pname);
    $ntpServer = null;
    if (isset($data['ntp_server'])) {
      $ntpServer = $data['ntp_server'];
    } 
    if (isset($data['msg_queue_addr'])) {
      $parts = explode(":", $data['msg_queue_addr']);
      $port = filter_var(end($parts), FILTER_VALIDATE_INT);
      if ($port === false){
        $port = 6379;
      }
      $addr = "$ip:$port";
      $fiConfFile->set("msg_queue_addr", $addr);

      // if no 'ntp_server' param, use the ip of 'clientIP' as ntp_server
      if (empty($ntpServer)) {
        $ntpServer = $ip;
      }
    }
    if (isset($data['device_id'])) {
      $fiConfFile->set("device_id", $data['device_id']);
    }
    if (isset($data['checksum_key'])) {
      $fiConfFile->set("checksum_key", $data['checksum_key']);
    }

    if (!$fiConfFile->save())
      return L("failed to save fi device config");

    NotificationClient::sendNetworkUpdate(); 

    $this->configFINTPServer($ntpServer);
    return null;
  }
  private function deleteTunnel()
  {
    $fiConfFile = new FIConfigFile(platformName());
    $fiConfFile->delete("msg_queue_addr");
    $fiConfFile->delete("device_id");
    $fiConfFile->delete("checksum_key");

    if (!$fiConfFile->save())
      return L("failed to save fi device config");

    //clear FI NTP server
    $this->configFINTPServer("");
    return null;
  }
  private function linkAccountWithId($link) {
    if (!isset($_POST['accounts']))
      return L("no 'accounts' parameter");

    $ids = explode(',', $_POST['accounts']);
    if (!is_array($ids) || count($ids) == 0)
      return L("invalid 'accounts' parameter");
    
    return User::linkAccountWithId($ids, $link); 
  }

  private function linkAccounts($link) {
    if (!isset($_POST['accounts']))
      return L("no 'accounts' parameter");

    $accounts = explode(',', $_POST['accounts']);
    if (!is_array($accounts) || count($accounts) == 0)
      return L("invalid 'accounts' parameter");
    
    return User::linkAccounts($accounts, $link); 
  }

  private function configFINTPServer($ntpServer) {
    if (is_null($ntpServer)) {
      error_log("there is no ntp server config");
      return;
    }

    $utils = new DateTimeUtils();
    $utils->setupFINTPServer($ntpServer);
  }
}

$controller = new ProvisionController();
$controller->run();
?>
