<?php // vim: filetype=php

error_log(" * add 'jwt_keys' table ...");

$db->exec(<<<EOD
  CREATE TABLE jwt_keys (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    issuer varchar(32) NOT NULL UNIQUE,
    key varchar(2048),
    pub varchar(1024) NOT NULL,
    created_at datetime DEFAULT current_timestamp
  );
EOD
);

error_log(" * generate JWT public/private key for itself ...");

$rand = randStr();
$key_file = "/tmp/key_$rand.pem";
$pub_file = "/tmp/pub_$rand.pem";

if (system("openssl genrsa -out $key_file 2048") !== false
  && system("openssl rsa -in $key_file -pubout -out $pub_file") !== false) {
  $key = file_get_contents($key_file);
  $pub = file_get_contents($pub_file);

$db->exec(<<<EOD
  INSERT INTO jwt_keys (issuer, key, pub) VALUES ('EIO_SELF', '$key', '$pub');
EOD
);

// output pub keys to file system
$keysFolder = "/mnt/data/jwt_keys";
if (!file_exists($keysFolder)) mkdir($keysFolder, 750, true);
$filePath = $keysFolder . "/EIO_SELF.pub";
file_put_contents($filePath, $pub);

} else {
  error_log("failed to generate jwt key");
}

unlink($key_file);
unlink($pub_file);

?>
