<?php
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__DIR__));

include_once "notification_client.php";
include_once "base_middleware.php";

// this middleware is for easyioAlarm, not for alarmDB
class UserMiddleware extends BaseMiddleware{
  public function postHook($url, $method, $statusCode) {
    if ($statusCode != 200 
      || $method != "POST" 
      || (
        preg_match("#/account_management\.php#i", $url) == 0
        && preg_match("#/provision_controller\.php$#i", $url) == 0
      )
    )
      return true;

    if (!isset($_REQUEST["action"]))
      return true;

    $action = $_REQUEST["action"];
    if ($action == "createAccount" 
      || $action == "updateAccount" 
      || $action == "deleteAccount"
      || $action == "link_accounts"
      || $action == "unlink_accounts"
      ) {
      NotificationClient::publish("user.events", array("event" => $action));
    }
    return true;
  }
}

?>
