<?php
// vim: ts=2 sw=2

set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__DIR__));

include_once "db.php";
include_once "notification_client.php";
include_once "base_middleware.php";

class DBHousekeepingMiddleware extends BaseMiddleware {
  protected function updateDeltaChange() {
    $stamp_file = "/tmp/cpt-db-housekeeping.stamp";
    if (!file_exists($stamp_file)) {
      touch($stamp_file);
      return;
    }

    $now = time();
    //only do db housekeeping every 1 hours
    if ($now-filemtime($stamp_file) < 3600)
      return;

    DeltaChange::houseKeep();
    touch($stamp_file);
    return; 
  }

  protected function updateCompInfo() {
    $model = new CompInfo ;
    if ($model->loadCompInfo())
      NotificationClient::publish("sedona.compinfo", array("event" => "update"));
  }

  public function postHook($url, $method, $statusCode) {
    if ($statusCode != 200)
      return true;

    $this->updateDeltaChange();
    if ($method == "updateCompInfo") {
        $this->updateCompInfo();
    }

    return true;
  }
}

?>
