<?php 
// vim: ts=2 sw=2

include_once "config.php";

$json = NULL;

$availableTranslations = array(
  array('en', 'English'),
  array('zh_CN', '简体中文'),
  array('ko', '한국의'),
  array('de', 'Deutsch'),
  // ['fr', 'Français'],
);

function getLang() {
  if (isset($_GET['lang'])) {
    $_SESSION['lang'] = $_GET['lang'];
    return $_SESSION['lang'];
  }
  else if (isset($_SESSION) && isset($_SESSION['lang']))
    return $_SESSION['lang'];
  else {
    if (class_exists('Config') && isset(Config::$uiLang))
      return Config::$uiLang;
    else
      return NULL;
  }
}

function langJsonPath($type='backend') {
  $lang = getLang();
  if (!isset($lang))
    return NULL;
  
  $level = 2;
  $curPath = __FILE__;
  $parts = explode(DIRECTORY_SEPARATOR, $curPath);
  for($i=0; $i<$level; ++$i)
    array_pop($parts);
  $cptBasePath = realpath(implode(DIRECTORY_SEPARATOR, $parts));
  $langFilePath = realpath(implode(DIRECTORY_SEPARATOR, array($cptBasePath, 'langs', "cpt-web_{$type}_{$lang}.json")));
  
  if (strpos($langFilePath, $cptBasePath) !== 0 || !file_exists($langFilePath))
    return NULL;
  return $langFilePath;
}

function loadLang() {
  global $json;
  if (isset($json))
    return $json;

  if (!function_exists("json_decode"))
      return NULL;

  $langFilePath = langJsonPath();
  if (is_null($langFilePath))
    return NULL;

  error_log('load lang json file: ' . $langFilePath);
  $json = json_decode(file_get_contents($langFilePath), true);
  if (isset($json) && $json)
    return $json;
  else
    return NULL;
}

/**
 * Return relative path between two sources
 * @param $from
 * @param $to
 * @param string $separator
 * @return string
 */
function relativePath($from, $to, $separator = DIRECTORY_SEPARATOR)
{
  $from   = str_replace(array('/', '\\'), $separator, $from);
  $to     = str_replace(array('/', '\\'), $separator, $to);

  $arFrom = explode($separator, rtrim($from, $separator));
  $arTo = explode($separator, rtrim($to, $separator));
  while(count($arFrom) && count($arTo) && ($arFrom[0] == $arTo[0]))
  {
    array_shift($arFrom);
    array_shift($arTo);
  }

  return str_pad("", count($arFrom) * 3, '..'.$separator).implode($separator, $arTo);
}

function L($str, $context=NULL) {
  $json = loadLang();
  if (!isset($json))
    return $str;

  if (!isset($context)) {
    $webRootPath = dirname(__FILE__, 4);
    $cptBasePath = dirname(__FILE__, 2);
    $fullScriptPath = $webRootPath . dirname($_SERVER['PHP_SELF']);
    $name = basename($_SERVER['PHP_SELF']);
    $context = relativePath($cptBasePath, $fullScriptPath) . DIRECTORY_SEPARATOR . $name;
  }

  if (!array_key_exists($context, $json))
    return $str;

  if (!array_key_exists($str, $json[$context]))
    return $str;
  else
    return isset($json[$context][$str]) ? $json[$context][$str] : $str;
}

function frontendLangJson() {
  $langFilePath = langJsonPath('frontend');
  if (!is_null($langFilePath))
  {
    $content = file_get_contents($langFilePath);
    echo "<script type='application/json' id='l18nJson'> {$content} </script>";
  }
  else
    return;
}

?>
