<?php
//vim: ts=2 sw=2

class JWTKeyStore {
  protected $platform = null;

  public function __construct($platform)
  {
    $this->platform = $platform;
    $dir = $this->store_dir();
    if (!empty($dir) && !file_exists($dir))
      mkdir($dir, 0700, true);
  }

  protected function store_dir()
  {
    if ($this->platform == "FS") 
      return "/mnt/data/jwt_keys";
    else if ($this->platform == "FW")
      return "/mnt/backup/tmp/jwt_keys";
    else if ($this->platform == "FI")
      return "/var/www/ems/keys";
    else
      return null;
  }  

  public function key_for($issuer) {
    if (empty($issuer)) return null;

    $dir = $this->store_dir();
    if (is_null($dir)) return null;

    if ($this->platform == "FI") {
      error_log("no permission to get FI's private key");
      return null;
    }
    else
      $file_path = $dir . '/' . $issuer . '.key';
    $content = file_get_contents($file_path);
    return $content === false ? null : $content;
  }

  public function pub_for($issuer) {
    if (empty($issuer)) return null;

    $dir = $this->store_dir();
    if (is_null($dir)) return null;

    if ($this->platform == "FI") 
      $file_path = $dir . '/public.pem';
    else
      $file_path = $dir . '/' . $issuer . '.pub';
    $content = file_get_contents($file_path);
    return $content === false ? null : $content;
  }

  public function update($issuer, $pub, $key=null) {
    if ($this->platform == "FI") {
      error_log("can not update pub or key on FI platform");
      return false;
    }

    $dir = $this->store_dir();
    if (is_null($dir)) return false;

    $file_path = $dir . '/' . $issuer . '.pub';
    $result = file_put_contents($file_path, $pub);
    if ($result === false) return false;

    if (is_null($key)) return true;

    $file_path = $dir . '/' . $issuer . '.key';
    return file_put_contents($file_path, $key) !== false;
  }

  public function gen_self_key_pair() {
    if ($this->platform == "FI") {
      error_log("can not generate self key pair on FI platform");
      return false;
    }
    $dir = $this->store_dir();
    if (is_null($dir)) return false;

    $issuer = 'EIO_SELF';
    $pub_file = $dir . '/' . $issuer . '.pub';
    $key_file = $dir . '/' . $issuer . '.key';
    if (system("openssl genrsa -out ${key_file}.tmp 2048") === false
      || system("openssl rsa -in ${key_file}.tmp -pubout -out ${pub_file}.tmp") === false)
      return false;

    rename("${key_file}.tmp", $key_file);
    rename("${pub_file}.tmp", $pub_file);
    return true;
  }
}

?>
