<?php
//vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class HistorySyncController extends BaseController {
  protected $MAX_RECORD_NUM_PER_REQ = 2000;

  protected function signinRequired() {
    return true;
  }

  protected function adminRequired() {
    return true;
  }

  protected function doAjaxGet() {
    $response = array();
    $action = null;
    if (isset($_GET['action']))
      $action = $_GET['action'];
    else
      $this->renderAjaxError($response, sprintf(L("'%s' parameter is missing"), 'action'));

    if ($action == "list_tables")
      $this->listTables();
    else if ($action == "fetch_delta")
      $this->fetchDelta();
    else {
      error_log("invalid action: " . $action);
      $this->renderAjaxError($response, sprintf(L("%s is not supported"), $action));
      return;
    }
  }

  protected function listTables() {
    $response = array();
    $model = new HistoryDelta();
    $allTables = $model->listTables();
    $tables = array();
    foreach($allTables as $table) {
      if (strpos($table['sql'], "'dt'") === false) continue;
      $tables[] = $table; 
    }
    $data = array("tables" => $tables,
      "sync_time" => time());
    $response["data"] = $data;
    $this->renderAjaxSuccess2($response);
  }

  protected function fetchDelta() {
    $response = array();
    $tables = array();
    if (isset($_GET['tables']))
      $tables = explode(",", $_GET['tables']);
    else
      $this->renderAjaxError($response, sprintf(L("'%s' parameter is missing"), 'tables'));

    $from_dates = null;
    if (isset($_GET['from_dates']))
      $from_dates = explode(",", $_GET['from_dates']);
    else
      $this->renderAjaxError($response, sprintf(L("'%s' parameter is missing"), 'from_dates'));

    if (count($tables) != count($from_dates))
      $this->renderAjaxError($response, sprintf(L("the numbers of '%s' and '%s' don't match"), 'tables', 'from_dates'));

    $count = $this->MAX_RECORD_NUM_PER_REQ;
    if (isset($_GET['count']))
      $count = min(intval($_GET['count']), $this->MAX_RECORD_NUM_PER_REQ);

    $result = array();
    $model = new HistoryDelta();
    foreach($tables as $index => $table) {
      $from_date = $from_dates[$index];
      $result[$table] = $model->fetchDelta($table, $from_date, $count);
    }
    $response['data'] = $result;
    $this->renderAjaxSuccess2($response);
  }
}

$controller = new HistorySyncController();
$controller->run();

?>
