<?php 
//vim: ts=2 sw=2

include_once "lang.php";
include_once "utils.php";
include_once "service_utils.php";

class DateTimeUtils {
  protected function setupFINTPServerFW($timeServer) {
    $utils = new ServiceUtils();
    $serviceName = $utils->ntpServiceName();
    $cmd = "";
    $delCmd = "sed -i -e '/^config timeserver/,/^\s*$/ {/ ### FI NTP SERVER ###\s*$/d; /### FI NTP SERVER START ###$/,/### FI NTP SERVER END ###$/d}' /etc/config/system";
    if (empty($timeServer)) {
      $cmd = <<<EOC
        {$delCmd} && /etc/init.d/{$serviceName} restart
EOC;
    } else {
      $cmd = <<<EOC
        {$delCmd} && sed -i -e '/^config timeserver/,/^\s*list server/ {/option enable_server/ a\
\\\t### FI NTP SERVER START ###\
\\\tlist server "$timeServer"\
\\\t### FI NTP SERVER END ###
        }' /etc/config/system && /etc/init.d/{$serviceName} restart
EOC;
    }
    $result = execShellCmd($cmd);

    if (file_exists('/etc/chrony/chrony.conf')) {
      $cmd = <<<EOC
      sed -i -e '/### FI NTP SERVER START ###\s*$/,/### FI NTP SERVER END ###\s*$/d' /etc/config/chrony && sed -i -e '1i\
### FI NTP SERVER START ###\
config server\
\\\toption hostname $timeServer \
\\\toption minpoll '2' \
\\\toption maxpoll '4' \
\\\toption iburst 'yes' \
\\\toption version '3' \
### FI NTP SERVER END ###
' /etc/config/chrony && /etc/init.d/{$serviceName} restart
EOC;
      $result = execShellCmd($cmd);
    }

    //mostly for FW platform, after config change, call writeConfig to make
    //the change survive during firmware flashing
    if (file_exists("/mnt/sedona/writeConfig")) {
      $output = array();
      $return_var = 0;
      exec('/mnt/sedona/writeConfig', $output, $return_var);
      if ($return_var != 0)
        error_log("failed to run writeConfig: " . implode($output, "\n"));
    }
    return $result;
  }
  protected function setupFINTPServerFS($timeServer) {
    $utils = new ServiceUtils();
    $serviceName = $utils->ntpServiceName();
    $confPath = "/etc/{$serviceName}.conf"; 

    $cmd = "sed -i -e '/ ### FI NTP SERVER ###$/d' -e '/### FI NTP SERVER START ###$/,/### FI NTP SERVER END ###$/d' $confPath";
    if (empty($timeServer)) {
      $cmd .= " && /etc/init.d/S??{$serviceName} restart";
    } else { 
      $editCmd = <<<EOC
        sed -i -e '$ a\
### FI NTP SERVER START ###\
server $timeServer iburst minpoll 2 maxpoll 4 version 3\
### FI NTP SERVER END ###' $confPath && /etc/init.d/S??{$serviceName} restart
EOC;
      $cmd = $cmd . " && " . $editCmd;
    }
    return execShellCmd($cmd);
  }

  public function setupFINTPServer($fiNtpServer) {
    $platform = platformName(); 
    if ($platform == "FW")
      $this->setupFINTPServerFW($fiNtpServer);
    else if ($platform == "FS")
      $this->setupFINTPServerFS($fiNtpServer);
  }
}

?>
