<?php
//vim: ts=2 sw=2
set_include_path(get_include_path() . PATH_SEPARATOR . '../plugins/DataServiceConfig');
include_once "base_controller.php";
//include "HttpClient.class.php";
include_once "UDPClient.class.php";
include_once "mqtt_service_base.php";

class DataAPIController extends BaseController { 
  public $host, $port;
  private $client;

  function __construct() {
    $this->host = "127.0.0.1";
    //$this->port = "88"; // for weblet
    $this->port = "1001"; // for udp service

    $this->client = NULL;
  }

  function forwardHostName() {
    return $this->host . ":" . $this->port;
  }

  function getClient() {
    if (is_null($this->client))
    {
      $this->client = new UDPClient($this->host, $this->port);
      //$this->client = new HttpClient($this->forwardHostName());
      $this->client->setDebug(false);
    }
    return $this->client;
  }

  protected function sameHostAuthFree() {
    return true;
  }

  protected function signinRequired() {
    return true;
  }
  protected function authKeyRequired() {
    return true;
  }

  public function doAjaxGet() {
    $response = array();
    if (!$this->sameHostAuthFree() && !$this->isReadable()) {
      $this->renderAjaxError($response, L("permission denied"));
    }

    $action = null;
    if (isset($_GET['action']))
      $action = $_GET['action']; 

    if ($action == 'query') {
      $this->doQuery();
    } else {
      $newUrl = $this->forwardURL();
      $client = $this->getClient();
      if ($client->get($newUrl)) {
        $content = $client->getContent();
        if (empty($content))
            die('{"response": ""}');
        else
            die('{"response": ' . $content . '}');
      }
      else
      {
        // die('An error occurred: ' . $client->getError());
        die('{"error": {"text": "' . L('failed to get data: ') . $client->getError() . '"}}');
      }
    }
  }

  protected function doQuery() {
    $response = array();

    $uuid = null;
    if (isset($_REQUEST['uuid']))
      $uuid = trim($_REQUEST['uuid']);

    if (empty($uuid)) 
      $this->renderAjaxError($response, L("query parameter is missing"));

    $model = new CompInfo(); 
    $model->loadCompInfo();
    $rs = $model->query($uuid);
    $response['comp_info'] = $rs;
    $this->renderAjaxSuccess2($response);
  }

  protected function syncSchedule() {
    $response = array();
     
    $schedule = null;
    if (isset($_REQUEST['schedule']))
      $schedule = $_REQUEST['schedule'];

    if (is_null($schedule) || strlen($schedule) <= 0) {
      $this->renderAjaxError($response, L("invalid schedule data"));
      return;
    }

    $dir = build_file_path('', 'tmp', 'payloads', 'schedule');
    if (!file_exists($dir)) {
      if (!mkdir($dir, 0777, true)) {
        $this->renderAjaxError($response, L("failed to create schedule payload tmp folder"));
        return;
      }
    }

    $tmp_file_name = '' . time() . '_' . randStr(4) . '.json';
    $tmp_file_path = build_file_path($dir, $tmp_file_name);
    if (false === file_put_contents($tmp_file_path, $schedule)) {
      $this->renderAjaxError($response, L("failed to create schedule payload file"));
      return;
    }

    $client = $this->getClient();
    $path = '/app/objects/service/scheduleService.syncFromJsonFile';
    $type = 'Str';
    // value is the relative payload file path
    $value = build_file_path('schedule', $tmp_file_name);
    $client->invokeAction($path, $type, $value);
    $content = $client->getContent();
    if (empty($content))
      $response['response'] = '';
    else
      $response["response"] = $content;
    $this->renderAjaxSuccess2($response);
  }

  public function doAjaxPost() {
    $response = array();
    if (!$this->sameHostAuthFree() && !$this->isWritable()) {
      $this->renderAjaxError($response, L("permission denied"));
    }

    $action = null;
    if (isset($_POST['action']))
      $action = $_POST['action']; 

    if ($action == 'syncSchedule') {
      $this->syncSchedule();
    } else {
      $client = $this->getClient();
      if (isset($_POST['reqs']) && is_array($_POST['reqs'])) {
        if (count($_POST['reqs']) > 255)
          $this->renderAjaxError($response, L("at most 255 requests at one time."));

        $is_action = isset($_POST['is_action']) && boolval($_POST['is_action']);
        $client->doMultiRequest($is_action, $_POST['reqs']);
      } else {
        if ($_POST['slotType'] == 'action') {
          if (preg_match("/\/\.reboot$/", $_POST['path'])) {
            $mqtt = new MQTTServiceBase();
            $mqtt->notifyShutdown();
          }
          $client->invokeAction($_POST['path'], $_POST['type'], $_POST['value']);
        }
        elseif ($_POST['slotType'] == 'property')
          $client->writeProperty($_POST['path'], $_POST['type'], $_POST['value']);
        else {
          if (isset($_POST['slotType']))
            $this->renderAjaxError($response, "invalid 'slotType' value: " . $_POST['slotType']);
          else
            $this->renderAjaxError($response, "'slotType' parameter is missing");
        }
      }
      $content = $client->getContent();
      if (empty($content))
        die('{"response": ""}');
      else
        die('{"response": ' . $content . '}');
    }
  }

  function forwardURL() {
    if (function_exists("filter_var"))
        return filter_var($_GET['url'], FILTER_SANITIZE_URL);
    else
        return $_GET['url'];
    //if($_SERVER['QUERY_STRING']=="")
    //return $path;
    //else
    //return $path. "?" . $_SERVER['QUERY_STRING'];
  }
}

$controller = new DataAPIController();
$controller->run();

?>
