<?php
// vim: ts=2 sw=2

function enableCache() {
  header("Cache-Control: public"); // HTTP 1.1.
  header("Expires: 0"); // Proxies.
}

function disableCache() {
  # refers: http://stackoverflow.com/questions/49547/how-to-control-web-page-caching-across-all-browsers
  header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
  header("Pragma: no-cache"); // HTTP 1.0.
  header("Expires: 0"); // Proxies.
}

function assetCacheParam($assetPath) {
  if ($assetPath === null || $assetPath === '')
    return '';

  $filePath = $assetPath;
  if ($filePath[0] === DIRECTORY_SEPARATOR) {
    $rootPath = $_SERVER['DOCUMENT_ROOT'];
    $filePath = $rootPath . $assetPath;
  }

  if (file_exists($filePath)) {
    $stats = stat($filePath);
    if (!$stats || !isset($stats['mtime']) || !isset($stats['size']))
      return $assetPath;

    return $assetPath . "?stamp=" . $stats['mtime'] . "_" . $stats['size'];
  } else {
    return $assetPath;
  }
}

function A($assetPath) {
  echo assetCacheParam($assetPath);
}

//parse asset files and append cache param to support cache busting
function appendAssetCacheParam($content, $prefix) {
  if ($content === null || $content === '')
    return $content;

  if ($prefix === null)
    $prefix = '';

  $pat = '|"('.$prefix.'[^"]+)"|';
  return preg_replace_callback(
    $pat, 
    function($matches) {
      if (count($matches) < 2)
        return $matches[0];

      $path = $matches[1];
      if (!file_exists($path))
        return $matches[0];

      return '"'.assetCacheParam($path).'"';
    }, 
    $content
  );
}
