<?php
// vim: ts=2 sw=2

include_once "db.php";
include_once "base_controller.php";

class AuthKeyController extends BaseController {
  protected function signinRequired() {
    return true;
  }
  
  protected function adminRequired() {
    return true;
  }
  
  protected function doAjaxGet() {
    $model = new AuthKeys();
    $keys = $model->keys();
    
    $rows = array();
    foreach($keys as $key) {
      $rows[] = map2json($key);
    }

    $response = "{\"data\":  [" . implode(',', $rows) . "] }";
    die($response);
  }
  
  protected function doAjaxPost() {
    $response = array();
    $action = $_POST['action'];
    
    if ($action == 'create') {
      $response = $this->create($response);
    } else if ($action == 'update') {
      $response = $this->update($response);
    } else if ($action == 'delete') {
      $response = $this->destroy($response);
    } else {
      $this->renderAjaxError($response, sprintf(L("action %s is not supportted"), $action));
    }
    $this->renderAjaxSuccess($response);
  }
  
  protected function create($response) {
    $note = $_POST['note'];
    $expired_at = $_POST['expired_at'];

    $model = new AuthKeys();
    $new_key = $model->createKey($note, $expired_at);

    $response['new_key'] = $new_key;
    return $response;
  }
  
  protected function update($response) {
    $key = $_POST['key'];
    $note = $_POST['note'];
    $expired_at = $_POST['expired_at'];

    $model = new AuthKeys();
    $model->updateKey($key, $note, $expired_at);

    return $response;
  }
  
  protected function destroy($response) {
    $key = $_POST['key'];
    
    $model = new AuthKeys();
    $model->deleteKey($key);
    return $response;
  }
}

$controller = new AuthKeyController();
$controller->run();

?>
